/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.wadl.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.ElementPropertyBinding;

public class Wadl2JavaModelResource
extends Resource {
    private final ElementType type;
    private IProject project;
    private IStructuredSelection selection;

    public Wadl2JavaModelResource(ElementType type, IProject project) {
        this(type, null, project);
    }

    public Wadl2JavaModelResource(ElementType type, Wadl2JavaModelResource parent, IProject project) {
        super((Resource)parent);
        this.type = type;
        this.project = project;
    }

    public ElementType type() {
        return this.type;
    }

    public Wadl2JavaModelResource parent() {
        return (Wadl2JavaModelResource)super.parent();
    }

    public Wadl2JavaModelResource root() {
        return (Wadl2JavaModelResource)super.root();
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        Object binding = null;
        if (p instanceof ValueProperty) {
            binding = new ValuePropertyBinding(){
                private String value;

                public String read() {
                    return this.value;
                }

                public void write(String value) {
                    this.value = value;
                }
            };
        } else if (p instanceof ImpliedElementProperty) {
            binding = new ElementPropertyBinding(p){
                private final Wadl2JavaModelResource element;
                {
                    this.element = new Wadl2JavaModelResource(propertyDef.getType(), Wadl2JavaModelResource.this, Wadl2JavaModelResource.this.project);
                }

                public ElementType type(Resource resource) {
                    return ((Wadl2JavaModelResource)resource).type();
                }

                public Resource read() {
                    return this.element;
                }
            };
        } else if (p instanceof ElementProperty) {
            binding = new ElementPropertyBinding(){
                private Wadl2JavaModelResource element;

                public ElementType type(Resource resource) {
                    return ((Wadl2JavaModelResource)resource).type();
                }

                public Resource read() {
                    return this.element;
                }

                public Resource create(ElementType type) {
                    this.element = new Wadl2JavaModelResource(type, Wadl2JavaModelResource.this, Wadl2JavaModelResource.this.project);
                    return this.element;
                }

                public void remove() {
                    this.element = null;
                }
            };
        } else if (p instanceof ListProperty) {
            binding = new ListPropertyBinding(){
                private final List<Resource> list = new ArrayList<Resource>();

                public ElementType type(Resource resource) {
                    return ((Wadl2JavaModelResource)resource).type();
                }

                public List<Resource> read() {
                    return this.list;
                }

                public Resource insert(ElementType type, int position) {
                    Wadl2JavaModelResource resource = new Wadl2JavaModelResource(type, Wadl2JavaModelResource.this, Wadl2JavaModelResource.this.project);
                    this.list.add(position, resource);
                    return resource;
                }

                public void move(Resource resource, int position) {
                    int oldPosition = this.list.indexOf(resource);
                    if (position < oldPosition) {
                        this.list.remove(oldPosition);
                        this.list.add(position, resource);
                    } else {
                        this.list.add(position, resource);
                        this.list.remove(oldPosition);
                    }
                }

                public void remove(Resource resource) {
                    this.list.remove(resource);
                }
            };
        }
        return binding;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }
}

