/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.properties.context;

import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.util.ValidateEditUtil;
import oracle.eclipse.tools.common.util.ast.EditFailedException;
import oracle.eclipse.tools.common.util.ast.EditUtil;
import oracle.eclipse.tools.common.util.ast.IBodyDeclarationInserter;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.common.util.ast.WriterContext;
import oracle.eclipse.tools.common.util.ast.WriterUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.jaxrs.Activator;
import oracle.eclipse.tools.jaxrs.properties.context.OffsetBasedNodeLocator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;

public final class ASTPropertyInvocationContext {
    private final ICompilationUnit compilationUnit;
    private final IDocument document;
    private WriterContext writerContext = null;
    private TypeDeclaration typeDeclaration = null;
    private final String category = "__annotation_position" + System.currentTimeMillis();
    private Position position;

    public ASTPropertyInvocationContext(ICompilationUnit compilationUnit, IDocument document, int startingOffset, int length) {
        this(compilationUnit, document, new Position(startingOffset, length));
    }

    public ASTPropertyInvocationContext(ICompilationUnit compilationUnit, IDocument document, Position position) {
        this.compilationUnit = compilationUnit;
        this.document = document;
        this.position = position;
        this.initializeEditContext();
    }

    public ASTNode findContainingNode(Position pos) {
        OffsetBasedNodeLocator offsetNodeVisitor = new OffsetBasedNodeLocator(pos.getOffset(), pos.getLength());
        this.getASTRoot().accept((ASTVisitor)offsetNodeVisitor);
        ASTNode containingNode = offsetNodeVisitor.getContainingNode();
        if (containingNode != null) {
            return containingNode;
        }
        return null;
    }

    public ASTNode findContainingNode() {
        return this.findContainingNode(this.position);
    }

    public CompilationUnit getASTRoot() {
        return this.writerContext.getCompilationUnit();
    }

    public boolean doNodesIntersect(ASTNode firstNode, ASTNode secondNode) {
        if (this.isContainingNode(firstNode, secondNode)) {
            return true;
        }
        return this.isContainingNode(secondNode, firstNode);
    }

    public boolean isContainingNode(ASTNode containingNode, ASTNode node) {
        if (containingNode != null && node != null) {
            if (containingNode.subtreeMatch(new ASTMatcher(), (Object)node)) {
                return true;
            }
            return this.isContainingNode(containingNode, node.getParent());
        }
        return false;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public int getStartingOffset() {
        return this.position.getOffset();
    }

    public int getLength() {
        return this.position.getLength();
    }

    public void insertFieldDeclaration(FieldDeclaration fieldDeclaration) {
        try {
            WriterUtil.insertDeclaration((TypeDeclaration)this.typeDeclaration, (ASTNode)fieldDeclaration, (IBodyDeclarationInserter)new IBodyDeclarationInserter.FieldInserter(), (WriterContext)this.writerContext);
        }
        catch (BadLocationException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
        }
    }

    public void setAnnotationAttribute(Annotation annotation, String attrName, Object value) {
        if (annotation.getAST() == this.writerContext.getASTRewrite().getAST()) {
            WriterUtil.setAnnotationAttribute((Annotation)annotation, (String)attrName, (Object)value, (WriterContext)this.writerContext);
        }
    }

    public void addAnnotation(BodyDeclaration parent, String fullyQualifiedName, Map<String, String> attrs) {
        if (parent.getAST() == this.writerContext.getASTRewrite().getAST()) {
            WriterUtil.addAnnotation((BodyDeclaration)parent, (String)fullyQualifiedName, attrs, (WriterContext)this.writerContext);
        }
    }

    public void addAnnotationAttributeArray(BodyDeclaration parent, String fullyQualifiedName, Map<String, List<Object>> attrs) {
        if (parent.getAST() != this.writerContext.getASTRewrite().getAST()) {
            return;
        }
        NormalAnnotation annotation = WriterUtil.addAnnotation((BodyDeclaration)parent, (String)fullyQualifiedName, null, (WriterContext)this.writerContext);
        if (attrs != null) {
            for (String name : attrs.keySet()) {
                List<Object> values = attrs.get(name);
                if (values != null && values.size() < 2) {
                    Object value = null;
                    if (values != null) {
                        value = values.get(0);
                    }
                    annotation = WriterUtil.setAnnotationAttribute((Annotation)annotation, (String)name, (Object)value, (WriterContext)this.writerContext);
                    continue;
                }
                annotation = WriterUtil.setAttributeArray((Annotation)annotation, (String)name, values, (WriterContext)this.writerContext);
            }
        }
    }

    public void addMarkerAnnotation(BodyDeclaration parent, String fullyQualifiedName) {
        if (parent.getAST() == this.writerContext.getASTRewrite().getAST()) {
            WriterUtil.addMarkerAnnotation((BodyDeclaration)parent, (String)fullyQualifiedName, (WriterContext)this.writerContext);
        }
    }

    public void addMarkerAnnotation(SingleVariableDeclaration parent, String fullyQualifiedName) {
        if (parent.getAST() == this.writerContext.getASTRewrite().getAST()) {
            WriterUtil.addMarkerAnnotation((SingleVariableDeclaration)parent, (String)fullyQualifiedName, (WriterContext)this.writerContext);
        }
    }

    public void addAnnotation(SingleVariableDeclaration parent, String fullyQualifiedName, Map<String, String> attrs) {
        if (parent.getAST() == this.writerContext.getASTRewrite().getAST()) {
            WriterUtil.addAnnotation((SingleVariableDeclaration)parent, (String)fullyQualifiedName, attrs, (WriterContext)this.writerContext);
        }
    }

    public void addAnnotationAttributeArray(SingleVariableDeclaration parent, String fullyQualifiedName, Map<String, List<Object>> attrs) {
        if (parent.getAST() != this.writerContext.getASTRewrite().getAST()) {
            return;
        }
        NormalAnnotation annotation = WriterUtil.addAnnotation((SingleVariableDeclaration)parent, (String)fullyQualifiedName, null, (WriterContext)this.writerContext);
        if (attrs != null) {
            for (String name : attrs.keySet()) {
                List<Object> values = attrs.get(name);
                if (values != null && values.size() < 2) {
                    Object value = null;
                    if (values != null) {
                        value = values.get(0);
                    }
                    annotation = WriterUtil.setAnnotationAttribute((Annotation)annotation, (String)name, (Object)value, (WriterContext)this.writerContext);
                    continue;
                }
                annotation = WriterUtil.setAttributeArray((Annotation)annotation, (String)name, values, (WriterContext)this.writerContext);
            }
        }
    }

    public void addAnnotationWithArrayMember(BodyDeclaration parent, String fullyQualifiedName, String arrayName, String annotationName, Map<String, String> attrs) throws EditFailedException {
        if (parent.getAST() != this.writerContext.getASTRewrite().getAST()) {
            return;
        }
        NormalAnnotation annotation = WriterUtil.addAnnotation((BodyDeclaration)parent, (String)fullyQualifiedName, attrs, (WriterContext)this.writerContext);
        WriterUtil.ensureImport((ASTNode)parent, (String)annotationName, (WriterContext)this.writerContext);
        WriterUtil.addAnnotationArrayMember((Annotation)annotation, (String)arrayName, (String)annotationName, attrs, (WriterContext)this.writerContext);
    }

    public void addAnnotationArrayMember(Annotation annotation, String arrayName, String annotationName, Map<String, String> attrs) throws EditFailedException {
        if (annotation.getAST() == this.writerContext.getASTRewrite().getAST()) {
            WriterUtil.addAnnotationArrayMember((Annotation)annotation, (String)arrayName, (String)annotationName, attrs, (WriterContext)this.writerContext);
        }
    }

    public void setAttributeArray(Annotation annotation, String attrName, List<Object> values) throws EditFailedException {
        if (annotation.getAST() == this.writerContext.getASTRewrite().getAST()) {
            WriterUtil.setAttributeArray((Annotation)annotation, (String)attrName, values, (WriterContext)this.writerContext);
        }
    }

    public void removeAnnotation(ASTNode node) {
        if (node.getAST() == this.writerContext.getASTRewrite().getAST()) {
            WriterUtil.removeElement((ASTNode)node, (WriterContext)this.writerContext);
        }
    }

    public void addImport(String type) {
        WriterUtil.ensureImport((ASTNode)this.typeDeclaration, (String)type, (WriterContext)this.writerContext);
    }

    public void addPositionUpdater() {
        try {
            DefaultPositionUpdater updater = new DefaultPositionUpdater(this.category);
            this.document.addPositionCategory(this.category);
            this.document.addPositionUpdater((IPositionUpdater)updater);
            this.document.addPosition(this.position);
        }
        catch (BadLocationException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    public void removePositionUpdater() {
        if (this.position != null) {
            try {
                String[] categories;
                String[] stringArray = categories = this.document.getPositionCategories();
                int n = categories.length;
                int n2 = 0;
                while (n2 < n) {
                    String tempCategory = stringArray[n2];
                    if (tempCategory.equals(this.category)) {
                        this.document.removePositionCategory(this.category);
                    }
                    ++n2;
                }
            }
            catch (BadPositionCategoryException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            }
        }
    }

    public void commitRewrite() {
        this.internalEndEdit();
    }

    public void internalEndEdit() {
        if (this.hasEditContext()) {
            try {
                IResource resource = this.writerContext.getICompilationUnit().getResource();
                if (resource instanceof IFile && ValidateEditUtil.validateEdit((IFile[])new IFile[]{(IFile)resource}).isOK()) {
                    EditUtil.endEdit((WriterContext)this.writerContext);
                }
            }
            catch (JavaModelException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)((Object)e));
            }
            catch (BadLocationException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
            }
        }
    }

    public void initializeEditContext() {
        try {
            this.writerContext = EditUtil.startEdit((ICompilationUnit)this.compilationUnit);
            this.typeDeclaration = ReaderUtil.getPrimaryType((CompilationUnit)this.writerContext.getCompilationUnit());
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
        }
    }

    public void nullEditContext() {
        this.writerContext = null;
        this.typeDeclaration = null;
    }

    public boolean hasEditContext() {
        return this.writerContext != null && this.typeDeclaration != null;
    }
}

