/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.launcher.model.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.jaxrs.jdt.MethodElement;
import oracle.eclipse.tools.jaxrs.jdt.ParameterElement;
import oracle.eclipse.tools.jaxrs.jdt.annotation.PathParamAnnotation;
import oracle.eclipse.tools.jaxrs.launcher.model.IJaxrsMethod;
import oracle.eclipse.tools.jaxrs.launcher.model.IPathParam;
import oracle.eclipse.tools.jaxrs.launcher.model.internal.PathParamResource;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;

public class JaxrsMethodResource
extends Resource {
    private MethodElement method;

    public JaxrsMethodResource(Resource parent, MethodElement method) {
        super(parent);
        this.method = method;
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == IJaxrsMethod.PROP_METHOD_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JaxrsMethodResource.this.method.getMethodDeclaration().getSimpleName();
                }

                public void write(String value) {
                }
            };
        }
        if (p == IJaxrsMethod.PROP_METHOD_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JaxrsMethodResource.this.method.getGetAnnotation().getAnnotationType();
                }

                public void write(String value) {
                }
            };
        }
        if (p == IJaxrsMethod.PROP_METHOD_URL) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JaxrsMethodResource.this.method.getFullUrlSegment();
                }

                public void write(String value) {
                }
            };
        }
        if (p == IJaxrsMethod.PROP_PATH) {
            return new ValuePropertyBinding(){
                String path;
                {
                    this.path = JaxrsMethodResource.this.method.getFullUrlSegment();
                }

                public String read() {
                    return this.path;
                }

                public void write(String value) {
                    this.path = value;
                }
            };
        }
        if (p == IJaxrsMethod.PROP_PATH_PARAMS) {
            return this.createParamList();
        }
        return null;
    }

    private ListPropertyBinding createParamList() {
        LayeredListPropertyBinding listBinding = new LayeredListPropertyBinding(){

            protected List<?> readUnderlyingList() {
                ArrayList<ParameterElement> pathParams = new ArrayList<ParameterElement>();
                List<ParameterElement> pElements = JaxrsMethodResource.this.method.getParameterElements();
                for (ParameterElement pElem : pElements) {
                    PathParamAnnotation pathParam = pElem.getPathParamAnnotation();
                    if (!pathParam.hasAnnotation()) continue;
                    pathParams.add(pElem);
                }
                return pathParams;
            }

            protected Resource resource(Object obj) {
                return new PathParamResource(JaxrsMethodResource.this, (ParameterElement)obj);
            }

            public ElementType type(Resource obj) {
                return IPathParam.TYPE;
            }
        };
        return listBinding;
    }
}

