/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.launcher.model.internal;

import oracle.eclipse.tools.jaxrs.launcher.Messages;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.java.JavaTypeConstraintService;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class ITypeValidationService
extends ValidationService {
    protected void initValidationService() {
        Value value = (Value)this.context(Value.class);
        JavaTypeConstraintService javaTypeConstraintService = (JavaTypeConstraintService)value.service(JavaTypeConstraintService.class);
        if (javaTypeConstraintService != null) {
            javaTypeConstraintService.attach(new Listener(){

                public void handle(Event event) {
                    ITypeValidationService.this.refresh();
                }
            });
        }
    }

    protected Status compute() {
        ReferenceValue value = (ReferenceValue)this.context(ReferenceValue.class);
        String val = value.text(false);
        String label = value.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
        if (val != null) {
            IType type = (IType)value.resolve();
            if (type == null) {
                String msg = Messages.bind((String)Messages.type_validation_service_not_in_source, (Object)val, (Object)label);
                return Status.createErrorStatus((String)msg);
            }
            try {
                if (Flags.isAbstract((int)type.getFlags())) {
                    String msg = Messages.bind((String)Messages.type_validation_service_abstract, (Object)val, (Object)label);
                    return Status.createErrorStatus((String)msg);
                }
                if (type.isEnum()) {
                    String msg = Messages.bind((String)Messages.type_validation_service_enum, (Object)val, (Object)label);
                    return Status.createErrorStatus((String)msg);
                }
                if (type.isInterface()) {
                    String msg = Messages.bind((String)Messages.type_validation_service_interface, (Object)val, (Object)label);
                    return Status.createErrorStatus((String)msg);
                }
                if (type.isAnnotation()) {
                    String msg = Messages.bind((String)Messages.type_validation_service_annotation, (Object)val, (Object)label);
                    return Status.createErrorStatus((String)msg);
                }
                if (type.getPackageFragment().getKind() != 1) {
                    String msg = Messages.bind((String)Messages.type_validation_service_not_in_source, (Object)val, (Object)label);
                    return Status.createErrorStatus((String)msg);
                }
            }
            catch (Exception e) {
                return Status.createErrorStatus((Throwable)e);
            }
            return Status.createOkStatus();
        }
        String msg = Messages.bind((String)Messages.type_validation_service_not_in_source, (Object)val, (Object)label);
        return Status.createErrorStatus((String)msg);
    }
}

