/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.launcher;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.jaxrs.Activator;
import oracle.eclipse.tools.jaxrs.launcher.JaxrsResource;
import oracle.eclipse.tools.jaxrs.util.JAXRSUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ModuleArtifactAdapterDelegate;

public final class JaxrsResourceModuleArtifactAdapter
extends ModuleArtifactAdapterDelegate {
    public IModuleArtifact getModuleArtifact(Object obj) {
        ICompilationUnit unit = JaxrsResourceModuleArtifactAdapter.adaptObjectToCompilationUnit(obj);
        if (unit != null) {
            try {
                return this.createModuleArtifact(unit);
            }
            catch (RuntimeException cnfe) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)cnfe);
            }
        }
        return null;
    }

    public static ICompilationUnit adaptObjectToCompilationUnit(Object obj) {
        IJavaElement elem;
        if (!(obj instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)obj;
        IFile file = (IFile)adaptable.getAdapter(IFile.class);
        ICompilationUnit unit = null;
        if (file != null && (elem = JavaCore.create((IFile)file)) instanceof ICompilationUnit) {
            unit = (ICompilationUnit)elem;
        }
        if (unit == null) {
            unit = (ICompilationUnit)adaptable.getAdapter(ICompilationUnit.class);
        }
        if (JAXRSUtil.isJaxrsResource(unit, true)) {
            return unit;
        }
        try {
            IType[] types = unit.getAllTypes();
            List<IType> typeList = Arrays.asList(types);
            Iterator<IType> iterator = typeList.iterator();
            HashSet<IType> result = new HashSet<IType>(types.length);
            IType type = null;
            ITypeHierarchy hierarchy = null;
            IType[] supertypes = null;
            while (iterator.hasNext()) {
                type = iterator.next();
                if (!result.add(type)) continue;
                hierarchy = type.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                supertypes = hierarchy.getAllInterfaces();
                int i = 0;
                while (i < supertypes.length) {
                    if (JaxrsResourceModuleArtifactAdapter.hasJaxrsResourceTypeInterface(supertypes[i])) {
                        return unit;
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.jaxrs", (CoreException)((Object)e));
        }
        return null;
    }

    public static boolean hasJaxrsResourceTypeInterface(IType type) throws JavaModelException {
        if (type == null) {
            return false;
        }
        IAnnotation[] annotations = type.getAnnotations();
        if (annotations != null) {
            int i = 0;
            int k = annotations.length;
            while (i < k) {
                String annotationType;
                String[][] resolvedAnnotationTypes;
                if (annotations[i].exists() && (resolvedAnnotationTypes = type.resolveType(annotationType = annotations[i].getElementName())) != null) {
                    String resolvedAnnotationClassName = new StringBuffer(resolvedAnnotationTypes[0][0]).append('.').append(resolvedAnnotationTypes[0][1]).toString();
                    if ("javax.ws.rs.Path".equals(resolvedAnnotationClassName)) {
                        return true;
                    }
                    if ("javax.ws.rs.ApplicationPath".equals(resolvedAnnotationClassName)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private IModuleArtifact createModuleArtifact(ICompilationUnit unit) {
        IProject project = unit.getJavaProject().getProject();
        if (!JAXRSUtil.hasJaxrsFacetInstalled(project)) {
            return null;
        }
        IModule module = this.getModule(project);
        if (module == null) {
            return null;
        }
        return new JaxrsResource(module, (IPath)new Path(""), unit);
    }

    private IModule getModule(IProject project) {
        IModule[] modules = ServerUtil.getModules((String)"jst.web");
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return null;
        }
        String componentName = component.getName();
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule nextModule = iModuleArray[n2];
            if (nextModule.getName().equals(componentName)) {
                return nextModule;
            }
            ++n2;
        }
        return null;
    }
}

