/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.jdt.annotation.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.util.SourcePosition;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import oracle.eclipse.tools.jaxrs.jdt.annotation.validation.Messages;
import oracle.eclipse.tools.jaxrs.util.JAXRSDeclarationsUtil;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;

public class ResourceMethodRules
extends AbstractAnnotationProcessor {
    public static final String CHANGE_JAXRS_METHOD_TO_PUBLIC_WARNING = "changeJaxRSMethodToPublic";
    public static final String ENCODED_ANN_INCORRECT_ERROR = "encoded_annotation_remove_error";
    public static final String DEFAULT_VALUE_ANN_INCORRECT_ERROR = "default_value__annotation_remove_error";
    private String resourceMethodAnn;

    private ResourceMethodRules(String ann) {
        this.resourceMethodAnn = ann;
    }

    public void process() {
        this.validateResourceMethodSignature();
        this.validateEntityParameters();
    }

    private void validateResourceMethodSignature() {
        AnnotationTypeDeclaration httpMethodDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(this.resourceMethodAnn);
        HashSet<Declaration> methodDecls = new HashSet<Declaration>();
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(httpMethodDeclaration);
        for (Declaration decl : annotatedTypes) {
            TypeMirror typeMirror;
            if (!(decl instanceof MethodDeclaration)) continue;
            MethodDeclaration methodDecl = (MethodDeclaration)decl;
            methodDecls.add(decl);
            if (this.resourceMethodAnn.equals("javax.ws.rs.GET") && ((typeMirror = methodDecl.getReturnType()) == null || typeMirror instanceof VoidType)) {
                this.printWarning(decl.getPosition(), Messages.ConstructorAndResourceMethodRules_getHasNoReturnValue);
            }
            Collection modifiers = decl.getModifiers();
            boolean isPublic = false;
            for (Modifier modifier : modifiers) {
                if (modifier != Modifier.PUBLIC) continue;
                isPublic = true;
                break;
            }
            if (isPublic) continue;
            this.printFixableWarning(decl.getPosition(), Messages.ResourceMethodVisibilityRule_shouldBePublic, "oracle.eclipse.tools.jaxrs", CHANGE_JAXRS_METHOD_TO_PUBLIC_WARNING);
        }
    }

    private void validateEntityParameters() {
        AnnotationTypeDeclaration resourceMethodDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(this.resourceMethodAnn);
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(resourceMethodDeclaration);
        for (Declaration decl : annotatedTypes) {
            if (!(decl instanceof MethodDeclaration)) continue;
            MethodDeclaration methodDecl = (MethodDeclaration)decl;
            Collection parameters = methodDecl.getParameters();
            int count = 0;
            for (ParameterDeclaration paramDecl : parameters) {
                if (ResourceMethodRules.hasResourceMethodParamAnnotation(paramDecl)) continue;
                ++count;
            }
            if (this.resourceMethodAnn.equals("javax.ws.rs.GET") && count > 0) {
                this.printWarning(decl.getPosition(), Messages.EntityParameterRule_AllParamsOfGetShouldBeAnnotated);
            } else if (count > 1) {
                this.printWarning(decl.getPosition(), String.valueOf(Messages.EntityParameterRule_OneNonAnnotatedParamAllowed_msg1) + this.resourceMethodAnn + Messages.EntityParameterRule_OneNonAnnotatedParamAllowed_msg2);
            }
            for (ParameterDeclaration paramDecl : parameters) {
                this.validateEncodingAndDefaultAnnotations(paramDecl);
            }
        }
    }

    private static boolean hasResourceMethodParamAnnotation(ParameterDeclaration paramDecl) {
        Collection annotationMirrors = paramDecl.getAnnotationMirrors();
        for (AnnotationMirror annMirror : annotationMirrors) {
            String paramAnnName;
            AnnotationType annotationType = annMirror.getAnnotationType();
            AnnotationTypeDeclaration annTypeDecl = annotationType.getDeclaration();
            if (annTypeDecl == null || !JAXRSDeclarationsUtil.isResourceMethodParamAnnotation(paramAnnName = annTypeDecl.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private void validateEncodingAndDefaultAnnotations(ParameterDeclaration paramDecl) {
        SourcePosition srcPos;
        Collection annotationMirrors = paramDecl.getAnnotationMirrors();
        HashMap<String, SourcePosition> annotations = new HashMap<String, SourcePosition>();
        for (AnnotationMirror annMirror : annotationMirrors) {
            SourcePosition srcPos2;
            AnnotationType annotationType = annMirror.getAnnotationType();
            AnnotationTypeDeclaration annTypeDecl = annotationType.getDeclaration();
            if (annTypeDecl == null || (srcPos2 = annMirror.getPosition()) == null) continue;
            annotations.put(annTypeDecl.getQualifiedName(), srcPos2);
        }
        if (!(!annotations.containsKey("javax.ws.rs.Encoded") || annotations.containsKey("javax.ws.rs.PathParam") || annotations.containsKey("javax.ws.rs.QueryParam") || annotations.containsKey("javax.ws.rs.FormParam") || annotations.containsKey("javax.ws.rs.MatrixParam"))) {
            srcPos = (SourcePosition)annotations.get("javax.ws.rs.Encoded");
            if (srcPos != null) {
                this.printFixableWarning(srcPos, Messages.EntityParameterAndMediaTypeRule_encodingAnnotationError, "oracle.eclipse.tools.jaxrs", ENCODED_ANN_INCORRECT_ERROR);
            } else {
                this.printWarning(paramDecl.getPosition(), Messages.EntityParameterAndMediaTypeRule_encodingAnnotationError);
            }
        }
        if (!(!annotations.containsKey("javax.ws.rs.DefaultValue") || annotations.containsKey("javax.ws.rs.CookieParam") || annotations.containsKey("javax.ws.rs.QueryParam") || annotations.containsKey("javax.ws.rs.FormParam") || annotations.containsKey("javax.ws.rs.MatrixParam") || annotations.containsKey("javax.ws.rs.HeaderParam"))) {
            srcPos = (SourcePosition)annotations.get("javax.ws.rs.DefaultValue");
            if (srcPos != null) {
                this.printFixableWarning(srcPos, Messages.EntityParameterAndMediaTypeRule_defaultValueAnnotationError, "oracle.eclipse.tools.jaxrs", DEFAULT_VALUE_ANN_INCORRECT_ERROR);
            } else {
                this.printWarning(paramDecl.getPosition(), Messages.EntityParameterAndMediaTypeRule_defaultValueAnnotationError);
            }
        }
    }

    /* synthetic */ ResourceMethodRules(String string, ResourceMethodRules resourceMethodRules) {
        this(string);
    }

    public static class DeleteResourceMethodRule
    extends ResourceMethodRules {
        public DeleteResourceMethodRule() {
            super("javax.ws.rs.DELETE", null);
        }
    }

    public static class GetResourceMethodRule
    extends ResourceMethodRules {
        public GetResourceMethodRule() {
            super("javax.ws.rs.GET", null);
        }
    }

    public static class HeadResourceMethodRule
    extends ResourceMethodRules {
        public HeadResourceMethodRule() {
            super("javax.ws.rs.HEAD", null);
        }
    }

    public static class PostResourceMethodRule
    extends ResourceMethodRules {
        public PostResourceMethodRule() {
            super("javax.ws.rs.POST", null);
        }
    }

    public static class PutResourceMethodRule
    extends ResourceMethodRules {
        public PutResourceMethodRule() {
            super("javax.ws.rs.PUT", null);
        }
    }
}

