/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.jdt.annotation.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.AnnotationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.jaxrs.jdt.annotation.validation.Messages;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;

public class MediaTypeRule
extends AbstractAnnotationProcessor {
    public void process() {
        this.validateMediaTypes();
    }

    private void validateMediaTypes() {
        AnnotationTypeDeclaration pathDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration("javax.ws.rs.Path");
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(pathDeclaration);
        for (Declaration decl : annotatedTypes) {
            TypeDeclaration typeDecl;
            Collection methodDecls;
            if (!(decl instanceof TypeDeclaration) || (methodDecls = (typeDecl = (TypeDeclaration)decl).getMethods()).size() == 0) continue;
            ArrayList methodList = new ArrayList();
            methodList.addAll(methodDecls);
            Collections.sort(methodList, new SourcePosComparator());
            this.checkForDuplicateMediaTypes(methodList, "javax.ws.rs.GET", "javax.ws.rs.Produces");
            this.checkForDuplicateMediaTypes(methodList, "javax.ws.rs.PUT", "javax.ws.rs.Consumes");
            this.checkForDuplicateMediaTypes(methodList, "javax.ws.rs.POST", "javax.ws.rs.Produces");
            this.checkForDuplicateMediaTypes(methodList, "javax.ws.rs.POST", "javax.ws.rs.Consumes");
            this.checkForDuplicateMediaTypes(methodList, "javax.ws.rs.DELETE", "javax.ws.rs.Consumes");
        }
    }

    private void checkForDuplicateMediaTypes(Collection<? extends MethodDeclaration> methodDecls, String httpMethodAnnName, String produceOrConsumeAnnName) {
        LinkedHashSet<String> allMediaTypes = null;
        block0: for (MethodDeclaration methodDeclaration : methodDecls) {
            if (MediaTypeRule.hasPathAnnotation(methodDeclaration)) continue;
            Set<String> mediaTypes = MediaTypeRule.getMediaTypes(methodDeclaration, httpMethodAnnName, produceOrConsumeAnnName);
            if (allMediaTypes == null) {
                allMediaTypes = new LinkedHashSet<String>();
                if (mediaTypes == null) continue;
                allMediaTypes.addAll(mediaTypes);
                continue;
            }
            if (mediaTypes == null) continue;
            for (String mediaType : mediaTypes) {
                if (allMediaTypes.contains(mediaType)) {
                    int index = httpMethodAnnName.lastIndexOf(46);
                    if (index == -1) {
                        return;
                    }
                    String httpMethodName = httpMethodAnnName.substring(index + 1);
                    String template = "";
                    if (produceOrConsumeAnnName.equals("javax.ws.rs.Produces")) {
                        template = Messages.EntityParameterAndMediaTypeRule_produce;
                    } else if (produceOrConsumeAnnName.equals("javax.ws.rs.Consumes")) {
                        template = Messages.EntityParameterAndMediaTypeRule_consume;
                    }
                    String msg = String.valueOf(Messages.EntityParameterAndMediaTypeRule_mediaTypeConflict1) + httpMethodName + Messages.EntityParameterAndMediaTypeRule_mediaTypeConflict2 + template + Messages.EntityParameterAndMediaTypeRule_mediaTypeConflict3;
                    this.printWarning(methodDeclaration.getPosition(), msg);
                    continue block0;
                }
                allMediaTypes.add(mediaType);
            }
        }
    }

    private static Set<String> getMediaTypes(MethodDeclaration methodDecl, String httpMethodAnnName, String produceOrConsumeAnnName) {
        String qName;
        AnnotationTypeDeclaration annTypeDecl;
        AnnotationType annotationType;
        Collection annotationMirrors = methodDecl.getAnnotationMirrors();
        boolean foundHttpMethodAnn = false;
        boolean anyAnnFound = false;
        for (AnnotationMirror annMirror : annotationMirrors) {
            anyAnnFound = true;
            annotationType = annMirror.getAnnotationType();
            annTypeDecl = annotationType.getDeclaration();
            if (annTypeDecl == null || !(qName = annTypeDecl.getQualifiedName()).equals(httpMethodAnnName)) continue;
            foundHttpMethodAnn = true;
            break;
        }
        if (foundHttpMethodAnn) {
            for (AnnotationMirror annMirror : annotationMirrors) {
                AnnotationValue annValue;
                annotationType = annMirror.getAnnotationType();
                annTypeDecl = annotationType.getDeclaration();
                if (annTypeDecl == null || !(qName = annTypeDecl.getQualifiedName()).equals(produceOrConsumeAnnName) || (annValue = AnnotationUtils.getAnnotationValue((AnnotationMirror)annMirror, (String)"value")) == null) continue;
                Object obj = annValue.getValue();
                LinkedHashSet<String> strs = new LinkedHashSet<String>();
                if (obj instanceof Collection) {
                    Collection c = (Collection)obj;
                    Iterator itr = c.iterator();
                    while (itr.hasNext()) {
                        strs.add(itr.next().toString());
                    }
                } else {
                    strs.add(obj.toString());
                }
                return strs;
            }
        }
        return null;
    }

    private static boolean hasPathAnnotation(MethodDeclaration methodDecl) {
        Collection annotationMirrors = methodDecl.getAnnotationMirrors();
        for (AnnotationMirror annMirror : annotationMirrors) {
            String annotationName;
            AnnotationType annotationType = annMirror.getAnnotationType();
            AnnotationTypeDeclaration annTypeDecl = annotationType.getDeclaration();
            if (annTypeDecl == null || !(annotationName = annTypeDecl.getQualifiedName()).equals("javax.ws.rs.Path")) continue;
            return true;
        }
        return false;
    }

    private static class SourcePosComparator
    implements Comparator<MethodDeclaration> {
        private SourcePosComparator() {
        }

        @Override
        public int compare(MethodDeclaration o1, MethodDeclaration o2) {
            int srcPos2;
            int srcPos1 = o1.getPosition().line();
            if (srcPos1 < (srcPos2 = o2.getPosition().line())) {
                return -1;
            }
            if (srcPos1 == srcPos2) {
                return 0;
            }
            return 1;
        }
    }
}

