/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.jdt.annotation.validation;

import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.Modifier;
import java.util.Collection;
import oracle.eclipse.tools.jaxrs.jdt.annotation.validation.Messages;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;

public class ConstructorRule
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration pathDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration("javax.ws.rs.Path");
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(pathDeclaration);
        for (Declaration declaration : annotatedTypes) {
            if (!(declaration instanceof ClassDeclaration)) continue;
            ClassDeclaration classDecl = (ClassDeclaration)declaration;
            Collection constructors = classDecl.getConstructors();
            boolean isPublic = false;
            if (constructors == null || constructors.size() == 0) {
                isPublic = true;
            } else {
                for (ConstructorDeclaration constuctor : constructors) {
                    Collection modifiers = constuctor.getModifiers();
                    for (Modifier modifier : modifiers) {
                        if (modifier != Modifier.PUBLIC) continue;
                        isPublic = true;
                        break;
                    }
                    if (isPublic) break;
                }
            }
            if (isPublic) continue;
            this.printError(declaration.getPosition(), Messages.ConstructorAndResourceMethodRules_noPublicConstructorError);
        }
    }
}

