/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.jdt.annotation.validation;

import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.type.ClassType;
import java.util.Collection;
import oracle.eclipse.tools.jaxrs.jdt.annotation.validation.Messages;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;

public class ApplicationConfigRule
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration pathDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration("javax.ws.rs.ApplicationPath");
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(pathDeclaration);
        for (Declaration declaration : annotatedTypes) {
            ClassDeclaration typeDecl;
            ClassType classType;
            if (!(declaration instanceof ClassDeclaration) || this.isApplicationSuperClass(classType = (typeDecl = (ClassDeclaration)declaration).getSuperclass())) continue;
            this.printWarning(typeDecl.getPosition(), Messages.ApplicationConfigRule_extendApplicationWarningMsg);
        }
    }

    private boolean isApplicationSuperClass(ClassType classType) {
        ClassDeclaration classDecl = classType.getDeclaration();
        if (classDecl == null) {
            return false;
        }
        String name = classDecl.getQualifiedName();
        if (name.equals("javax.ws.rs.core.Application")) {
            return true;
        }
        if (name.equals("java.lang.Object")) {
            return false;
        }
        return this.isApplicationSuperClass(classType.getSuperclass());
    }
}

