/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.jdt;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import java.util.Collection;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.jaxrs.Activator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.apt.core.env.EnvironmentFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class JaxrsContext {
    private IJavaElement javaElement;
    private IResource jaxrsResource;
    private CompilationUnit compilationUnit;
    private ICompilationUnit icompilationUnit;
    private IJavaProject project;
    private AnnotationProcessorEnvironment ape;

    public JaxrsContext(IResource jwsResource) {
        this.jaxrsResource = jwsResource;
        this.javaElement = JavaCore.create((IResource)this.jaxrsResource);
        this.initialize();
    }

    public JaxrsContext(IJavaElement element) {
        this.javaElement = element;
        this.jaxrsResource = element.getResource();
        this.initialize();
    }

    private void initialize() {
        if (this.javaElement instanceof ICompilationUnit) {
            this.project = JavaCore.create((IProject)this.jaxrsResource.getProject());
            this.icompilationUnit = (ICompilationUnit)this.javaElement;
            this.ape = EnvironmentFactory.getEnvironment((ICompilationUnit)this.icompilationUnit, (IJavaProject)this.project);
            this.compilationUnit = this.getASTRoot(this.icompilationUnit);
        }
    }

    public IResource getJaxrsResource() {
        return this.jaxrsResource;
    }

    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public ICompilationUnit getIcompilationUnit() {
        return this.icompilationUnit;
    }

    public int getLinePosition(ASTNode node) {
        if (node != null) {
            int pos = node.getStartPosition();
            return this.compilationUnit.getLineNumber(pos);
        }
        return 0;
    }

    public int getLinePosition(ISourceRange sourceRange) {
        return this.compilationUnit.getLineNumber(sourceRange.getOffset());
    }

    public int getStartPosition(ASTNode node) {
        return this.compilationUnit.getExtendedStartPosition(node);
    }

    public int getLength(ASTNode node) {
        return this.compilationUnit.getExtendedLength(node);
    }

    public TypeDeclaration getPrimaryType() {
        return ReaderUtil.getPrimaryType((CompilationUnit)this.getCompilationUnit());
    }

    public IMethod[] getTypeMethods() throws JavaModelException {
        IType type = this.icompilationUnit.getType(this.getPrimaryType().getName().getFullyQualifiedName());
        return type.getMethods();
    }

    public IProject getProject() {
        return this.jaxrsResource.getProject();
    }

    public IJavaProject getWebServiceProject() {
        return this.project;
    }

    public String getFullyQualifiedTypeName() {
        try {
            return ClassUtil.resolveType((String)this.getPrimaryType().getName().getFullyQualifiedName(), (ICompilationUnit)this.getIcompilationUnit());
        }
        catch (JavaModelException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)((Object)e));
            return null;
        }
    }

    public AnnotationProcessorEnvironment getApe() {
        return this.ape;
    }

    private CompilationUnit getASTRoot(ICompilationUnit cu) {
        return ReaderUtil.parse((ICompilationUnit)cu, (boolean)true);
    }

    Collection<Declaration> getAnnotatedTypes(String type) {
        AnnotationTypeDeclaration pathDeclaration = (AnnotationTypeDeclaration)this.getApe().getTypeDeclaration(type);
        return this.getApe().getDeclarationsAnnotatedWith(pathDeclaration);
    }

    Collection<com.sun.mirror.declaration.TypeDeclaration> getTypeDeclarations() {
        return this.getApe().getTypeDeclarations();
    }
}

