/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.descriptors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;

public class J2EEUtils {
    public static Servlet findServlet(WebApp webApp, String servletClass) {
        if (webApp == null) {
            return null;
        }
        for (Servlet servlet : webApp.getServlets()) {
            if (servlet == null || servlet.getWebType() == null || !servlet.getWebType().isServletType() || ((ServletType)servlet.getWebType()).getClassName() == null || !((ServletType)servlet.getWebType()).getClassName().trim().equals(servletClass)) continue;
            return servlet;
        }
        return null;
    }

    public static Servlet createOrUpdateServletRef(WebApp webApp, String displayName, String className, Servlet servlet) {
        if (servlet == null) {
            servlet = WebapplicationFactory.eINSTANCE.createServlet();
            servlet.setServletName(displayName);
            ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
            servletType.setClassName(className);
            servlet.setWebType((WebType)servletType);
            servlet.setLoadOnStartup(Integer.valueOf(1));
            webApp.getServlets().add((Object)servlet);
        } else {
            J2EEUtils.updateServletMappings(webApp, servlet, displayName);
            servlet.setServletName(displayName);
            servlet.setLoadOnStartup(Integer.valueOf(1));
        }
        return servlet;
    }

    public static void updateServletMappings(WebApp webApp, Servlet servlet, String displayName) {
        List<ServletMapping> mappings = J2EEUtils.findServletMappings(webApp, servlet);
        for (ServletMapping map : mappings) {
            map.setName(displayName);
        }
    }

    public static List<ServletMapping> findServletMappings(WebApp webApp, Servlet servlet) {
        String servletName = servlet.getServletName();
        servletName = servletName != null ? servletName.trim() : servletName;
        ArrayList<ServletMapping> mappings = new ArrayList<ServletMapping>();
        EList allMappings = webApp.getServletMappings();
        int i = allMappings.size() - 1;
        while (i >= 0) {
            ServletMapping mapping = (ServletMapping)allMappings.get(i);
            if (mapping != null && mapping.getServlet() != null && mapping.getServlet().getServletName() != null && mapping.getServlet().getServletName().trim().equals(servletName)) {
                mappings.add(mapping);
            }
            --i;
        }
        return mappings;
    }

    public static void setUpURLMappings(WebApp webApp, List urlMappingList, Servlet servlet) {
        for (String pattern : urlMappingList) {
            if (J2EEUtils.doesServletMappingExist(webApp, servlet, pattern)) continue;
            ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
            mapping.setServlet(servlet);
            mapping.setName(servlet.getServletName());
            mapping.setUrlPattern(pattern);
            webApp.getServletMappings().add((Object)mapping);
        }
    }

    public static List<String> findURLMappings(WebApp webApp, String servletClass) {
        Servlet servlet = J2EEUtils.findServlet(webApp, servletClass);
        ArrayList<String> urlPatterns = new ArrayList<String>();
        EList mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            for (ServletMapping mapping : mappings) {
                if (mapping == null || mapping.getServlet() == null || mapping.getServlet().getServletName() == null || !mapping.getServlet().getServletName().trim().equals(servletName) || mapping.getUrlPattern() == null) continue;
                urlPatterns.add(mapping.getUrlPattern());
            }
        }
        return urlPatterns;
    }

    public static boolean doesServletMappingExist(WebApp webApp, Servlet servlet, String pattern) {
        EList mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            for (ServletMapping mapping : mappings) {
                if (mapping == null || mapping.getServlet() == null || mapping.getServlet().getServletName() == null || !mapping.getServlet().getServletName().trim().equals(servletName) || mapping.getUrlPattern() == null || !mapping.getUrlPattern().trim().equals(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    public static void removeURLMappings(WebApp webApp, Servlet servlet) {
        EList mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            int i = mappings.size() - 1;
            while (i >= 0) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (mapping != null && mapping.getServlet() != null && mapping.getServlet().getServletName() != null && mapping.getServlet().getServletName().trim().equals(servletName)) {
                    mappings.remove(mapping);
                }
                --i;
            }
        }
    }

    public static void removeServlet(WebApp webApp, Servlet servlet) {
        webApp.getServlets().remove((Object)servlet);
    }

    public static void removeContextParam(WebApp webApp, String paramName) {
        block2: {
            block3: {
                if (!"2.3".equals(webApp.getVersion())) break block3;
                for (ContextParam cp : webApp.getContexts()) {
                    if (!cp.getParamName().equals(paramName)) continue;
                    webApp.getContexts().remove((Object)cp);
                    break block2;
                }
                break block2;
            }
            if (!"2.4".equals(webApp.getVersion())) break block2;
            for (ParamValue cp : webApp.getContextParams()) {
                if (!cp.getName().equals(paramName)) continue;
                webApp.getContextParams().remove((Object)cp);
                break;
            }
        }
    }

    public static void setupContextParamForV2_3(WebApp webApp, String paramName, String paramValue) {
        ContextParam cp2 = null;
        ContextParam foundCP = null;
        boolean found = false;
        for (ContextParam cp2 : webApp.getContexts()) {
            if (cp2 == null || cp2.getParamName() == null || !cp2.getParamName().equals(paramName)) continue;
            foundCP = cp2;
            found = true;
        }
        if (!found) {
            cp2 = WebapplicationFactory.eINSTANCE.createContextParam();
            cp2.setParamName(paramName);
            cp2.setParamValue(paramValue);
            webApp.getContexts().add((Object)cp2);
        } else {
            cp2 = foundCP;
            if (cp2.getParamValue().indexOf(paramValue) < 0) {
                String curVal = cp2.getParamValue();
                String val = paramValue;
                if (curVal != null && !"".equals(curVal.trim())) {
                    val = String.valueOf(curVal) + ",\n" + val;
                }
                cp2.setParamValue(val);
            }
        }
    }

    public static void setupContextParamForV2_4(WebApp webApp, String paramName, String paramValue) {
        ParamValue foundCP = null;
        ParamValue cp2 = null;
        boolean found = false;
        for (ParamValue cp2 : webApp.getContextParams()) {
            if (cp2 == null || cp2.getName() == null || !cp2.getName().trim().equals(paramName)) continue;
            foundCP = cp2;
            found = true;
        }
        if (!found) {
            ParamValue pv = CommonFactory.eINSTANCE.createParamValue();
            pv.setName(paramName);
            pv.setValue(paramValue);
            webApp.getContextParams().add((Object)pv);
        } else {
            cp2 = foundCP;
            if (cp2.getValue().indexOf(paramValue) < 0) {
                String curVal = cp2.getValue();
                String val = paramValue;
                if (curVal != null && !"".equals(curVal.trim())) {
                    val = String.valueOf(curVal) + ",\n" + val;
                }
                cp2.setValue(val);
            }
        }
    }

    public static void setupContextParam(WebApp webApp, String paramName, String paramValue) {
        if (webApp.getVersionID() == 23) {
            J2EEUtils.setupContextParamForV2_3(webApp, paramName, paramValue);
        } else if (webApp.getVersionID() == 24) {
            J2EEUtils.setupContextParamForV2_4(webApp, paramName, paramValue);
        } else {
            throw new IllegalArgumentException("Invalid argument: " + webApp.getVersionID());
        }
    }

    public static String getContextParam(WebApp webApp, String paramName) {
        block3: {
            block2: {
                if (!"2.3".equals(webApp.getVersion())) break block2;
                for (ContextParam cp : webApp.getContexts()) {
                    if (cp == null || cp.getParamName() == null || !cp.getParamName().trim().equals(paramName)) continue;
                    return cp.getParamValue();
                }
                break block3;
            }
            if (!"2.4".equals(webApp.getVersion())) break block3;
            for (ParamValue cp : webApp.getContextParams()) {
                if (cp == null || cp.getName() == null || !cp.getName().trim().equals(paramName)) continue;
                return cp.getValue();
            }
        }
        return null;
    }

    public static String getFileExtensionFromMap(ServletMapping map) {
        String ext;
        Path extPath;
        String urlPattern = map.getUrlPattern();
        if (urlPattern != null && urlPattern.trim().length() != 0 && (extPath = new Path(map.getUrlPattern())) != null && (ext = extPath.getFileExtension()) != null && ext.trim().length() != 0) {
            return ext;
        }
        return null;
    }

    public static String getPrefixMapping(ServletMapping map) {
        String ext;
        Path extPath;
        String urlPattern = map.getUrlPattern();
        if (urlPattern != null && urlPattern.trim().length() != 0 && (extPath = new Path(urlPattern)) != null && (ext = extPath.getFileExtension()) == null) {
            String lastSeg = extPath.lastSegment();
            if (lastSeg != null && lastSeg.equals("*")) {
                return extPath.removeLastSegments(1).toString();
            }
            return extPath.toString();
        }
        return null;
    }
}

