/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public enum JAXRSVersion {
    UNKNOWN,
    V1_0,
    V1_1;


    public String toString() {
        switch (this) {
            case V1_0: {
                return "1.0";
            }
            case V1_1: {
                return "1.1";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        throw new IllegalStateException("Missing string conversion: " + this.name());
    }

    public static JAXRSVersion valueOfString(String valueAsString) {
        if ("1.0".equals(valueAsString)) {
            return V1_0;
        }
        if ("1.1".equals(valueAsString)) {
            return V1_1;
        }
        return null;
    }

    public static JAXRSVersion valueOfFacetVersion(IProjectFacetVersion facetVersion) {
        if (!JAXRSVersion.isJAXRSFacet(facetVersion.getProjectFacet())) {
            throw new IllegalArgumentException("Not a JSF facet: " + facetVersion.getProjectFacet().toString());
        }
        String versionString = facetVersion.getVersionString();
        if (versionString != null) {
            return JAXRSVersion.valueOfString(versionString);
        }
        return null;
    }

    public static JAXRSVersion valueOfProject(IProject project) {
        try {
            IProjectFacetVersion projectFacetVersion;
            IFacetedProject fProj;
            if (project != null && FacetedProjectFramework.isFacetedProject((IProject)project) && (fProj = ProjectFacetsManager.create((IProject)project)) != null && (projectFacetVersion = fProj.getProjectFacetVersion(ProjectFacetsManager.getProjectFacet((String)"jst.jaxrs"))) != null) {
                return JAXRSVersion.valueOfFacetVersion(projectFacetVersion);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static boolean isJAXRSFacet(IProjectFacet facet) {
        return "jst.jaxrs".equals(facet.getId());
    }
}

