/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.util.classloader.AbstractClassLoaderAdapterFactory;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.Bundle;

public class JaxrsClassloaderAdapterFactory
extends AbstractClassLoaderAdapterFactory {
    private static final Map<String, String> TYPES = new HashMap<String, String>();
    private static final Map<String, String> VERSION_BUNDLES = new HashMap<String, String>();

    static {
        TYPES.put("oracle.eclipse.tools.jaxrs.server.IJaxrsHttpServer", "oracle.eclipse.tools.jaxrs.vbundle.server.JerseyHttpStarter");
        TYPES.put("oracle.eclipse.tools.jaxrs.IJaxrsDependencyFactory", "oracle.eclipse.tools.jaxrs.vbundle.JaxrsDependencyFactory");
        VERSION_BUNDLES.put("1.1", "oracle.eclipse.tools.jaxrs.v11");
    }

    protected AbstractClassLoaderAdapterFactory.Key getCacheKey(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IProject) {
            String version = this.getVersionForProject((IProject)adaptableObject);
            return super.getCacheKey((Object)version, adapterType);
        }
        return super.getCacheKey(adaptableObject, adapterType);
    }

    protected ClassLoader instantiateClassLoader(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IProject) {
            return super.instantiateClassLoader(adaptableObject, adapterType);
        }
        return null;
    }

    private String getVersionForProject(IProject project) {
        return "1.1";
    }

    protected URL[] getClasspathURLsForAdapter(Object adaptableObject) {
        if (adaptableObject instanceof IProject) {
            IProject project = (IProject)adaptableObject;
            String version = this.getVersionForProject(project);
            String bundleID = VERSION_BUNDLES.get(version);
            return this.getURLsForBundle(bundleID);
        }
        return new URL[0];
    }

    protected ClassLoader getClassLoaderFor(Object adaptableObject) {
        if (adaptableObject instanceof IProject) {
            IProject project = (IProject)adaptableObject;
            String version = this.getVersionForProject(project);
            String bundleID = VERSION_BUNDLES.get(version);
            Bundle bundle = Platform.getBundle((String)bundleID);
            try {
                return bundle.loadClass("oracle.eclipse.tools.jaxrs.vbundle.JaxrsDependencyFactory").getClassLoader();
            }
            catch (ClassNotFoundException cnfe) {
                LoggingService.logException((String)"oracle.eclipse.tools.jaxrs", (Throwable)cnfe);
            }
        }
        return null;
    }

    public URL[] getClasspathURLs(IProject project) {
        return this.getClasspathURLsForAdapter(project);
    }

    protected URL fileToURL(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException murle) {
            LoggingService.logException((String)"oracle.eclipse.tools.jaxrs", (Throwable)murle);
            return null;
        }
    }

    protected String getImplementationType(String interfaceType) {
        return TYPES.get(interfaceType);
    }

    public static IPath getCurrentJaxrsContainerPath(IProject project) {
        IJavaProject jproject = JavaCore.create((IProject)project);
        if (jproject != null) {
            try {
                IClasspathEntry[] rawCP;
                IClasspathEntry[] iClasspathEntryArray = rawCP = jproject.getRawClasspath();
                int n = rawCP.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath entryPath;
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 5 && (entryPath = entry.getPath()).segment(0).contains("jersey-server")) {
                        return entryPath;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }
}

