/*
 * Decompiled with CFR 0.152.
 */
package at.jta;

import at.jta.CachedEntry;
import at.jta.CachedValue;
import at.jta.Key;
import at.jta.NotSupportedOSException;
import at.jta.RegistryErrorException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class Regor {
    public static final long serialVersionUID = 440L;
    public static final int _HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int _HKEY_CURRENT_USER = -2147483647;
    public static final int _HKEY_LOCAL_MACHINE = -2147483646;
    public static final Key HKEY_CLASSES_ROOT = new Key(Integer.MIN_VALUE, "HKEY_CLASSES_ROOT");
    public static final Key HKEY_CURRENT_USER = new Key(-2147483647, "HKEY_CURRENT_USER");
    public static final Key HKEY_LOCAL_MACHINE = new Key(-2147483646, "HKEY_LOCAL_MACHINE");
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int NATIVE_HANDLE = 0;
    public static final int ERROR_CODE = 1;
    public static final int SUBKEYS_NUMBER = 0;
    public static final int VALUES_NUMBER = 2;
    public static final int MAX_KEY_LENGTH = 3;
    public static final int MAX_VALUE_NAME_LENGTH = 4;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;
    private Method openKey = null;
    private Method closeKey = null;
    private Method delKey = null;
    private Method createKey = null;
    private Method flushKey = null;
    private Method queryValue = null;
    private Method setValue = null;
    private Method delValue = null;
    private Method queryInfoKey = null;
    private Method enumKey = null;
    private Method enumValue = null;
    private static final String NULL_STRING = new String(new char[1]);
    private static final String INIT_WINDOWS_STRING = "Windows Registry Editor Version 5.00";
    private static final String BINARY_KEY_IDENT = "hex:";
    private static final String DWORD_KEY_IDENT = "dword:";
    private static final String MULTI_KEY_IDENT = "hex(7):";
    private static final String EXPAND_KEY_IDENT = "hex(2):";
    public static int WAIT_FOR_FILE = 250;
    private ArrayList caches;
    private boolean useCache = false;
    private INativeRegistryHandler nativeHandler = null;
    public static final int PLAIN_KEY = 1;
    public static final int BINARY_KEY = 2;
    public static final int DWORD_KEY = 3;
    public static final int MULTI_KEY = 4;
    public static final int EXPAND_KEY = 5;
    private static final String BINARY_KEY_NAME = "REG_BINARY";
    private static final String DWORD_KEY_NAME = "REG_DWORD";
    private static final String MULTI_KEY_NAME = "REG_MULTI_SZ";
    private static final String EXPAND_KEY_NAME = "REG_EXPAND_SZ";
    private static final String PLAIN_KEY_NAME = "REG_SZ";

    public Regor() throws RegistryErrorException {
        this.checkOS();
        this.initMethods();
        this.initNatvieRegistry();
    }

    private void checkOS() {
        String str = System.getProperty("os.name");
        if (str == null || str.toLowerCase().indexOf("windows") == -1) {
            throw new NotSupportedOSException("Operating system: " + str + " is not supported!");
        }
    }

    public void saveBinary(Key key, String valueName, String hexCommaData) throws RegistryErrorException {
        if (this.nativeHandler == null) {
            throw new RegistryErrorException("NativeHandler is not initalized!");
        }
        if (this.nativeHandler instanceof RegHandler) {
            System.err.println("ATTENTITION!! WRONG METHOD TO STORE BINARY ENTRIES!! PLEASE USE savePlainBinary!");
        }
        this.nativeHandler.saveAnyValue(key.getPath(), valueName, BINARY_KEY_IDENT, hexCommaData);
    }

    public void savePlainBinary(Key key, String valueName, String plainData) throws RegistryErrorException {
        if (this.nativeHandler == null) {
            throw new RegistryErrorException("NativeHandler is not initalized!");
        }
        plainData = this.nativeHandler instanceof RegeditHandler ? Regor.convertStringToHexComma(plainData, false) : Regor.convertStringToHex(plainData);
        this.nativeHandler.saveAnyValue(key.getPath(), valueName, BINARY_KEY_IDENT, plainData);
    }

    public String readBinary(Key key, String valueName) throws RegistryErrorException {
        if (key == null) {
            throw new NullPointerException("Registry key cannot be null");
        }
        if (valueName == null) {
            throw new NullPointerException("Valuename cannot be null, because the default value is always a STRING! If you want to read a String use readValue");
        }
        if (this.nativeHandler == null) {
            throw new RegistryErrorException("NativeHandler is not initalized!");
        }
        String ret = this.nativeHandler.extractAnyValue(key.getPath(), valueName, false);
        if (ret != null && ret.startsWith(BINARY_KEY_IDENT)) {
            return ret.substring(4);
        }
        if (ret != null && (this.nativeHandler instanceof RegHandler || this.isCachingActive())) {
            return ret;
        }
        return null;
    }

    public void saveDword(Key key, String valueName, String hexData) throws RegistryErrorException {
        if (this.nativeHandler == null) {
            throw new RegistryErrorException("NativeHandler is not initalized!");
        }
        try {
            if (Long.parseLong(hexData, 16) > 0xFFFFFFFFL) {
                throw new RegistryErrorException("Dword entry to high for registry! FFFF FFFF is the highest value!");
            }
        }
        catch (Exception ex) {
            throw RegistryErrorException.getException(ex);
        }
        this.nativeHandler.saveAnyValue(key.getPath(), valueName, DWORD_KEY_IDENT, hexData);
    }

    public String readDword(Key key, String valueName) throws RegistryErrorException {
        if (key == null) {
            throw new NullPointerException("Registry key cannot be null");
        }
        if (valueName == null) {
            throw new NullPointerException("Valuename cannot be null, because the default value is always a STRING! If you want to read a String use readValue");
        }
        if (this.nativeHandler == null) {
            throw new RegistryErrorException("NativeHandler is not initalized!");
        }
        String ret = this.nativeHandler.extractAnyValue(key.getPath(), valueName, false);
        if (ret != null && ret.startsWith(DWORD_KEY_IDENT)) {
            return ret.substring(6);
        }
        if (ret != null && (this.nativeHandler instanceof RegHandler || this.isCachingActive())) {
            return ret;
        }
        return null;
    }

    public void saveMulti(Key key, String valueName, String hexCommaZeroData) throws RegistryErrorException {
        if (this.nativeHandler == null) {
            throw new RegistryErrorException("NativeHandler is not initalized!");
        }
        if (this.nativeHandler instanceof RegHandler) {
            System.err.println("ATTENTITION!! WRONG METHOD TO STORE MULTI ENTRIES!! PLEASE USE savePlainMulti!");
        }
        this.nativeHandler.saveAnyValue(key.getPath(), valueName, MULTI_KEY_IDENT, hexCommaZeroData);
    }

    public void savePlainMulti(Key key, String valueName, String plainData) throws RegistryErrorException {
        if (this.nativeHandler == null) {
            throw new RegistryErrorException("NativeHandler is not initalized!");
        }
        if (this.nativeHandler instanceof RegeditHandler) {
            plainData = Regor.convertStringToHexComma(plainData, true);
        }
        this.nativeHandler.saveAnyValue(key.getPath(), valueName, MULTI_KEY_IDENT, plainData);
    }

    public String readMulti(Key key, String valueName) throws RegistryErrorException {
        if (key == null) {
            throw new NullPointerException("Registry key cannot be null");
        }
        if (valueName == null) {
            throw new NullPointerException("Valuename cannot be null, because the default value is always a STRING! If you want to read a String use readValue");
        }
        if (this.nativeHandler == null) {
            throw new RegistryErrorException("NativeHandler is not initalized!");
        }
        String ret = this.nativeHandler.extractAnyValue(key.getPath(), valueName, false);
        if (ret != null && ret.startsWith(MULTI_KEY_IDENT)) {
            return ret.substring(7);
        }
        if (ret != null && (this.nativeHandler instanceof RegHandler || this.isCachingActive())) {
            return ret;
        }
        return null;
    }

    public void saveExpand(Key key, String valueName, String hexCommaZeroData) throws RegistryErrorException {
        if (this.nativeHandler == null) {
            throw new RegistryErrorException("NativeHandler is not initalized!");
        }
        if (this.nativeHandler instanceof RegHandler) {
            System.err.println("ATTENTITION!! WRONG METHOD TO STORE EXPAND ENTRIES!! PLEASE USE savePlainExpand!");
        }
        this.nativeHandler.saveAnyValue(key.getPath(), valueName, EXPAND_KEY_IDENT, hexCommaZeroData);
    }

    public void savePlainExpand(Key key, String valueName, String plainData) throws RegistryErrorException {
        if (this.nativeHandler == null) {
            throw new RegistryErrorException("NativeHandler is not initalized!");
        }
        if (this.nativeHandler instanceof RegeditHandler) {
            plainData = Regor.convertStringToHexComma(plainData, true);
        }
        this.nativeHandler.saveAnyValue(key.getPath(), valueName, EXPAND_KEY_IDENT, plainData);
    }

    public String readExpand(Key key, String valueName) throws RegistryErrorException {
        if (key == null) {
            throw new NullPointerException("Registry key cannot be null");
        }
        if (valueName == null) {
            throw new NullPointerException("Valuename cannot be null, because the default value is always a STRING! If you want to read a String use readValue");
        }
        if (this.nativeHandler == null) {
            throw new RegistryErrorException("NativeHandler is not initalized!");
        }
        String ret = this.nativeHandler.extractAnyValue(key.getPath(), valueName, false);
        if (ret != null && ret.startsWith(EXPAND_KEY_IDENT)) {
            return ret.substring(7);
        }
        if (ret != null && (this.nativeHandler instanceof RegHandler || this.isCachingActive())) {
            return ret;
        }
        return null;
    }

    public byte[] enumValueName(Key key, int valueNameIndex, int maxValueNameLength) throws RegistryErrorException {
        return this._enumValueName(key.getKey(), valueNameIndex, maxValueNameLength);
    }

    public byte[] _enumValueName(int key, int valueNameIndex, int maxValueNameLength) throws RegistryErrorException {
        try {
            return (byte[])this.enumValue.invoke(null, new Integer(key), new Integer(valueNameIndex), new Integer(maxValueNameLength));
        }
        catch (InvocationTargetException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalAccessException ex) {
            throw RegistryErrorException.getException(ex);
        }
    }

    public List listValueNames(Key key, String subkey) throws RegistryErrorException {
        return this._listValueNames(key.getKey(), subkey);
    }

    public List listValueNames(Key key) throws RegistryErrorException {
        return this.listValueNames(key, null);
    }

    public List _listValueNames(int key, String subkey) throws RegistryErrorException {
        int handle = -1;
        try {
            int[] info;
            handle = this._openKey(key, subkey, 131097);
            if (handle != -1 && (info = this._getChildInformation(handle)) != null && info[0] != -1) {
                ArrayList<String> ret = new ArrayList<String>();
                int x = 0;
                while (x != info[2]) {
                    String tmp = Regor.parseValue(this._enumValueName(handle, x, info[4] + 1));
                    if (tmp != null) {
                        ret.add(tmp);
                    }
                    ++x;
                }
                ArrayList<String> arrayList = ret.isEmpty() ? null : ret;
                return arrayList;
            }
        }
        catch (RegistryErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw RegistryErrorException.getException(ex);
        }
        finally {
            this._closeKey(handle);
        }
        return null;
    }

    public List _listValueNames(int key) throws RegistryErrorException {
        return this._listValueNames(key, null);
    }

    public byte[] enumKeys(Key key, int subkeyIndex, int maxKeyNameLength) throws RegistryErrorException {
        return this._enumKeys(key.getKey(), subkeyIndex, maxKeyNameLength);
    }

    public byte[] _enumKeys(int key, int subkeyIndex, int maxKeyNameLength) throws RegistryErrorException {
        try {
            return (byte[])this.enumKey.invoke(null, new Integer(key), new Integer(subkeyIndex), new Integer(maxKeyNameLength));
        }
        catch (InvocationTargetException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalAccessException ex) {
            throw RegistryErrorException.getException(ex);
        }
    }

    public List listKeys(Key key, String subkey) throws RegistryErrorException {
        return this._listKeys(key.getKey(), subkey);
    }

    public List listKeys(Key key) throws RegistryErrorException {
        return this.listKeys(key, null);
    }

    public List _listKeys(int key, String subkey) throws RegistryErrorException {
        int handle = -1;
        try {
            int[] info;
            handle = this._openKey(key, subkey, 131097);
            if (handle != -1 && (info = this._getChildInformation(handle)) != null && info[0] != -1) {
                ArrayList<String> ret = new ArrayList<String>();
                int x = 0;
                while (x != info[0]) {
                    String tmp = Regor.parseValue(this._enumKeys(handle, x, info[3] + 1));
                    if (tmp != null) {
                        ret.add(tmp);
                    }
                    ++x;
                }
                ArrayList<String> arrayList = ret.isEmpty() ? null : ret;
                return arrayList;
            }
        }
        catch (RegistryErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw RegistryErrorException.getException(ex);
        }
        finally {
            this._closeKey(handle);
        }
        return null;
    }

    public List _listKeys(int key) throws RegistryErrorException {
        return this._listKeys(key, null);
    }

    public int[] getChildInformation(Key key) throws RegistryErrorException {
        return this._getChildInformation(key.getKey());
    }

    public int[] _getChildInformation(int key) throws RegistryErrorException {
        try {
            return (int[])this.queryInfoKey.invoke(null, new Integer(key));
        }
        catch (InvocationTargetException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalAccessException ex) {
            throw RegistryErrorException.getException(ex);
        }
    }

    public int deleteEntry(Key key, String valueName) throws RegistryErrorException {
        return this._delValue(key.getKey(), valueName);
    }

    public int delValue(Key key, String valueName) throws RegistryErrorException {
        return this._delValue(key.getKey(), valueName);
    }

    public int _delValue(int key, String valueName) throws RegistryErrorException {
        try {
            Integer ret = (Integer)this.delValue.invoke(null, new Integer(key), this.getString(valueName));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalAccessException ex) {
            throw RegistryErrorException.getException(ex);
        }
    }

    public int saveValue(Key key, String valueName, String value) throws RegistryErrorException {
        return this._setValue(key.getKey(), valueName, value);
    }

    public int setValue(Key key, String valueName, String value) throws RegistryErrorException {
        return this._setValue(key.getKey(), valueName, value);
    }

    public int _setValue(int key, String valueName, String value) throws RegistryErrorException {
        try {
            Integer ret = (Integer)this.setValue.invoke(null, new Integer(key), this.getString(valueName), this.getString(value));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalAccessException ex) {
            throw RegistryErrorException.getException(ex);
        }
    }

    public String readValueAsString(Key key, String valueName) throws RegistryErrorException {
        byte[] buf = this.readValue(key, valueName);
        if (buf == null) {
            return null;
        }
        return Regor.parseValue(buf);
    }

    public byte[] readValue(Key key, String valueName) throws RegistryErrorException {
        return this._readValue(key.getKey(), valueName);
    }

    public byte[] _readValue(int key, String valueName) throws RegistryErrorException {
        try {
            byte[] ret = (byte[])this.queryValue.invoke(null, new Integer(key), this.getString(valueName));
            return ret;
        }
        catch (InvocationTargetException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalAccessException ex) {
            throw RegistryErrorException.getException(ex);
        }
    }

    public String readAnyValueString(Key key, String valueName) throws RegistryErrorException {
        if (key == null) {
            throw new NullPointerException("Registry key cannot be null");
        }
        if (valueName == null || valueName.equals("")) {
            return this.readValueAsString(key, valueName);
        }
        try {
            String tmpDataType = this.nativeHandler.extractAnyValue(key.getPath(), valueName, true);
            if (this.nativeHandler instanceof RegHandler) {
                if (tmpDataType != null && tmpDataType.trim().length() > 0) {
                    if ((tmpDataType = tmpDataType.trim()).startsWith(BINARY_KEY_NAME)) {
                        return tmpDataType.substring(BINARY_KEY_NAME.length() + 1);
                    }
                    if (tmpDataType.startsWith(DWORD_KEY_NAME)) {
                        return tmpDataType.substring(DWORD_KEY_NAME.length() + 1);
                    }
                    if (tmpDataType.startsWith(PLAIN_KEY_NAME)) {
                        return tmpDataType.substring(PLAIN_KEY_NAME.length() + 1);
                    }
                    if (tmpDataType.startsWith(EXPAND_KEY_NAME)) {
                        return tmpDataType.substring(EXPAND_KEY_NAME.length() + 1);
                    }
                    if (tmpDataType.startsWith(MULTI_KEY_NAME)) {
                        return tmpDataType.substring(MULTI_KEY_NAME.length() + 1);
                    }
                }
            } else if (tmpDataType != null && tmpDataType.trim().length() > 0) {
                if ((tmpDataType = tmpDataType.trim()).startsWith(BINARY_KEY_IDENT)) {
                    return Regor.parseHexString(tmpDataType.substring(BINARY_KEY_IDENT.length()), false);
                }
                if (tmpDataType.startsWith(DWORD_KEY_IDENT)) {
                    return tmpDataType.substring(DWORD_KEY_IDENT.length());
                }
                if (tmpDataType.startsWith(EXPAND_KEY_IDENT)) {
                    return Regor.parseHexString(tmpDataType.substring(EXPAND_KEY_IDENT.length()), true);
                }
                if (tmpDataType.startsWith(MULTI_KEY_IDENT)) {
                    return Regor.parseHexString(tmpDataType.substring(MULTI_KEY_IDENT.length()), true);
                }
                return tmpDataType.substring(1, tmpDataType.length() - 2);
            }
        }
        catch (Exception ex) {
            throw RegistryErrorException.getException(ex);
        }
        return null;
    }

    public int getKeyType(Key key, String valueName) throws RegistryErrorException {
        int ret;
        block16: {
            ret = 0;
            if (key == null) {
                throw new NullPointerException("Registry key cannot be null");
            }
            if (valueName == null || valueName.equals("")) {
                ret = 1;
            } else {
                String tmpDataType;
                block23: {
                    block22: {
                        block21: {
                            block15: {
                                block20: {
                                    block19: {
                                        block18: {
                                            block17: {
                                                try {
                                                    tmpDataType = this.nativeHandler.extractAnyValue(key.getPath(), valueName, true);
                                                    if (!(this.nativeHandler instanceof RegHandler)) break block15;
                                                    if (tmpDataType == null || tmpDataType.trim().length() <= 0) break block16;
                                                    if (!tmpDataType.startsWith(BINARY_KEY_NAME)) break block17;
                                                    return 2;
                                                }
                                                catch (Exception ex) {
                                                    throw RegistryErrorException.getException(ex);
                                                }
                                            }
                                            if (!tmpDataType.startsWith(DWORD_KEY_NAME)) break block18;
                                            return 3;
                                        }
                                        if (!tmpDataType.startsWith(PLAIN_KEY_NAME)) break block19;
                                        return 1;
                                    }
                                    if (!tmpDataType.startsWith(EXPAND_KEY_NAME)) break block20;
                                    return 5;
                                }
                                if (tmpDataType.startsWith(MULTI_KEY_NAME)) {
                                    return 4;
                                }
                            }
                            if (tmpDataType == null || tmpDataType.trim().length() <= 0) break block16;
                            if (!tmpDataType.startsWith(BINARY_KEY_IDENT)) break block21;
                            return 2;
                        }
                        if (!tmpDataType.startsWith(DWORD_KEY_IDENT)) break block22;
                        return 3;
                    }
                    if (!tmpDataType.startsWith(EXPAND_KEY_IDENT)) break block23;
                    return 5;
                }
                if (tmpDataType.startsWith(MULTI_KEY_IDENT)) {
                    return 4;
                }
                return 1;
            }
        }
        return ret;
    }

    public int flushKey(Key key) throws RegistryErrorException {
        return this._flushKey(key.getKey());
    }

    public int _flushKey(int key) throws RegistryErrorException {
        try {
            Integer ret = (Integer)this.flushKey.invoke(null, new Integer(key));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalAccessException ex) {
            throw RegistryErrorException.getException(ex);
        }
    }

    public int delKey(Key key, String subkey) throws RegistryErrorException {
        return this._delKey(key.getKey(), subkey);
    }

    public int _delKey(int key, String subkey) throws RegistryErrorException {
        if (subkey == null || subkey.length() == 0) {
            throw new RegistryErrorException("subkey cannot be null");
        }
        try {
            Integer ret = (Integer)this.delKey.invoke(null, new Integer(key), this.getString(subkey));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalAccessException ex) {
            throw RegistryErrorException.getException(ex);
        }
    }

    public Key createKey(Key key, String subkey) throws RegistryErrorException {
        int tmpKey = this._createKey(key.getKey(), subkey);
        if (tmpKey == -1) {
            return null;
        }
        return new Key(key, tmpKey, subkey);
    }

    public int _createKey(int key, String subkey) throws RegistryErrorException {
        try {
            int[] result = (int[])this.createKey.invoke(null, new Integer(key), this.getString(subkey));
            if (result[1] == 0) {
                return result[0];
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalAccessException ex) {
            throw RegistryErrorException.getException(ex);
        }
    }

    public int closeKey(Key key) throws RegistryErrorException {
        return this._closeKey(key.getKey());
    }

    public int _closeKey(int key) throws RegistryErrorException {
        try {
            Integer ret = (Integer)this.closeKey.invoke(null, new Integer(key));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw RegistryErrorException.getException(ex);
        }
        catch (IllegalAccessException ex) {
            throw RegistryErrorException.getException(ex);
        }
    }

    public Key openKey(Key key, String subkey, int security_mask) throws RegistryErrorException {
        int tmpKey = this._openKey(key.getKey(), subkey, security_mask);
        if (tmpKey == -1) {
            return null;
        }
        return new Key(key, tmpKey, subkey);
    }

    public Key openKey(Key key, String subkey) throws RegistryErrorException {
        return this.openKey(key, subkey, 983103);
    }

    public int _openKey(int key, String subkey, int security_mask) throws RegistryErrorException {
        int[] result;
        block5: {
            result = (int[])this.openKey.invoke(null, new Integer(key), this.getString(subkey), new Integer(security_mask));
            if (result != null && result[1] == 0) break block5;
            return -1;
        }
        try {
            return result[0];
        }
        catch (InvocationTargetException ex1) {
            throw RegistryErrorException.getException(ex1);
        }
        catch (IllegalArgumentException ex1) {
            throw RegistryErrorException.getException(ex1);
        }
        catch (IllegalAccessException ex1) {
            throw RegistryErrorException.getException(ex1);
        }
    }

    public int _openKey(int key, String subkey) throws RegistryErrorException {
        return this._openKey(key, subkey, 983103);
    }

    private byte[] getString(String str) {
        if (str == null) {
            str = "";
        }
        str = String.valueOf(str) + "\u0000";
        return str.getBytes();
    }

    public static String parseValue(byte[] buf) {
        if (buf == null) {
            return null;
        }
        String ret = new String(buf);
        if (ret.charAt(ret.length() - 1) == '\u0000') {
            return ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static String parseHexString(String hexCommaString, boolean deleteNullSigns) {
        if (hexCommaString == null || hexCommaString.trim().length() == 0) {
            return hexCommaString;
        }
        String[] items = hexCommaString.split(",");
        StringBuffer strRet = new StringBuffer();
        if (items == null || items.length == 0) {
            return hexCommaString;
        }
        if (items.length == 1 && hexCommaString.indexOf(" ") == -1) {
            try {
                int x = 0;
                while (x < hexCommaString.length()) {
                    strRet.append((char)Integer.parseInt(hexCommaString.substring(x, x + 2), 16));
                    x += 2;
                }
                return strRet.toString();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        try {
            int x = 0;
            while (items != null && x != items.length) {
                char sign = (char)Integer.parseInt(items[x], 16);
                if (!deleteNullSigns || deleteNullSigns && sign != '\u0000' || x % 2 == 0) {
                    strRet.append(sign);
                }
                ++x;
            }
        }
        catch (Exception ex) {
            return hexCommaString;
        }
        if (deleteNullSigns && strRet.charAt(strRet.length() - 1) == '\u0000') {
            strRet.deleteCharAt(strRet.length() - 1);
        }
        return strRet.toString();
    }

    public static String convertStringToHexComma(String plain, boolean appendNullSigns) {
        if (plain == null || plain.trim().length() == 0) {
            return plain;
        }
        StringBuffer strBuf = new StringBuffer();
        int x = 0;
        while (x != plain.length()) {
            if (x > 0) {
                strBuf.append(",");
            }
            strBuf.append(Integer.toHexString(plain.charAt(x)));
            if (appendNullSigns) {
                strBuf.append(",00");
            }
            ++x;
        }
        return strBuf.toString();
    }

    private static String convertStringToHex(String plain) {
        if (plain == null || plain.trim().length() == 0) {
            return plain;
        }
        StringBuffer strBuf = new StringBuffer();
        int x = 0;
        while (x != plain.length()) {
            strBuf.append(Integer.toHexString(plain.charAt(x)));
            ++x;
        }
        return strBuf.toString();
    }

    private void initMethods() throws RegistryErrorException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.util.prefs.WindowsPreferences");
            Method[] ms = clazz.getDeclaredMethods();
            if (ms == null) {
                throw new RegistryErrorException("Cannot access java.util.prefs.WindowsPreferences class!");
            }
            int x = 0;
            while (x != ms.length) {
                if (ms[x] != null) {
                    if (ms[x].getName().equals("WindowsRegOpenKey")) {
                        this.openKey = ms[x];
                        this.openKey.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegCloseKey")) {
                        this.closeKey = ms[x];
                        this.closeKey.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegCreateKeyEx")) {
                        this.createKey = ms[x];
                        this.createKey.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegDeleteKey")) {
                        this.delKey = ms[x];
                        this.delKey.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegFlushKey")) {
                        this.flushKey = ms[x];
                        this.flushKey.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegQueryValueEx")) {
                        this.queryValue = ms[x];
                        this.queryValue.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegSetValueEx")) {
                        this.setValue = ms[x];
                        this.setValue.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegDeleteValue")) {
                        this.delValue = ms[x];
                        this.delValue.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegQueryInfoKey")) {
                        this.queryInfoKey = ms[x];
                        this.queryInfoKey.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegEnumKeyEx")) {
                        this.enumKey = ms[x];
                        this.enumKey.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegEnumValue")) {
                        this.enumValue = ms[x];
                        this.enumValue.setAccessible(true);
                    }
                }
                ++x;
            }
        }
        catch (ClassNotFoundException ex) {
            throw RegistryErrorException.getException(ex);
        }
    }

    private void initNatvieRegistry() throws RegistryErrorException {
        try {
            Runtime.getRuntime().exec("reg.exe");
            this.nativeHandler = new RegHandler();
        }
        catch (Exception ex) {
            this.nativeHandler = new RegeditHandler();
        }
    }

    public void cacheKeys(Key key) throws RegistryErrorException {
        this.cacheKeys(key, 1);
    }

    public void cacheKeys(Key key, int maximumChildren) throws RegistryErrorException {
        if (key == null) {
            throw new NullPointerException("Registry key cannot be null");
        }
        if (this.nativeHandler == null) {
            throw new RegistryErrorException("NativeHandler is not initalized!");
        }
        this.nativeHandler.cacheKeys(key.getPath(), maximumChildren);
    }

    public void setCaching(boolean aValue) {
        if (this.useCache != aValue) {
            this.useCache = aValue;
        }
    }

    public boolean isCachingActive() {
        return this.useCache;
    }

    public List getCachingKeys() {
        ArrayList<String> ret = null;
        if (this.isCachingActive() && this.caches != null && this.caches.size() > 0) {
            ret = new ArrayList<String>();
            int x = 0;
            while (x != this.caches.size()) {
                CachedEntry entry = (CachedEntry)this.caches.get(x);
                if (entry != null) {
                    ret.add(entry.getKey());
                }
                ++x;
            }
        }
        return ret;
    }

    public void refreshCaches() throws RegistryErrorException {
        if (this.isCachingActive() && this.caches != null && this.caches.size() > 0) {
            List tmpCache = (List)this.caches.clone();
            this.caches = new ArrayList();
            int x = 0;
            while (tmpCache != null && x != tmpCache.size()) {
                CachedEntry entry = (CachedEntry)tmpCache.get(x);
                if (entry != null) {
                    String key = entry.getKey();
                    if (this.nativeHandler == null) {
                        throw new RegistryErrorException("NativeHandler is not initalized!");
                    }
                    this.nativeHandler.cacheKeys(key, 1);
                }
                ++x;
            }
        }
    }

    public void deleteCaches() {
        if (this.isCachingActive()) {
            int x = 0;
            while (this.caches != null && x != this.caches.size()) {
                CachedEntry entry = (CachedEntry)this.caches.get(x);
                if (entry != null) {
                    List entries;
                    List children = entry.getChildren();
                    if (children != null) {
                        children.clear();
                    }
                    if ((entries = entry.getEntries()) != null) {
                        entries.clear();
                    }
                }
                ++x;
            }
            this.caches.clear();
            this.caches = null;
        }
    }

    private String getCachedValue(String key, String name) throws NoEntryException {
        if (this.isCachingActive()) {
            int x = 0;
            while (this.caches != null && x != this.caches.size()) {
                CachedEntry entry = (CachedEntry)this.caches.get(x);
                CachedEntry child = entry.findSub(key);
                if (child != null) {
                    List list = child.getEntries();
                    if (list == null) {
                        throw new NoEntryException(String.valueOf(key) + " @ " + name + " not found in registry");
                    }
                    int y = 0;
                    while (list != null && y != list.size()) {
                        CachedValue val = (CachedValue)list.get(y);
                        if (val != null && val.getName().equals(name)) {
                            return val.getData();
                        }
                        ++y;
                    }
                    if (list.size() > 0) {
                        throw new NoEntryException(String.valueOf(key) + " @ " + name + " not found in registry");
                    }
                }
                ++x;
            }
        }
        return null;
    }

    private void setChachedValue(String key, String name, String value) {
        if (this.isCachingActive()) {
            int x = 0;
            while (this.caches != null && x != this.caches.size()) {
                CachedEntry entry = (CachedEntry)this.caches.get(x);
                CachedEntry child = entry.findSub(key);
                if (child != null) {
                    List list = child.getEntries();
                    int y = 0;
                    while (list != null && y != list.size()) {
                        CachedValue val = (CachedValue)list.get(y);
                        if (val != null && val.getName().equals(name)) {
                            val.setData(value);
                            break;
                        }
                        ++y;
                    }
                }
                ++x;
            }
        }
    }

    private static void _waitForFile(File file) {
        try {
            long size = file.length();
            Thread.sleep(WAIT_FOR_FILE);
            if (size != file.length()) {
                Regor._waitForFile(file);
            }
        }
        catch (Exception ex) {
            System.err.println("ERROR WAITING FOR FILE: " + file);
        }
    }

    public static void main(String[] args) throws Exception {
        Regor regor = new Regor();
        Key key = regor.openKey(HKEY_CURRENT_USER, "Software\\Adobe\\CommonFiles");
        System.out.println(">>>!" + Regor.parseHexString(regor.readBinary(key, "BINARY"), false));
        System.out.println(">>>!" + regor.readBinary(key, "BINARY"));
        System.out.println(">>>RA!" + regor.readAnyValueString(key, "BINARY"));
        System.out.println(">>>!" + Regor.parseHexString(regor.readAnyValueString(key, "BINARY"), false) + "!");
        System.out.println(">>>>!" + Regor.parseHexString(regor.readDword(key, "PFERDA"), true));
        System.out.println(">>>>!" + regor.readDword(key, "PFERDA"));
        regor.closeKey(key);
        Key _key = regor.openKey(HKEY_LOCAL_MACHINE, "SYSTEM\\ControlSet001\\Services");
        Key __key = regor.openKey(_key, "xmlprov");
        System.out.println(">>1 " + regor.readAnyValueString(__key, "Description"));
        System.out.println(">>2 " + regor.readAnyValueString(__key, "dword"));
        System.out.println(">>3 " + regor.readAnyValueString(__key, "bla"));
        System.out.println(">>4 " + regor.readAnyValueString(__key, "bin2"));
        System.out.println(">>5 " + regor.readAnyValueString(__key, "expand2"));
        System.out.println(">>6 " + regor.readAnyValueString(__key, "multi"));
        System.out.println(">>>>MULTI1 " + regor.readMulti(__key, "multi"));
        System.out.println(">>>PARSEMULTI1 " + Regor.parseHexString(regor.readMulti(__key, "multi"), true));
        regor.savePlainMulti(__key, "multi", "WURSTSEMAL @ " + System.currentTimeMillis());
        System.out.println(">>>>MULTI2 " + regor.readMulti(__key, "multi"));
        System.out.println(">>>PARSEMULTI2 " + Regor.parseHexString(regor.readMulti(__key, "multi"), true));
        System.out.println(">>>>EXPAND " + regor.readExpand(__key, "expand"));
        System.out.println(">>>PARSEEXPAND " + Regor.parseHexString(regor.readExpand(__key, "expand"), true));
        System.out.println(">>>>DWORD " + regor.readDword(__key, "dword"));
        System.out.println(">>>PARSEDWORD " + Regor.parseHexString(regor.readMulti(__key, "dword"), true));
        System.out.println(">>>>BIN " + regor.readBinary(__key, "bin"));
        System.out.println(">>>PARSEBIN " + Regor.parseHexString(regor.readBinary(__key, "bin"), false));
        regor.closeKey(__key);
        regor.closeKey(_key);
    }

    private static interface INativeRegistryHandler {
        public boolean saveAnyValue(String var1, String var2, String var3, String var4) throws RegistryErrorException;

        public String extractAnyValue(String var1, String var2, boolean var3) throws RegistryErrorException;

        public void cacheKeys(String var1, int var2) throws RegistryErrorException;
    }

    private static final class NoEntryException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoEntryException(String str) {
            super(str);
        }
    }

    private final class RegHandler
    implements INativeRegistryHandler {
        private RegHandler() {
        }

        public boolean saveAnyValue(String path, String valueName, String type, String data) throws RegistryErrorException {
            try {
                if (type.equals(Regor.BINARY_KEY_IDENT)) {
                    type = Regor.BINARY_KEY_NAME;
                } else if (type.equals(Regor.DWORD_KEY_IDENT)) {
                    type = Regor.DWORD_KEY_NAME;
                } else if (type.equals(Regor.MULTI_KEY_IDENT)) {
                    type = Regor.MULTI_KEY_NAME;
                } else if (type.equals(Regor.EXPAND_KEY_IDENT)) {
                    type = Regor.EXPAND_KEY_NAME;
                }
                Runtime.getRuntime().exec("reg add \"" + path + "\" /v \"" + valueName + "\" /t " + type + " /d \"" + data + "\" /f");
                Regor.this.setChachedValue(path, valueName, data);
            }
            catch (Exception ex) {
                System.err.println(ex.getLocalizedMessage());
                throw RegistryErrorException.getException(ex);
            }
            return true;
        }

        public String extractAnyValue(String path, String valueName, boolean appendType) throws RegistryErrorException {
            block20: {
                try {
                    String tmp = Regor.this.getCachedValue(path, valueName);
                    if (tmp != null) {
                        return tmp;
                    }
                    if (Regor.this.useCache) {
                        System.out.println("CACHED KEY: " + path + " AND VALUE NOT FOUND: " + valueName);
                    }
                }
                catch (NoEntryException nee) {
                    if (!Regor.this.isCachingActive()) break block20;
                    return null;
                }
            }
            StringBuffer strRet = new StringBuffer();
            BufferedReader br = null;
            File f = null;
            try {
                try {
                    f = File.createTempFile("regorexp", ".jta");
                    Runtime.getRuntime().exec("cmd /c \"reg query \"" + path + "\" /v \"" + valueName + "\" > " + f.getAbsolutePath() + " 2>&1\"").waitFor();
                    Regor._waitForFile(f);
                    br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                    String line = "";
                    boolean lineFound = false;
                    while ((line = br.readLine()) != null) {
                        String foundValueName;
                        if (line.equals(path)) {
                            lineFound = true;
                            continue;
                        }
                        if (!lineFound || line.trim().length() <= 0) continue;
                        int regIndex = line.indexOf("\tREG_");
                        int adding = 5;
                        if (regIndex == -1) {
                            regIndex = line.indexOf("    REG_");
                            adding = 4;
                        }
                        if (!(foundValueName = line.substring(4, regIndex)).equals(valueName)) continue;
                        line = line.substring(regIndex + adding);
                        String[] items = line.split("\\s+", 2);
                        if (appendType) {
                            strRet.append(items[0]);
                            strRet.append(" ");
                        }
                        strRet.append(items[1]);
                        if (items[0].equals(Regor.MULTI_KEY_NAME) && strRet.toString().endsWith("\\0\\0")) {
                            strRet.setLength(strRet.length() - 4);
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    System.err.println(ex.getLocalizedMessage());
                    throw RegistryErrorException.getException(ex);
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception exception) {}
                if (f != null && !f.delete()) {
                    f.deleteOnExit();
                }
            }
            return strRet.toString();
        }

        public void cacheKeys(String key, int maximumChildren) throws RegistryErrorException {
            File f = null;
            BufferedReader br = null;
            try {
                try {
                    Object[] tmp;
                    f = File.createTempFile("regorexp", ".jta");
                    Runtime.getRuntime().exec("cmd /c \"reg query \"" + key + "\" /s > " + f.getAbsolutePath() + " 2>&1\"").waitFor();
                    Regor._waitForFile(f);
                    br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                    String line = "";
                    CachedEntry entry = new CachedEntry();
                    CachedEntry currentEntry = null;
                    String currentKey = null;
                    entry.setKey(key);
                    while ((line = br.readLine()) != null) {
                        if (line.trim().length() <= 0) continue;
                        if (line.startsWith("HKEY_")) {
                            if (currentEntry != null && (tmp = entry.getSub(currentEntry.getKey())) != null && (Integer)tmp[1] < maximumChildren) {
                                ((CachedEntry)tmp[0]).appendChildren(currentEntry);
                            }
                            currentEntry = null;
                            currentKey = line;
                            if (currentKey == null || currentKey.length() <= 0) continue;
                            if (currentKey.equals(entry.getKey())) {
                                currentEntry = entry;
                                continue;
                            }
                            currentEntry = new CachedEntry();
                            currentEntry.setKey(currentKey);
                            continue;
                        }
                        if (currentEntry == null || line.startsWith("Error:  ")) continue;
                        StringBuffer strRet = new StringBuffer();
                        int regIndex = line.indexOf("\tREG_");
                        int adding = 5;
                        if (regIndex == -1) {
                            regIndex = line.indexOf("    REG_");
                            adding = 4;
                        }
                        String valueName = line.substring(4, regIndex);
                        line = line.substring(regIndex + adding);
                        String[] items = line.split("\\s+", 2);
                        strRet.append(items[1]);
                        CachedValue currentValue = new CachedValue();
                        if (valueName.equals("<NO NAME>")) {
                            currentValue.setName("");
                        } else {
                            currentValue.setName(valueName);
                        }
                        currentValue.setData(strRet.toString());
                        currentEntry.appendEntry(currentValue);
                    }
                    if (currentEntry != null && (tmp = entry.getSub(currentEntry.getKey())) != null && (Integer)tmp[1] < maximumChildren) {
                        ((CachedEntry)tmp[0]).appendChildren(currentEntry);
                    }
                    if (Regor.this.caches == null) {
                        Regor.this.caches = new ArrayList();
                    }
                    Regor.this.caches.add(entry);
                }
                catch (Exception ex) {
                    System.err.println(ex.getLocalizedMessage());
                    throw RegistryErrorException.getException(ex);
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception exception) {}
                if (f != null && !f.delete()) {
                    f.deleteOnExit();
                }
            }
        }
    }

    private final class RegeditHandler
    implements INativeRegistryHandler {
        private RegeditHandler() {
        }

        public boolean saveAnyValue(String path, String valueName, String type, String data) throws RegistryErrorException {
            try {
                File f = File.createTempFile("regorexp", ".jta");
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));
                bw.write(Regor.INIT_WINDOWS_STRING);
                bw.newLine();
                bw.newLine();
                bw.write("[");
                bw.write(path);
                bw.write("]");
                bw.newLine();
                bw.write("\"");
                bw.write(valueName);
                bw.write("\"=");
                bw.write(type);
                bw.write(data);
                bw.newLine();
                bw.close();
                Runtime.getRuntime().exec("regedit /s /i " + f.getAbsolutePath()).waitFor();
                if (!f.delete()) {
                    f.deleteOnExit();
                }
                Regor.this.setChachedValue(path, valueName, data);
            }
            catch (Exception ex) {
                System.err.println(ex.getLocalizedMessage());
                throw RegistryErrorException.getException(ex);
            }
            return true;
        }

        public String extractAnyValue(String path, String valueName, boolean appendType) throws RegistryErrorException {
            block19: {
                try {
                    String tmp = Regor.this.getCachedValue(path, valueName);
                    if (tmp != null) {
                        return tmp;
                    }
                    if (Regor.this.useCache) {
                        System.out.println("CACHED KEY: " + path + " AND VALUE NOT FOUND: " + valueName);
                    }
                }
                catch (NoEntryException nee) {
                    if (!Regor.this.isCachingActive()) break block19;
                    return null;
                }
            }
            StringBuffer strRet = new StringBuffer();
            File f = null;
            BufferedReader br = null;
            try {
                try {
                    f = File.createTempFile("regorexp", ".jta");
                    Runtime.getRuntime().exec("regedit /e " + f.getAbsolutePath() + " \"" + path + "\"").waitFor();
                    Regor._waitForFile(f);
                    br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                    String line = "";
                    boolean lineFound = false;
                    boolean keyFound = false;
                    while ((line = br.readLine()) != null) {
                        if ((line = line.replaceAll(NULL_STRING, "")).length() <= 0 || !keyFound && (!line.startsWith("[") || !line.endsWith("]"))) continue;
                        if (line.startsWith("[") && line.endsWith("]")) {
                            if (keyFound) break;
                            if (!line.equals("[" + path + "]")) continue;
                            keyFound = true;
                            continue;
                        }
                        if (!keyFound || !lineFound && (!line.startsWith("\"" + valueName) || line.indexOf("=") == -1)) continue;
                        if (lineFound) {
                            if (line.length() <= 0) continue;
                            if (line.indexOf("=") != -1) break;
                            strRet.append(line.trim().replaceAll("\\\\", ""));
                            if (line.endsWith("\\")) continue;
                            break;
                        }
                        line = line.substring(line.indexOf("=") + 1);
                        strRet.append(line.replaceAll("\\\\", ""));
                        lineFound = true;
                        if (line.indexOf("\\") == -1) break;
                    }
                    br.close();
                    if (!f.delete()) {
                        f.deleteOnExit();
                    }
                }
                catch (Exception ex) {
                    System.err.println(ex.getLocalizedMessage());
                    throw RegistryErrorException.getException(ex);
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception exception) {}
                if (f != null && !f.delete()) {
                    f.deleteOnExit();
                }
            }
            return strRet.length() == 0 ? null : strRet.toString();
        }

        public void cacheKeys(String key, int maximumChildren) throws RegistryErrorException {
            StringBuffer strRet = new StringBuffer();
            try {
                Object[] tmp;
                File f = File.createTempFile("regorexp", ".jta");
                Runtime.getRuntime().exec("regedit /e " + f.getAbsolutePath() + " \"" + key + "\"").waitFor();
                Regor._waitForFile(f);
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                String line = "";
                CachedEntry entry = new CachedEntry();
                CachedEntry currentEntry = null;
                CachedValue currentValue = null;
                entry.setKey(key);
                while ((line = br.readLine()) != null) {
                    if ((line = line.replaceAll(NULL_STRING, "")) == null || line.length() <= 0) continue;
                    if (line.startsWith("[") && line.endsWith("]")) {
                        String currentKey;
                        if (currentEntry != null) {
                            tmp = entry.getSub(currentEntry.getKey());
                            if (tmp != null && (Integer)tmp[1] < maximumChildren) {
                                ((CachedEntry)tmp[0]).appendChildren(currentEntry);
                            }
                            currentEntry = null;
                        }
                        if ((currentKey = line.substring(1, line.length() - 1)) == null || currentKey.length() <= 0) continue;
                        if (currentKey.equals(entry.getKey())) {
                            currentEntry = entry;
                            continue;
                        }
                        currentEntry = new CachedEntry();
                        currentEntry.setKey(currentKey);
                        continue;
                    }
                    if (currentEntry == null || line.indexOf("=") == -1 && currentValue == null) continue;
                    if (currentValue != null) {
                        if (line.length() <= 0) continue;
                        if (line.indexOf("=") != -1) {
                            currentValue.setData(strRet.toString());
                            strRet.delete(0, strRet.length());
                            currentEntry.appendEntry(currentValue);
                            currentValue = null;
                            continue;
                        }
                        if ((line = line.trim()).endsWith("\\")) {
                            strRet.append(line.substring(0, line.length() - 1));
                            continue;
                        }
                        strRet.append(line.trim());
                        currentValue.setData(strRet.toString());
                        strRet.delete(0, strRet.length());
                        currentEntry.appendEntry(currentValue);
                        currentValue = null;
                        continue;
                    }
                    String currentName = line.substring(0, line.indexOf("="));
                    if (currentName.equals("@")) {
                        currentName = "";
                    }
                    currentValue = new CachedValue();
                    currentValue.setName(currentName.replaceAll("\"", ""));
                    line = line.substring(line.indexOf("=") + 1);
                    if (line.endsWith("\\")) {
                        strRet.append(line.substring(0, line.length() - 1));
                        continue;
                    }
                    strRet.append(line);
                    currentValue.setData(strRet.toString());
                    strRet.delete(0, strRet.length());
                    currentEntry.appendEntry(currentValue);
                    currentValue = null;
                }
                if (currentEntry != null && (tmp = entry.getSub(currentEntry.getKey())) != null && (Integer)tmp[1] < maximumChildren) {
                    ((CachedEntry)tmp[0]).appendChildren(currentEntry);
                }
                br.close();
                if (!f.delete()) {
                    f.deleteOnExit();
                }
                if (Regor.this.caches == null) {
                    Regor.this.caches = new ArrayList();
                }
                Regor.this.caches.add(entry);
            }
            catch (Exception ex) {
                System.err.println(ex.getLocalizedMessage());
                throw RegistryErrorException.getException(ex);
            }
        }
    }
}

