/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;

public class Service {
    public static void main(String[] args) throws Exception {
        System.out.println(Service.handleMixedCase("emp"));
        System.out.println(Service.handleMixedCase("\"DOT.DOt\""));
        System.out.println(Service.handleMixedCase("\"HR\".\"DOT.DOT\""));
    }

    public static String readFile(Class c, String file) throws Exception {
        URL u = c.getResource(file);
        return Service.readFile(u.openStream());
    }

    public static String readFile(String file) throws Exception {
        return Service.readFile(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(InputStream is) throws Exception {
        byte[] bytes = new byte[4096];
        int bytesRead = 0;
        BufferedInputStream bin = null;
        StringBuffer ret = new StringBuffer();
        try {
            bin = new BufferedInputStream(is);
            bytesRead = bin.read(bytes, 0, bytes.length);
            while (bytesRead != -1) {
                ret.append(new String(bytes).substring(0, bytesRead));
                bytesRead = bin.read(bytes, 0, bytes.length);
            }
        }
        finally {
            if (bin != null) {
                bin.close();
            }
        }
        return ret.toString();
    }

    public static void copy(URL url, String dstdir) {
        try {
            int len;
            String name;
            InputStream in;
            if (url.toString().startsWith("jar:file:")) {
                int end = url.toString().indexOf(33);
                String jarFile = url.toString().substring("jar:file:".length(), end);
                JarFile jar = new JarFile(jarFile);
                JarEntry je = jar.getJarEntry(url.toString().substring(end + 2));
                in = jar.getInputStream(je);
                String path = je.getName();
                File file = new File(path);
                name = file.getName();
            } else {
                String path = url.getPath();
                File file = new File(path);
                name = file.getName();
                in = new FileInputStream(path);
            }
            FileOutputStream out = new FileOutputStream(new File(dstdir + File.separator + name));
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String toNull(String src) {
        return "".equals(src) ? null : src;
    }

    public static String identln(int level, String txt) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            b.append(" ");
        }
        b.append(txt);
        return b.toString();
    }

    public static int pair(int x, int y) {
        return y << 16 | x;
    }

    public static int Y(int p) {
        return p >> 16;
    }

    public static int X(int p) {
        return p & 0xFFFF;
    }

    public static long lPair(int x, int y) {
        return (long)y << 32 | (long)x;
    }

    public static int lY(long p) {
        return (int)(p >> 32);
    }

    public static int lX(long p) {
        return (int)p;
    }

    public static int decrPair(int p) {
        return p - 65537;
    }

    public static String handleMixedCase(String name) {
        LinkedList<LexerToken> out = LexerToken.parse(name, true, true);
        StringBuilder ret = new StringBuilder();
        for (LexerToken t : out) {
            String s = t.content;
            s = t.type == Token.DQUOTED_STRING ? s.substring(1, s.length() - 1) : s.toUpperCase();
            ret.append(s);
        }
        return ret.toString();
    }

    public static String addDoubleQuote(String s) {
        boolean quote = false;
        String legitimateChars = "$#_";
        if (!s.startsWith("\"") && !quote) {
            char[] chars = new char[s.length()];
            s.getChars(0, chars.length, chars, 0);
            if (chars.length > 0 && '0' <= chars[0] && chars[0] <= '9') {
                quote = true;
            } else {
                for (char c : chars) {
                    if (legitimateChars.indexOf(c) >= 0 || c >= '0' && ('9' >= c || c >= 'A') && 'Z' >= c) continue;
                    quote = true;
                    break;
                }
            }
        }
        return quote ? MessageFormat.format("\"{0}\"", s) : s;
    }

    public static String into2chars(String data) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < data.length(); ++i) {
            ret.append(Service.into2chars(data.charAt(i)));
        }
        return ret.toString();
    }

    public static String from2chars(String data) {
        if (data == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < data.length()) {
            char[] chunk = new char[2];
            chunk[0] = data.charAt(i++);
            if (i >= data.length()) {
                return null;
            }
            chunk[1] = data.charAt(i++);
            ret.append(Service.from2chars(chunk));
        }
        return ret.toString();
    }

    static char[] into2chars(char input) {
        char[] ret = new char[]{(char)(Service.periodicRemainder(input, 16) + 70), (char)(Service.periodicDivision(input, 16) + 70)};
        return ret;
    }

    static char from2chars(char[] input) {
        return (char)((input[1] - 70) * 16 + (input[0] - 70));
    }

    static int periodicRemainder(int i, int j) {
        int ret = i % j;
        if (ret < 0) {
            ret += j;
        }
        return ret;
    }

    static int periodicDivision(int i, int j) {
        int ret = i / j;
        if (ret < 0) {
            --ret;
        }
        return ret;
    }
}

