/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLHelper {
    private static DocumentBuilderFactory factory = null;
    private static DocumentBuilder builder = null;
    private static Document document = null;
    private static Element root = null;

    public static Node getChildNode(Node node, String s) {
        try {
            if (node == null || s == null) {
                return null;
            }
            NodeList nl = ((XMLNode)node).getChildNodes();
            Node ret = null;
            String name = s.indexOf("/") == 0 ? s.substring(1) : s;
            for (int i = 0; ret == null && i < nl.getLength(); ++i) {
                if (!nl.item(i).getNodeName().equals(name)) continue;
                ret = nl.item(i);
            }
            return ret;
        }
        catch (Exception e) {
            Logger.getLogger(XMLHelper.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return null;
        }
    }

    public static XMLNode[] getChildNodes(Node node, String s) {
        XMLNode[] result = null;
        try {
            NodeList nl = ((XMLNode)node).getChildNodes();
            ArrayList<XMLNode> l = new ArrayList<XMLNode>();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (!nl.item(i).getNodeName().equalsIgnoreCase(s)) continue;
                l.add((XMLNode)nl.item(i));
            }
            if (l.size() > 0) {
                result = new XMLNode[l.size()];
                l.toArray(result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result != null ? result : new XMLNode[]{};
    }

    public static String getNodeValue(Node node, String name) {
        String value = null;
        if (node != null) {
            Node child = XMLHelper.getChildNode(node, name);
            if (child == null) {
                return "";
            }
            Node n1 = child.getFirstChild();
            if (n1 instanceof Text) {
                value = ((Text)n1).getTextContent();
            }
            value = n1 != null ? n1.getNodeValue() : child.getNodeValue();
        }
        return value;
    }

    public static String getAttributeNode(Node node, String s) {
        String ret = null;
        try {
            if (node != null) {
                Node n;
                String path;
                String string = path = s.startsWith("@") ? s.substring(1) : s;
                if (node.getAttributes() != null && (n = node.getAttributes().getNamedItem(path)) != null) {
                    ret = n.getNodeValue();
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(XMLHelper.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return ret;
    }

    public static Element NewDocument() {
        try {
            factory = DocumentBuilderFactory.newInstance();
            factory.setCoalescing(true);
            builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            root = document.createElement("reports");
            document.appendChild(root);
            return root;
        }
        catch (ParserConfigurationException pce) {
            Logger.getLogger(XMLHelper.class.getName()).info(pce.toString());
            return null;
        }
    }

    public static Element addFolder(Element parent, String iName, String iDesc, String iTip) {
        Element folder = document.createElement("folder");
        Element name = document.createElement("name");
        name.appendChild(document.createCDATASection(iName.trim()));
        folder.appendChild(name);
        Element desc = document.createElement("description");
        desc.appendChild(document.createCDATASection(iDesc.trim()));
        folder.appendChild(desc);
        Element tip = document.createElement("tooltip");
        tip.appendChild(document.createCDATASection(iTip.trim()));
        folder.appendChild(tip);
        parent.appendChild(folder);
        return folder;
    }

    public static void addReport(Element parent, String iName, String iDesc, String iTip, String iSql) {
        Element report = document.createElement("report");
        report.setAttribute("type", "report");
        report.setAttribute("enabled", "true");
        Element name = document.createElement("name");
        name.appendChild(document.createCDATASection(iName.trim()));
        report.appendChild(name);
        Element desc = document.createElement("description");
        desc.appendChild(document.createCDATASection(iDesc.trim()));
        report.appendChild(desc);
        Element tip = document.createElement("tooltip");
        tip.appendChild(document.createCDATASection(iTip.trim()));
        report.appendChild(tip);
        Element query = document.createElement("query");
        report.appendChild(query);
        Element sql = document.createElement("sql");
        sql.appendChild(document.createCDATASection(iSql.trim()));
        query.appendChild(sql);
        parent.appendChild(report);
    }

    public static Document getDocument() {
        return document;
    }
}

