/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.util.Service;

public class SqlId {
    public int fileCnt = 0;
    private int sqlCnt = 0;
    private int changeCnt = 0;
    private String prefix = " ";
    private Set<String> fileExtensions;

    public void walkDir(File file) throws FileNotFoundException, Exception {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.walkDir(child);
            }
        } else {
            this.rewrite(file);
        }
    }

    public SqlId(String prefix, Set<String> fileExtensions) {
        this.prefix = prefix;
        this.fileExtensions = fileExtensions;
    }

    public void rewrite(File file) throws FileNotFoundException, Exception {
        int dotPos;
        String fullPrefix = " /* " + this.prefix;
        String fileName = file.getName();
        if (fileName.length() > 4 && (dotPos = fileName.lastIndexOf(46)) >= 0 && dotPos < fileName.length() - 3) {
            String suffix = "*" + fileName.substring(dotPos).toLowerCase();
            if (this.fileExtensions.contains("*.*") || this.fileExtensions.contains(suffix)) {
                String input = Service.readFile(new FileInputStream(file));
                LinkedList<LexerToken> src = LexerToken.parse(input);
                LazyNode root = StackParser.parse(src);
                List<Integer> insertionPoints = SqlId.getInsertionsPoints(root, src);
                int pos = -1;
                int priorLexPos = 0;
                StringBuilder output = new StringBuilder();
                for (LexerToken t : src) {
                    if (!insertionPoints.contains(++pos)) continue;
                    ++this.sqlCnt;
                    if (fullPrefix.equals(input.substring(t.end, t.end + fullPrefix.length()))) continue;
                    output.append(input.substring(priorLexPos, t.end));
                    priorLexPos = t.end;
                    output.append(fullPrefix + UUID.randomUUID().toString().substring(0, 6) + " */ ");
                    ++this.changeCnt;
                }
                output.append(input.substring(priorLexPos));
                FileWriter fstream = new FileWriter(file);
                BufferedWriter out = new BufferedWriter(fstream);
                out.write(output.toString());
                out.close();
                ++this.fileCnt;
            }
        }
    }

    private static List<Integer> getInsertionsPoints(LazyNode node, LinkedList<LexerToken> src) {
        LinkedList<Integer> ret = new LinkedList<Integer>();
        if ("insert".equalsIgnoreCase(node.startToken) || "update".equalsIgnoreCase(node.startToken) || "delete".equalsIgnoreCase(node.startToken) || "select".equalsIgnoreCase(node.startToken) || "with".equalsIgnoreCase(node.startToken) || "merge".equalsIgnoreCase(node.startToken)) {
            ret.add(node.from);
        } else if ("cursor".equalsIgnoreCase(node.startToken) || "for".equalsIgnoreCase(node.startToken)) {
            int pos = -1;
            int start = node.from;
            int end = node.to;
            if ("for".equalsIgnoreCase(node.startToken)) {
                int i = -1;
                for (LazyNode child : node.shallowChildren()) {
                    if (++i == 0) {
                        start = child.from;
                        end = child.to;
                        continue;
                    }
                    ret.addAll(SqlId.getInsertionsPoints(child, src));
                }
            }
            for (LexerToken t : src) {
                if (++pos >= end) break;
                if (pos < start || !"select".equalsIgnoreCase(t.content)) continue;
                ret.add(pos);
                break;
            }
        } else {
            for (LazyNode child : node.shallowChildren()) {
                ret.addAll(SqlId.getInsertionsPoints(child, src));
            }
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        switch (args.length) {
            default: {
                System.out.println("Usage: java -jar <utils-nodeps.jar> \n<directory> <prefix> \ne.g. \njava -jar C:\\sqld\\sqldeveloper\\lib\\oracle.sqldeveloper.utils-nodeps.jar\nC:\\Apex_code APEX");
                return;
            }
            case 1: 
            case 2: 
        }
        File dir = new File(args[0]);
        HashSet<String> fileExts = new HashSet<String>();
        fileExts.add("*.plb");
        fileExts.add("*.pls");
        fileExts.add("*.pkb");
        SqlId instance = new SqlId(" ", fileExts);
        if (!dir.exists()) {
            System.out.println("Specified directory does not exist.");
        }
        if (args.length == 2) {
            instance.prefix = args[1];
        }
        instance.walkDir(dir);
        System.out.println(instance.log());
    }

    public String log() {
        return "Processed " + this.fileCnt + " files, found " + this.sqlCnt + " statements, stamped " + this.changeCnt + " of them";
    }
}

