/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.PlsqlRules;
import oracle.dbtools.util.Service;

public class PlsqlCYK
extends CYK {
    public static PlsqlCYK instance;
    private Set<Integer> keywords = new TreeSet<Integer>();
    static boolean debug;
    private int body = this.getSymbol("body");
    public int stmt = this.getSymbol("stmt");
    private int fml_part = this.getSymbol("fml_part");
    private int plain_subquery = this.getSymbol("plain_subquery");
    private int query_term = -1;
    private int set_operator = -1;
    private int binary_add_op = -1;
    private int procedure_call = -1;
    private int expr = -1;
    private int orSymbol = -1;
    private int andSymbol = -1;
    private int verticalStrokeSymbol = -1;
    private int commaSymbol = -1;
    private int semicolonSymbol = -1;
    private int allSymbol = -1;
    private int beginSymbol = -1;
    private int dotdotAND__reldotdot = -1;
    private int dotdot_basic_decl_item_dotdot = this.getSymbol("..basic_decl_item..");
    private int dotdot_dotprm_specdotdot = -1;
    private int dotdotdotsim_expr_dotiddotdotdot = -1;
    private int dotdotdotcmpon_ascdotdot = -1;
    private int dotdotstmtdotdot = -1;
    private int termdotdotbinary_add_op__termdotdot = -1;
    public int idents = -1;
    public int table_reference_or_subquery = -1;
    public int from_table_reference_or_subquery = -1;
    public int identifier = -1;
    private final int maxKwdIdx;

    public static PlsqlCYK getInstance() {
        if (instance != null) {
            return instance;
        }
        PlsqlCYK.init();
        return instance;
    }

    static void init() {
        try {
            Set<RuleTuple> originalRules = PlsqlRules.getRules();
            instance = new PlsqlCYK(originalRules);
        }
        catch (Exception e) {
            Logger.getLogger(PlsqlCYK.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public static void main(String[] dummy) throws Exception {
        long h = Runtime.getRuntime().totalMemory();
        long hf = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (h - hf));
        String input = Service.readFile("d:\\eclipse\\raptor_trunk\\utils-nodeps\\src\\oracle\\dbtools\\parser\\plsql\\test.sql");
        Set<RuleTuple> rules = PlsqlRules.getRules();
        PlsqlCYK cyk = PlsqlCYK.getInstance();
        String symbol = "..stmt..";
        cyk.printSelectedChomskiRules("..stmt..");
        for (int l : cyk.singleRhsRules[cyk.symbolIndexes.get("..stmt..")]) {
            System.out.println(cyk.allSymbols[l]);
        }
        System.out.println("====================");
        long t1 = System.currentTimeMillis();
        LinkedList<LexerToken> src = LexerToken.parse(input);
        long t2 = System.currentTimeMillis();
        System.out.println("Lexer time = " + (t2 - t1));
        h = Runtime.getRuntime().totalMemory();
        hf = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (h - hf));
        t1 = System.currentTimeMillis();
        Matrix matrix = cyk.initArray1(src);
        t2 = System.currentTimeMillis();
        System.out.println("Init array time = " + (t2 - t1));
        int size = matrix.size();
        System.out.println("size = " + size);
        HashMap<Integer, Integer> skipRanges = new HashMap<Integer, Integer>();
        t1 = System.currentTimeMillis();
        ((CYK)cyk).closure(matrix, 0, size + 1, skipRanges, -1);
        t2 = System.currentTimeMillis();
        System.out.println("Parse time = " + (t2 - t1));
        System.out.println(skipRanges);
        cyk.print(matrix, 0, size);
        System.out.println("^^^^^^^^^^^^^");
        t1 = System.currentTimeMillis();
        ParseNode root = cyk.forest(size, matrix);
        t2 = System.currentTimeMillis();
        System.out.println("Reduction time = " + (t2 - t1));
        System.gc();
        h = Runtime.getRuntime().totalMemory();
        hf = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (h - hf));
        root.printTree();
    }

    public PlsqlCYK(Set<RuleTuple> originalRules) {
        super(originalRules);
        this.expr = this.getSymbol("expr");
        this.query_term = this.getSymbol("query_term");
        this.set_operator = this.getSymbol("set_operator");
        this.procedure_call = this.getSymbol("procedure_call");
        this.allSymbol = this.getSymbol("'ALL'");
        this.beginSymbol = this.getSymbol("'BEGIN'");
        this.dotdotAND__reldotdot = this.getSymbol("..AND__rel..");
        this.andSymbol = this.getSymbol("'AND'");
        this.orSymbol = this.getSymbol("'OR'");
        this.commaSymbol = this.getSymbol("','");
        this.semicolonSymbol = this.getSymbol("';'");
        this.verticalStrokeSymbol = this.getSymbol("'|'");
        this.dotdot_dotprm_specdotdot = this.getSymbol(".._.prm_spec..");
        this.dotdotdotsim_expr_dotiddotdotdot = this.getSymbol("...sim_expr_.id...");
        this.dotdotdotcmpon_ascdotdot = this.getSymbol("...cmpon_asc..");
        this.dotdotstmtdotdot = this.getSymbol("..stmt..");
        this.binary_add_op = this.getSymbol("binary_add_op");
        this.termdotdotbinary_add_op__termdotdot = this.getSymbol("term..binary_add_op__term..");
        this.idents = this.getSymbol("idents");
        this.table_reference_or_subquery = this.getSymbol("table_reference_or_subquery");
        this.from_table_reference_or_subquery = this.getSymbol("from_table_reference_or_subquery");
        this.identifier = this.getSymbol("identifier");
        this.maxKwdIdx = this.getSymbol("'|'");
        this.keywords.add(this.getSymbol("'IF'"));
        this.keywords.add(this.beginSymbol);
        this.keywords.add(this.getSymbol("'END'"));
        this.keywords.add(this.getSymbol("'ELSE'"));
        this.keywords.add(this.getSymbol("'THEN'"));
        this.keywords.add(this.getSymbol("'ELSIF'"));
        this.keywords.add(this.getSymbol("'CHAR'"));
        this.keywords.add(this.getSymbol("'FOR'"));
        this.keywords.add(this.getSymbol("'LOOP'"));
        this.keywords.add(this.getSymbol("'SELECT'"));
        this.keywords.add(this.getSymbol("'FROM'"));
        this.keywords.add(this.getSymbol("'WHERE'"));
        this.keywords.add(this.getSymbol("'AND'"));
        this.keywords.add(this.getSymbol("'NOT'"));
        this.keywords.add(this.getSymbol("'OR'"));
        this.keywords.add(this.getSymbol("'PROCEDURE'"));
        this.keywords.add(this.getSymbol("'IS'"));
        this.keywords.add(this.getSymbol("'AS'"));
        this.keywords.add(this.getSymbol("'EXCEPTION'"));
        this.keywords.add(this.getSymbol("'IN'"));
        this.keywords.add(this.getSymbol("'RETURN'"));
        this.keywords.add(this.getSymbol("'NULL'"));
        this.keywords.add(this.getSymbol("'CURSOR'"));
    }

    private boolean containsKwd(int[] cellContent) {
        if (cellContent == null) {
            return false;
        }
        for (int sb : cellContent) {
            if (Service.Y(sb) > this.maxKwdIdx) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initArrayElement(Matrix ret, int pos, LexerToken token, boolean identifiersOnly) {
        int symbol;
        Integer suspect = (Integer)this.symbolIndexes.get("'" + token.content.toUpperCase() + "'");
        TreeSet dependents = new TreeSet();
        if (suspect != null) {
            dependents.addAll(this.singleRhsRules[suspect]);
        }
        if (token.type == Token.IDENTIFIER) {
            if (!identifiersOnly || suspect == null || !this.keywords.contains(suspect)) {
                dependents.addAll(this.singleRhsRules[this.identifier]);
            }
        } else if (token.type == Token.DQUOTED_STRING) {
            dependents.addAll(this.singleRhsRules[this.identifier]);
        } else if (token.type == Token.QUOTED_STRING) {
            symbol = (Integer)this.symbolIndexes.get("string_literal");
            dependents.addAll(this.singleRhsRules[symbol]);
        } else if (token.type == Token.DIGITS) {
            symbol = (Integer)this.symbolIndexes.get("digits");
            dependents.addAll(this.singleRhsRules[symbol]);
        }
        int[] tmp = new int[dependents.size()];
        int i = 0;
        Iterator i$ = dependents.iterator();
        while (i$.hasNext()) {
            int e = (Integer)i$.next();
            tmp[i++] = Service.pair(pos, e);
        }
        ret.put(Service.pair(pos, pos + 1), tmp);
    }

    @Override
    public void closure(Matrix matrix, int from, int to, Map<Integer, Integer> skipRanges, int middle) {
        for (int y = 1; y < to; ++y) {
            block1: for (int x = y - 2; x >= from; --x) {
                Integer nextX;
                if (skipRanges != null && (nextX = skipRanges.get(x)) != null) {
                    if (Visual.skipped != null) {
                        for (int i = x; i > nextX; --i) {
                            Visual.skipped[i][y] = Visual.causes.get(Service.pair(x, nextX));
                        }
                    }
                    x = nextX + 1;
                    continue;
                }
                int start = Service.pair(x, y);
                int end = Service.pair(0, y + 1);
                LinkedList<Integer> tmp = new LinkedList<Integer>();
                SortedMap range = matrix.subMap(start, end);
                for (int key : range.keySet()) {
                    int[] suffixes;
                    int mid = Service.X(key);
                    int[] prefixes = (int[])matrix.get(Service.pair(x, mid));
                    if (prefixes == null || (suffixes = (int[])matrix.get(Service.pair(mid, y))) == null) continue;
                    for (int II : prefixes) {
                        int I = Service.Y(II);
                        for (int JJ : suffixes) {
                            int J = Service.Y(JJ);
                            Set A = (Set)this.doubleRhsRules.get(Service.pair(I, J));
                            if (A == null) continue;
                            Iterator i$ = A.iterator();
                            while (i$.hasNext()) {
                                int a = (Integer)i$.next();
                                int pair = Service.pair(mid, a);
                                if (tmp.contains(pair)) continue;
                                tmp.add(pair);
                            }
                        }
                    }
                }
                if (tmp.size() <= 0) continue;
                int[] tmp1 = new int[tmp.size()];
                int i = 0;
                Iterator i$ = tmp.iterator();
                while (i$.hasNext()) {
                    int e = (Integer)i$.next();
                    tmp1[i++] = e;
                }
                matrix.put(Service.pair(x, y), tmp1);
                if (skipRanges == null || y - 1 == x + 1 || middle >= 0 && (x <= middle && middle < y || x <= middle + 3 && middle + 3 < y)) continue;
                for (int ss : tmp1) {
                    int iY;
                    int iX;
                    int s = Service.Y(ss);
                    if (s == this.body || s == this.fml_part || s == this.plain_subquery || s == this.dotdotstmtdotdot && x > 1 && PlsqlCYK.containsEither((int[])matrix.get(Service.pair(x - 1, x)), new int[]{this.semicolonSymbol, this.beginSymbol}) || s == this.dotdot_basic_decl_item_dotdot && x > 1 && PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(x - 1, x)), this.semicolonSymbol) && !PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(x, x + 1)), this.beginSymbol) || s == this.query_term && x > 1 && (PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(x - 1, x)), this.set_operator) || PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(x - 2, x - 1)), this.set_operator) && PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(x - 1, x)), this.allSymbol)) && y < to - 1 && PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(y, y + 1)), this.set_operator) || s == this.termdotdotbinary_add_op__termdotdot && x > 1 && (PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(x - 1, x)), this.binary_add_op) || PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(x - 2, x - 1)), this.verticalStrokeSymbol) && PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(x - 1, x)), this.verticalStrokeSymbol)) && y < to - 2 && (PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(y, y + 1)), this.binary_add_op) || PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(y, y + 1)), this.verticalStrokeSymbol) && PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(y + 1, y + 2)), this.verticalStrokeSymbol)) || s == this.expr && x > 0 && PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(x - 1, x)), this.orSymbol) && PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(y, y + 1)), this.orSymbol) || s == this.procedure_call && !this.containsKwd((int[])matrix.get(Service.pair(x, x + 1))) || s == this.dotdotAND__reldotdot && x > 0 && PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(x - 1, x)), this.andSymbol) && PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(y, y + 1)), this.andSymbol)) {
                        int X = x;
                        int Y = y - 1;
                        skipRanges.put(Y, X);
                        if (Visual.skipped == null) continue block1;
                        if (Visual.causes.get(Service.pair(Y, X)) != null) {
                            throw new AssertionError((Object)"Visual.causes.get(Service.pair(Y,X))!=null");
                        }
                        Visual.causes.put(Service.pair(Y, X), s);
                        continue block1;
                    }
                    if (y < x + 6 || (s != this.dotdot_dotprm_specdotdot || y >= to - 1 || !PlsqlCYK.containsSymbol((int[])matrix.get(Service.pair(y, y + 1)), this.commaSymbol)) && s != this.dotdotdotsim_expr_dotiddotdotdot && s != this.dotdotdotcmpon_ascdotdot || (iX = PlsqlCYK.splitInterval(matrix, x, y, s, true)) == -1 || (iY = PlsqlCYK.splitInterval(matrix, iX, y, s, false)) == -1) continue;
                    if (iY <= iX) {
                        throw new AssertionError((Object)"iY <= iX");
                    }
                    int X = this.next(iX, skipRanges);
                    int Y = iY - 1;
                    skipRanges.put(Y, X);
                    if (Visual.skipped == null) continue block1;
                    Visual.causes.put(Service.pair(Y, X), s);
                    if (s != (Integer)this.symbolIndexes.get("..basic_decl_item..")) continue block1;
                    continue block1;
                }
            }
        }
    }

    public int getSymbol(String string) {
        try {
            return (Integer)this.symbolIndexes.get(string);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    static {
        PlsqlCYK.init();
        debug = true;
    }
}

