/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Scrollable;
import javax.swing.text.html.HTMLEditorKit;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.util.Service;

public class Visual
implements ActionListener {
    public static int[][] skipped = null;
    List<LexerToken> src;
    CYK cyk;
    private int zoom = 1;
    private int offset = 0;
    public static Map<Integer, Integer> causes;
    int X;
    int Y;
    BufferedImage img;
    Matrix matrix;
    JLabel matrixImage = null;
    private JRadioButton yes = new JRadioButton("Yes");
    private JRadioButton no = new JRadioButton("No");

    public Visual(List<LexerToken> s, CYK c) {
        causes = new HashMap<Integer, Integer>();
        this.src = s;
        skipped = new int[this.src.size() + 1][this.src.size() + 1];
        this.cyk = c;
        this.zoom = 1 + 550 / this.src.size();
        this.offset = this.zoom / 2;
        if (this.zoom == 1) {
            this.offset = 0;
        }
        int size = this.src.size();
        this.X = (size + 1) * this.zoom;
        this.Y = (size + 1) * this.zoom;
    }

    public void draw(Matrix m) {
        this.img = this.drawMatrix(m);
        JFrame frame = new JFrame("CYK Matrix");
        frame.setDefaultCloseOperation(3);
        final JEditorPane t = new JEditorPane();
        t.setEditorKit(new HTMLEditorKit());
        JScrollPane editorScrollPane = new JScrollPane(t);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setPreferredSize(new Dimension(10, 300));
        editorScrollPane.setMinimumSize(new Dimension(10, 50));
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 0));
        ButtonGroup optimGroup = new ButtonGroup();
        optimGroup.add(this.yes);
        optimGroup.add(this.no);
        radioPanel.add(new JLabel("Optimization: "));
        radioPanel.add(this.yes);
        radioPanel.add(this.no);
        this.yes.addActionListener(this);
        this.no.addActionListener(this);
        JPanel matrixPanel = new JPanel(new BorderLayout());
        class ScrollablePicture
        extends JLabel
        implements Scrollable,
        MouseMotionListener,
        MouseWheelListener {
            int x0;
            int y0;
            int[] output;
            int index;

            public ScrollablePicture() {
                super(new Icon(){

                    @Override
                    public int getIconHeight() {
                        return Visual.this.Y;
                    }

                    @Override
                    public int getIconWidth() {
                        return Visual.this.X;
                    }

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        g.drawImage(Visual.this.img, 0, 0, Color.orange, null);
                        Visual.this.drawSrcText(g);
                    }
                });
                this.x0 = -1;
                this.y0 = -1;
                this.output = null;
                this.index = 0;
                this.setAutoscrolls(true);
                this.addMouseMotionListener(this);
                this.addMouseWheelListener(this);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Rectangle r = new Rectangle(e.getX(), e.getY(), 10, 10);
                this.scrollRectToVisible(r);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                e.consume();
                int x = e.getX() / Visual.this.zoom;
                int y = e.getY() / Visual.this.zoom;
                if (x > Visual.this.src.size()) {
                    return;
                }
                if (y > Visual.this.src.size()) {
                    return;
                }
                if (x != this.x0 || y != this.y0) {
                    this.index = 0;
                }
                this.output = (int[])Visual.this.matrix.get(Service.pair(x, y));
                if (this.output != null) {
                    this.x0 = x;
                    this.y0 = y;
                    this.updatePane(t);
                    this.repaint();
                } else if (this.x0 != -1) {
                    this.repaint();
                    this.x0 = -1;
                    this.y0 = -1;
                }
                String tooltip = "[" + x + "," + y + ")";
                if (0 < skipped[x][y]) {
                    tooltip = tooltip + "  " + Visual.this.cyk.allSymbols[skipped[x][y]];
                }
                this.setToolTipText(tooltip);
            }

            private void updatePane(JEditorPane t2) {
                HashMap<Integer, Integer> symbols = new HashMap<Integer, Integer>();
                for (int kk : this.output) {
                    int k = Service.Y(kk);
                    Integer val = (Integer)symbols.get(k);
                    if (val == null) {
                        symbols.put(k, 1);
                        continue;
                    }
                    symbols.put(k, val + 1);
                }
                StringBuffer sb = new StringBuffer("<html><font color=red>[" + this.x0 + "," + this.y0 + ")</font><br>");
                Iterator i$ = symbols.keySet().iterator();
                while (i$.hasNext()) {
                    int k = (Integer)i$.next();
                    if (k == -1) {
                        sb.append("<font color=red>-1</font>");
                        continue;
                    }
                    int derivedSymbol = Service.Y(this.output[this.index]);
                    String symbol = Visual.this.cyk.allSymbols[k];
                    if (k == derivedSymbol && this.x0 + 1 < this.y0) {
                        int mid = Service.X(this.output[this.index]);
                        int[] prefixes = (int[])Visual.this.matrix.get(Service.pair(this.x0, mid));
                        int[] suffixes = (int[])Visual.this.matrix.get(Service.pair(mid, this.y0));
                        String ruleBody = "?";
                        block2: for (int II : prefixes) {
                            int I = Service.Y(II);
                            for (int JJ : suffixes) {
                                int J = Service.Y(JJ);
                                Set<Integer> A = Visual.this.cyk.doubleRhsRules.get(Service.pair(I, J));
                                if (A == null) continue;
                                for (int a : A) {
                                    if (a != k) continue;
                                    ruleBody = "<font size=+1 bgcolor=rgb(150,200,150))>" + Visual.this.cyk.allSymbols[I] + "</font>" + "<font size=+1 color=green>+</font>" + "<font size=+1 bgcolor=rgb(150,150,200))>" + Visual.this.cyk.allSymbols[J] + "</font>";
                                    break block2;
                                }
                            }
                        }
                        symbol = "<font size=+1 bgcolor=rgb(200,150,150))>" + symbol + "</font>" + "<font size=+1 color=green>=</font>" + ruleBody;
                    } else if (symbol.indexOf(91) < 0 && symbol.indexOf(43) < 0 && symbol.indexOf(46) < 0) {
                        symbol = "<b>" + symbol + "</b>";
                    }
                    sb.append("  " + symbol);
                }
                sb.append("<font color=green><br><br>");
                for (int i = this.x0; i < this.y0; ++i) {
                    sb.append(" " + Visual.this.src.get((int)i).content);
                }
                t2.setText(sb.toString());
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return null;
            }

            @Override
            public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
                return 0;
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return false;
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }

            @Override
            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                return 0;
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (this.x0 != -1 && this.x0 + 1 < this.y0) {
                    g.setColor(Color.red);
                    int mid = Service.X(this.output[this.index]);
                    g.drawLine(this.x0 * Visual.this.zoom + Visual.this.offset, mid * Visual.this.zoom + Visual.this.offset, this.x0 * Visual.this.zoom + Visual.this.offset, this.y0 * Visual.this.zoom + Visual.this.offset);
                    g.drawLine(this.x0 * Visual.this.zoom + Visual.this.offset, this.y0 * Visual.this.zoom + Visual.this.offset, mid * Visual.this.zoom + Visual.this.offset, this.y0 * Visual.this.zoom + Visual.this.offset);
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (this.output == null) {
                    return;
                }
                this.index += e.getWheelRotation();
                if (this.index < 0) {
                    this.index = this.output.length - this.index;
                } else if (this.index >= this.output.length) {
                    this.index = 0;
                }
                this.repaint();
                this.updatePane(t);
            }
        }
        this.matrixImage = new ScrollablePicture();
        matrixPanel.add((Component)this.matrixImage, "Center");
        matrixPanel.add((Component)radioPanel, "South");
        JScrollPane canvasScrollPane = new JScrollPane(matrixPanel);
        canvasScrollPane.setVerticalScrollBarPolicy(20);
        canvasScrollPane.setHorizontalScrollBarPolicy(30);
        canvasScrollPane.setPreferredSize(new Dimension(600, 600));
        canvasScrollPane.setMinimumSize(new Dimension(100, 100));
        JSplitPane sp = new JSplitPane(0);
        sp.add(canvasScrollPane);
        sp.add(editorScrollPane);
        frame.getContentPane().add(sp);
        frame.pack();
        frame.setVisible(true);
    }

    private BufferedImage drawMatrix(Matrix matrix) {
        this.matrix = matrix;
        byte[] pixels = new byte[this.X * this.Y];
        for (int j = 0; j < this.Y; ++j) {
            for (int i = 0; i < this.X; ++i) {
                int z = j * this.X + i;
                int[] tmp = (int[])matrix.get(Service.pair(i / this.zoom, j / this.zoom));
                pixels[z] = tmp != null ? 0 : (0 < skipped[i / this.zoom][j / this.zoom] || j <= i ? 1 : 4);
            }
        }
        DataBufferByte dbuf = new DataBufferByte(pixels, this.X * this.Y, 0);
        int numBanks = dbuf.getNumBanks();
        int[] bitMasks = new int[]{15};
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(0, this.X, this.Y, bitMasks);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dbuf, null);
        ColorModel colorModel = Visual.generateColorModel();
        BufferedImage img = new BufferedImage(colorModel, raster, false, null);
        return img;
    }

    private void drawSrcText(Graphics g) {
        if (this.zoom < 5) {
            return;
        }
        int pos = -1;
        for (LexerToken t : this.src) {
            g.setColor(Color.WHITE);
            g.drawString(t.content, ++pos * this.zoom + 2 * this.zoom / 3, (pos + 1) * this.zoom + 2 * this.zoom / 3);
        }
    }

    private static ColorModel generateColorModel() {
        byte[] r = new byte[16];
        byte[] g = new byte[16];
        byte[] b = new byte[16];
        r[0] = 0;
        g[0] = 0;
        b[0] = 0;
        r[1] = 0;
        g[1] = 0;
        b[1] = -64;
        r[2] = 0;
        g[2] = 0;
        b[2] = -1;
        r[3] = 0;
        g[3] = -64;
        b[3] = 0;
        r[4] = 0;
        g[4] = -1;
        b[4] = 0;
        r[5] = 0;
        g[5] = -64;
        b[5] = -64;
        r[6] = 0;
        g[6] = -1;
        b[6] = -1;
        r[7] = -64;
        g[7] = 0;
        b[7] = 0;
        r[8] = -1;
        g[8] = 0;
        b[8] = 0;
        r[9] = -64;
        g[9] = 0;
        b[9] = -64;
        r[10] = -1;
        g[10] = 0;
        b[10] = -1;
        r[11] = -64;
        g[11] = -64;
        b[11] = 0;
        r[12] = -1;
        g[12] = -1;
        b[12] = 0;
        r[13] = 80;
        g[13] = 80;
        b[13] = 80;
        r[14] = -64;
        g[14] = -64;
        b[14] = -64;
        r[15] = -1;
        g[15] = -1;
        b[15] = -1;
        return new IndexColorModel(4, 16, r, g, b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.recalculate(e.getSource() == this.yes);
    }

    public void recalculate(boolean optim) {
        skipped = new int[this.src.size() + 1][this.src.size() + 1];
        causes = new HashMap<Integer, Integer>();
        Matrix matrix = this.cyk.initArray(this.src);
        int size = matrix.size();
        TreeMap<Integer, Integer> skipRanges = null;
        if (optim) {
            skipRanges = new TreeMap<Integer, Integer>();
        }
        this.cyk.closure(matrix, 0, size + 1, skipRanges, -1);
        this.img = this.drawMatrix(matrix);
        this.matrixImage.repaint();
    }
}

