/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Set;

public class RuleTuple
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    public String head;
    public String[] rhs;

    public RuleTuple(String h, List<String> r) {
        this.head = h;
        this.rhs = new String[r.size()];
        int i = 0;
        for (String t : r) {
            this.rhs[i++] = t;
        }
    }

    public RuleTuple(String h, String[] r) {
        this.head = h;
        this.rhs = r;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        throw new RuntimeException("hashCode inconsistent with equals");
    }

    public int compareTo(Object obj) {
        int cmp;
        RuleTuple src = (RuleTuple)obj;
        int n = cmp = this.head == null ? 0 : this.head.compareTo(src.head);
        if (cmp != 0) {
            return cmp;
        }
        if (this.rhs.length != src.rhs.length) {
            return this.rhs.length - src.rhs.length;
        }
        for (int i = 0; i < this.rhs.length; ++i) {
            if (this.rhs[i].compareTo(src.rhs[i]) == 0) continue;
            return this.rhs[i].compareTo(src.rhs[i]);
        }
        return 0;
    }

    public boolean ignore(String keyword, String bra, String ket) {
        boolean enteredBrackets = false;
        for (String token : this.rhs) {
            if (token.equals(bra)) {
                enteredBrackets = true;
            }
            if (enteredBrackets && token.equals(keyword)) {
                return true;
            }
            if (!token.equals(ket)) continue;
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.head != null) {
            b.append(this.head + ":");
        }
        for (String t : this.rhs) {
            b.append(" " + t);
        }
        return b.toString();
    }

    public static void printRules(Set<RuleTuple> rules) {
        RuleTuple predecessor = null;
        for (RuleTuple rule : rules) {
            System.out.println(rule.toHTML(predecessor));
            predecessor = rule;
        }
    }

    public String toHTML(RuleTuple predecessor) {
        StringBuffer b = new StringBuffer();
        if (predecessor == null || !predecessor.head.equals(this.head)) {
            b.append(this.head + ":" + RuleTuple.identln(12 - this.head.length() - 2, " "));
        } else {
            b.append(RuleTuple.identln(10, "| "));
        }
        for (String t : this.rhs) {
            if (t.startsWith("'")) {
                b.append(" \"" + t.substring(1, t.length() - 1) + "\"");
                continue;
            }
            b.append(" " + t);
        }
        return b.toString();
    }

    public static String identln(int level, String txt) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            b.append(" ");
        }
        b.append(txt);
        return b.toString();
    }

    public static void memorizeRules(Set<RuleTuple> rules, String location) throws Exception {
        FileOutputStream fos = new FileOutputStream(location);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(rules);
        out.close();
    }

    public static Set<RuleTuple> getRules(URL u) throws Exception {
        InputStream is = u.openStream();
        ObjectInputStream in = new ObjectInputStream(is);
        Set rules = (Set)in.readObject();
        in.close();
        return rules;
    }
}

