/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.util.Service;

public class ParseNode
implements Comparable {
    public int from;
    public int to;
    ParseNode lft = null;
    ParseNode rgt = null;
    private int payloadIn;
    int payloadOut;
    public Set<ParseNode> topLevel = null;
    private CYK cyk;

    public int compareTo(Object obj) {
        ParseNode src = (ParseNode)obj;
        if (this.from != src.from) {
            return this.from - src.from;
        }
        return this.to - src.to;
    }

    public String toString() {
        return this.toString(0);
    }

    public List<ParseNode> descendants() {
        ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
        ret.add(this);
        for (ParseNode n : this.children()) {
            ret.addAll(n.descendants());
        }
        return ret;
    }

    public List<ParseNode> ancestors(int pos) {
        return this.intermediates(pos, pos + 1);
    }

    public List<ParseNode> intermediates(int head, int tail) {
        ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
        if (this.from <= head && tail <= this.to) {
            ret.add(this);
        }
        for (ParseNode n : this.children()) {
            if (n.from > head || tail > n.to) continue;
            ret.addAll(n.intermediates(head, tail));
        }
        return ret;
    }

    public ParseNode ancestor(int head, int tail, int content) {
        ParseNode parent = this.parent(head, tail);
        if (parent == this) {
            return null;
        }
        if (parent.contains(content)) {
            return parent;
        }
        return this.ancestor(parent.from, parent.to, content);
    }

    public ParseNode descendant(int head, int tail, int content) {
        for (ParseNode child : this.children()) {
            if (child.from > head || tail > child.to) continue;
            if (child.contains(content)) {
                return child;
            }
            return child.descendant(head, tail, content);
        }
        return null;
    }

    public ParseNode parent(int head, int tail) {
        for (ParseNode descendant : this.intermediates(head, tail)) {
            for (ParseNode child : descendant.children()) {
                if (child.from != head || child.to != tail) continue;
                return descendant;
            }
        }
        return null;
    }

    void print(int depth) {
        System.out.println(this.toString(depth));
    }

    public ParseNode leafAtPos(int pos) {
        if (this.children().size() == 0 && pos == this.from) {
            return this;
        }
        for (ParseNode child : this.children()) {
            if (child.from > pos || pos >= child.to) continue;
            return child.leafAtPos(pos);
        }
        return null;
    }

    private void calculateDepth(Map<Integer, Integer> depthMap, int depth) {
        depthMap.put(Service.pair(this.from, this.to), depth);
        for (ParseNode child : this.children()) {
            child.calculateDepth(depthMap, depth + 1);
        }
    }

    Map<Integer, Integer> calculateDepth() {
        TreeMap<Integer, Integer> depthMap = new TreeMap<Integer, Integer>();
        this.calculateDepth(depthMap, 0);
        return depthMap;
    }

    public void printTree() {
        Map<Integer, Integer> depthMap = this.calculateDepth();
        int i = 0;
        for (ParseNode n : this.descendants()) {
            if (i++ > 500) {
                return;
            }
            int depth = depthMap.get(Service.pair(n.from, n.to));
            n.print(depth);
        }
    }

    public void printBinaryTree(int depth) {
        this.print(depth);
        if (this.lft != null) {
            this.lft.printBinaryTree(depth + 1);
        }
        if (this.rgt != null) {
            this.rgt.printBinaryTree(depth + 1);
        }
        if (this.topLevel != null) {
            for (ParseNode n : this.topLevel) {
                n.printBinaryTree(depth + 1);
            }
        }
    }

    public String content(List<LexerToken> src) {
        StringBuffer sb = new StringBuffer();
        for (int i = this.from; i < this.to; ++i) {
            sb.append(src.get((int)i).content);
        }
        return sb.toString();
    }

    public Set<Integer> content() {
        if (this.payloadIn == -1 && this.payloadOut == -1) {
            return new TreeSet<Integer>();
        }
        if (this.payloadIn == -1 && this.payloadOut != -1) {
            TreeSet<Integer> ret = new TreeSet<Integer>();
            ret.add(this.payloadOut);
            return ret;
        }
        if (this.payloadIn != -1 && this.payloadOut == -1) {
            TreeSet<Integer> ret = new TreeSet<Integer>();
            ret.addAll(this.cyk.singleRhsRules[this.payloadIn]);
            return ret;
        }
        TreeSet<Integer> ret = new TreeSet<Integer>();
        for (int candidate : this.cyk.singleRhsRules[this.payloadIn]) {
            if (!this.cyk.singleRhsRules[candidate].contains(this.payloadOut)) continue;
            ret.add(candidate);
        }
        return ret;
    }

    public boolean contains(int symbol) {
        return this.content().contains(symbol);
    }

    public void addTopLevel(ParseNode child) {
        if (this.topLevel == null) {
            this.topLevel = new TreeSet<ParseNode>();
        }
        this.topLevel.add(child);
    }

    public ParseNode(int begin, int end, int sIn, int sOut, CYK c) {
        this.from = begin;
        this.to = end;
        this.payloadIn = sIn;
        this.payloadOut = sOut;
        this.cyk = c;
    }

    protected String toString(int depth) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append("[" + this.from + "," + this.to + ") ");
        for (Integer i : this.content()) {
            sb.append("  " + this.cyk.allSymbols[i]);
        }
        return sb.toString();
    }

    public boolean isAuxiliary() {
        boolean noneAux = true;
        for (Integer symbol : this.content()) {
            String symb = this.cyk.allSymbols[symbol];
            if (symb.indexOf("+") >= 0 && !"'+'".equals(symb)) continue;
            noneAux = false;
            break;
        }
        return noneAux;
    }

    public Set<ParseNode> children() {
        TreeSet<ParseNode> ret = new TreeSet<ParseNode>();
        if (this.topLevel != null) {
            for (ParseNode child : this.topLevel) {
                if (child.isAuxiliary()) {
                    ret.addAll(child.children());
                    continue;
                }
                ret.add(child);
            }
            return ret;
        }
        if (this.lft == null) {
            return ret;
        }
        if (this.lft.isAuxiliary()) {
            ret.addAll(this.lft.children());
        } else {
            ret.add(this.lft);
        }
        if (this.rgt == null) {
            return ret;
        }
        if (this.rgt.isAuxiliary()) {
            ret.addAll(this.rgt.children());
        } else {
            ret.add(this.rgt);
        }
        return ret;
    }

    public void moveInterval(int offset) {
        this.from += offset;
        this.to += offset;
        if (this.topLevel != null) {
            for (ParseNode p : this.topLevel) {
                p.moveInterval(offset);
            }
        } else {
            if (this.lft != null) {
                this.lft.moveInterval(offset);
            }
            if (this.rgt != null) {
                this.rgt.moveInterval(offset);
            }
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

