/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.Iterator;
import java.util.TreeMap;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.util.Service;

public class Matrix
extends TreeMap<Integer, int[]> {
    private CYK cyk;

    public Matrix(CYK cyk) {
        this.cyk = cyk;
    }

    public boolean contains(int x, int y, int symbol) {
        int[] js = (int[])this.get(Service.pair(x, y));
        if (js == null) {
            return false;
        }
        for (int ii : js) {
            if (Service.Y(ii) != symbol) continue;
            return true;
        }
        return false;
    }

    public int getSymbol(int interval, int index) {
        int[] tmp = (int[])this.get(interval);
        if (tmp == null) {
            return -1;
        }
        return Service.Y(tmp[index]);
    }

    public int getIntervalMiddle(int interval, int index) {
        int[] tmp = (int[])this.get(interval);
        if (tmp == null) {
            return -1;
        }
        return Service.X(tmp[index]);
    }

    @Override
    public String toString() throws RuntimeException {
        StringBuffer ret = new StringBuffer();
        Iterator i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            int xy = (Integer)i$.next();
            int i = Service.X(xy);
            int j = Service.Y(xy);
            ret.append("[" + i + "," + j + ")");
            int[] output = (int[])this.get(Service.pair(i, j));
            if (output == null) {
                throw new RuntimeException("no value corresponding to the key [" + i + "," + j + ")");
            }
            int k = 0;
            for (int s : output) {
                if (k < 5) {
                    ret.append("  " + this.cyk.allSymbols[Service.Y(s)]);
                } else if (k == 5) {
                    ret.append(" ...");
                }
                ++k;
            }
            ret.append('\n');
        }
        return ret.toString();
    }
}

