/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.util.Service;

public class CYK {
    public ChomskiTuple[] rules;
    public Set<Integer>[] singleRhsRules;
    public HashMap<Integer, Set<Integer>> doubleRhsRules;
    public String[] allSymbols;
    public Map<String, Integer> symbolIndexes;
    Set<Integer> keywords = new TreeSet<Integer>();

    public CYK(Set<RuleTuple> originalRules) {
        this.rules = this.getChomskyRules(originalRules);
        this.singleRhsRules = this.filterSingleRhsRules();
        this.doubleRhsRules = this.filterDoubleRhsRules();
    }

    public void printSelectedChomskiRules(String name) {
        System.out.println("-------------Chomsky Rules---------------");
        for (ChomskiTuple rule : this.rules) {
            if (!this.allSymbols[rule.head].contains(name) && !this.allSymbols[rule.rhs0].contains(name) && (rule.rhs1 <= 0 || !this.allSymbols[rule.rhs1].contains(name))) continue;
            System.out.println(rule.toString());
        }
        System.out.println("-------------------------------------");
    }

    public void printIds() {
        System.out.println("-------------Id Rules---------------");
        for (ChomskiTuple rule : this.rules) {
            for (int i : this.singleRhsRules[this.symbolIndexes.get("digits")]) {
                if (rule.head != i) continue;
                System.out.println(rule.toString());
            }
        }
        System.out.println("-------------------------------------");
    }

    public Matrix initArray(List<LexerToken> input) {
        Matrix ret = new Matrix(this);
        int i = 0;
        for (LexerToken token : input) {
            this.initArrayElement(ret, i, token, false);
            ++i;
        }
        return ret;
    }

    public Matrix initArray1(List<LexerToken> input) {
        Matrix ret = new Matrix(this);
        int i = 0;
        for (LexerToken token : input) {
            this.initArrayElement(ret, i, token, true);
            ++i;
        }
        return ret;
    }

    public void initArrayElement(Matrix ret, int pos, LexerToken token, boolean identifiersOnly) {
        int symbol;
        Integer suspect = this.symbolIndexes.get("'" + token.content + "'");
        TreeSet<Integer> dependents = new TreeSet<Integer>();
        if (suspect != null) {
            dependents.addAll(this.singleRhsRules[suspect]);
        }
        if (token.type == Token.IDENTIFIER) {
            if (!identifiersOnly || suspect == null || !this.keywords.contains(suspect)) {
                symbol = this.symbolIndexes.get("identifier");
                dependents.addAll(this.singleRhsRules[symbol]);
            }
        } else if (token.type == Token.DQUOTED_STRING || token.type == Token.QUOTED_STRING) {
            symbol = this.symbolIndexes.get("string_literal");
            dependents.addAll(this.singleRhsRules[symbol]);
        } else if (token.type == Token.DIGITS) {
            symbol = this.symbolIndexes.get("digits");
            dependents.addAll(this.singleRhsRules[symbol]);
        }
        int[] tmp = new int[dependents.size()];
        int i = 0;
        Iterator i$ = dependents.iterator();
        while (i$.hasNext()) {
            int e = (Integer)i$.next();
            tmp[i++] = Service.pair(pos, e);
        }
        ret.put(Service.pair(pos, pos + 1), tmp);
    }

    public void initArrayElement(SortedMap<Integer, Set<Integer>> ret, int pos, int symbol) {
        TreeSet<Integer> dependents = new TreeSet<Integer>();
        dependents.addAll(this.singleRhsRules[symbol]);
        ret.put(Service.pair(pos, pos + 1), dependents);
    }

    public int[] atomicSymbols() {
        return new int[0];
    }

    public Map<Integer, Integer> delimitedSymbols() {
        return new HashMap<Integer, Integer>();
    }

    public int[] commaAggrSymbols() {
        return new int[0];
    }

    public void closure(Matrix matrix, int from, int to, Map<Integer, Integer> skipRanges, int middle) {
        int[] atomicSymbols = this.atomicSymbols();
        Map<Integer, Integer> delimitedSymbols = this.delimitedSymbols();
        for (int y = 1; y < to; ++y) {
            block1: for (int x = y - 2; x >= from; --x) {
                Integer nextX;
                if (skipRanges != null && (nextX = skipRanges.get(x)) != null) {
                    if (Visual.skipped != null) {
                        for (int i = x; i > nextX; --i) {
                            Visual.skipped[i][y] = Visual.causes.get(Service.pair(x, nextX));
                        }
                    }
                    x = nextX + 1;
                    continue;
                }
                int start = Service.pair(x, y);
                int end = Service.pair(0, y + 1);
                TreeSet tmp = new TreeSet();
                SortedMap range = matrix.subMap(start, end);
                for (int key : range.keySet()) {
                    int[] suffixes;
                    int mid = Service.X(key);
                    int[] prefixes = (int[])matrix.get(Service.pair(x, mid));
                    if (prefixes == null || (suffixes = (int[])matrix.get(Service.pair(mid, y))) == null) continue;
                    for (int II : prefixes) {
                        for (int JJ : suffixes) {
                            int J;
                            int I = Service.Y(II);
                            Set<Integer> A = this.doubleRhsRules.get(Service.pair(I, J = Service.Y(JJ)));
                            if (A == null) continue;
                            LinkedList<Integer> B = new LinkedList<Integer>();
                            for (int a : A) {
                                B.add(Service.pair(mid, a));
                            }
                            tmp.addAll(B);
                        }
                    }
                }
                if (tmp.size() <= 0) continue;
                int[] tmp1 = new int[tmp.size()];
                int i = 0;
                Iterator i$ = tmp.iterator();
                while (i$.hasNext()) {
                    int e = (Integer)i$.next();
                    tmp1[i++] = e;
                }
                matrix.put(Service.pair(x, y), tmp1);
                if (skipRanges == null || atomicSymbols.length <= 0 && delimitedSymbols.size() <= 0 || y - 1 == x + 1 || x <= middle && middle < y) continue;
                block8: for (int ss : tmp1) {
                    int Y;
                    int X;
                    int s = Service.Y(ss);
                    for (int skipRangeSymbol : atomicSymbols) {
                        if (s != skipRangeSymbol) continue;
                        X = x;
                        Y = y - 1;
                        skipRanges.put(Y, X);
                        if (Visual.skipped == null) continue block1;
                        if (Visual.causes.get(Service.pair(Y, X)) != null) {
                            throw new AssertionError((Object)"Visual.causes.get(Service.pair(Y,X))!=null");
                        }
                        Visual.causes.put(Service.pair(Y, X), s);
                        continue block1;
                    }
                    for (int delimitedSymbol : delimitedSymbols.keySet()) {
                        int iY;
                        int iX;
                        if (s != delimitedSymbol || (iX = CYK.splitInterval(matrix, x, y, delimitedSymbol, delimitedSymbols.get(s), true)) == -1 || (iY = CYK.splitInterval(matrix, iX + 1, y, delimitedSymbol, delimitedSymbols.get(s), false)) == -1 || (Y = iY - 1) <= (X = iX + 1)) continue;
                        skipRanges.put(Y, X);
                        if (Visual.skipped == null) continue block8;
                        Visual.causes.put(Service.pair(Y, X), s);
                        continue block8;
                    }
                }
            }
        }
    }

    protected int next(int i, Map<Integer, Integer> skipRanges) {
        Integer ret = skipRanges.get(i - 1);
        if (ret == null) {
            return i;
        }
        return this.next(ret, skipRanges);
    }

    public void recalculateRectangle(Matrix matrix, Map<Integer, Integer> skipRanges, int len, int posX, int posY) {
        if (skipRanges != null) {
            Set<Integer> keys = skipRanges.keySet();
            Integer[] dummy = new Integer[keys.size()];
            for (Integer key : keys.toArray(dummy)) {
                if (posY >= key) continue;
                Integer value = skipRanges.get(key);
                skipRanges.remove(key);
                skipRanges.put(key - posY + posX, value - posY + posX);
            }
        }
        for (int y = posY; y < len; ++y) {
            for (int x = posX; x >= 0; --x) {
                Integer nextX;
                if (y == x + 1) continue;
                matrix.remove(Service.pair(x, y));
                if (skipRanges != null && (nextX = skipRanges.get(x)) != null) {
                    x = nextX + 1;
                    continue;
                }
                int start = Service.pair(x, y);
                int end = Service.pair(0, y + 1);
                TreeSet tmp = new TreeSet();
                SortedMap range = matrix.subMap(start, end);
                for (int key : range.keySet()) {
                    int[] suffixes;
                    int mid = Service.X(key);
                    int[] prefixes = (int[])matrix.get(Service.pair(x, mid));
                    if (prefixes == null || (suffixes = (int[])matrix.get(Service.pair(mid, y))) == null) continue;
                    for (int II : prefixes) {
                        for (int JJ : suffixes) {
                            int J;
                            int I = Service.Y(II);
                            Set<Integer> A = this.doubleRhsRules.get(Service.pair(I, J = Service.Y(JJ)));
                            if (A == null) continue;
                            LinkedList<Integer> B = new LinkedList<Integer>();
                            for (int a : A) {
                                B.add(Service.pair(mid, a));
                            }
                            tmp.addAll(B);
                        }
                    }
                }
                if (tmp.size() <= 0) continue;
                int[] tmp1 = new int[tmp.size()];
                int i = 0;
                Iterator i$ = tmp.iterator();
                while (i$.hasNext()) {
                    int e = (Integer)i$.next();
                    tmp1[i++] = e;
                }
                matrix.put(Service.pair(x, y), tmp1);
            }
        }
    }

    public void print(Matrix P) {
        Iterator i$ = P.keySet().iterator();
        while (i$.hasNext()) {
            int xy = (Integer)i$.next();
            int i = Service.X(xy);
            int j = Service.Y(xy);
            this.print(P, i, j);
        }
    }

    public void print(Matrix P, int i, int j) {
        System.out.print("[" + i + "," + j + ")");
        int[] output = (int[])P.get(Service.pair(i, j));
        if (output == null) {
            System.out.println("- syntactically invalid code fragment");
            return;
        }
        for (int kk : output) {
            int k = Service.Y(kk);
            if (k == -1) {
                System.out.print("''");
                continue;
            }
            System.out.print("  " + this.allSymbols[k]);
        }
        System.out.println();
    }

    Set<Integer>[] filterSingleRhsRules() {
        TreeMap<Integer, Set> tmp = new TreeMap<Integer, Set>();
        for (int i = 0; i < this.allSymbols.length; ++i) {
            TreeSet<Integer> ii = new TreeSet<Integer>();
            ii.add(i);
            tmp.put(i, ii);
        }
        for (ChomskiTuple rule : this.rules) {
            if (rule.rhs1 != -1) continue;
            Set headers = (Set)tmp.get(rule.rhs0);
            headers.add(rule.head);
            tmp.put(rule.rhs0, headers);
        }
        boolean grown = true;
        TreeMap incrementedRet = new TreeMap();
        while (grown) {
            grown = false;
            Iterator i$ = tmp.keySet().iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                TreeSet set = new TreeSet();
                set.addAll((Collection)tmp.get(i));
                Iterator i$2 = ((Set)tmp.get(i)).iterator();
                while (i$2.hasNext()) {
                    int j = (Integer)i$2.next();
                    Set t1 = (Set)tmp.get(j);
                    if (t1 == null) continue;
                    set.addAll(t1);
                }
                if (set.size() > ((Set)tmp.get(i)).size()) {
                    grown = true;
                }
                incrementedRet.put(i, set);
            }
            tmp = incrementedRet;
        }
        Set[] ret = new Set[this.allSymbols.length];
        Iterator i$ = tmp.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            ret[i] = (Set)tmp.get(i);
        }
        return ret;
    }

    HashMap<Integer, Set<Integer>> filterDoubleRhsRules() {
        HashMap<Integer, Set<Integer>> ret = new HashMap<Integer, Set<Integer>>();
        for (ChomskiTuple rule : this.rules) {
            if (rule.rhs1 == -1) continue;
            Set<Integer> headers = ret.get(Service.pair(rule.rhs0, rule.rhs1));
            if (headers == null) {
                headers = new TreeSet<Integer>();
                ret.put(Service.pair(rule.rhs0, rule.rhs1), headers);
            }
            headers.addAll(this.singleRhsRules[rule.head]);
        }
        return ret;
    }

    protected ChomskiTuple[] getChomskyRules(Set<RuleTuple> input) {
        Set<RuleTuple> nonEmptyRules = RuleTransforms.eliminateEmptyProductions(input);
        return this.convertToChomskyRules(nonEmptyRules);
    }

    private ChomskiTuple[] convertToChomskyRules(Set<RuleTuple> rules) {
        Set<RuleTuple> tmp = this.extractBinaryRules(rules);
        ChomskiTuple[] ret = new ChomskiTuple[tmp.size()];
        TreeSet<String> tmpSymbols = new TreeSet<String>();
        int i = 0;
        for (RuleTuple ct : tmp) {
            if (ct.head == null || ct.rhs[0] == null || ct.rhs.length > 1 && ct.rhs[1] == null) {
                throw new RuntimeException("ct has null symbols");
            }
            tmpSymbols.add(ct.head);
            tmpSymbols.add(ct.rhs[0]);
            if (ct.rhs.length > 1) {
                tmpSymbols.add(ct.rhs[1]);
            }
            if (ct.rhs.length <= 2) continue;
            throw new RuntimeException("ct.rhs.length > 2");
        }
        this.allSymbols = new String[tmpSymbols.size() + 1];
        this.symbolIndexes = new TreeMap<String, Integer>();
        int k = 0;
        if (tmpSymbols.contains("exec")) {
            this.symbolIndexes.put("exec", k);
            this.allSymbols[k] = "exec";
            tmpSymbols.remove("exec");
            ++k;
        }
        TreeSet<String> added = new TreeSet<String>();
        for (String s : tmpSymbols) {
            if (s.contains("+") || s.charAt(0) == '.' || s.charAt(s.length() - 1) == ')') continue;
            this.symbolIndexes.put(s, k);
            this.allSymbols[k] = s;
            added.add(s);
            ++k;
        }
        tmpSymbols.removeAll(added);
        added = new TreeSet();
        for (String s : tmpSymbols) {
            if (s.contains("+")) continue;
            this.symbolIndexes.put(s, k);
            this.allSymbols[k] = s;
            added.add(s);
            ++k;
        }
        tmpSymbols.removeAll(added);
        added = new TreeSet();
        for (String s : tmpSymbols) {
            this.symbolIndexes.put(s, k);
            this.allSymbols[k] = s;
            added.add(s);
            ++k;
        }
        tmpSymbols.removeAll(added);
        this.symbolIndexes.put("identifier", k);
        this.allSymbols[k] = "identifier";
        ++k;
        i = 0;
        for (RuleTuple ct : tmp) {
            ret[i++] = new ChomskiTuple(this.symbolIndexes.get(ct.head), this.symbolIndexes.get(ct.rhs[0]), ct.rhs.length > 1 ? this.symbolIndexes.get(ct.rhs[1]) : -1);
        }
        return ret;
    }

    Set<RuleTuple> split(RuleTuple rule) {
        TreeSet<RuleTuple> tmp = new TreeSet<RuleTuple>();
        if (rule.rhs.length == 0) {
            throw new RuntimeException("Empty Rule!");
        }
        if (rule.rhs.length == 1 || rule.rhs.length == 2) {
            tmp.add(rule);
        } else {
            int cut = rule.rhs.length / 2;
            ArrayList<String> rhs = new ArrayList<String>();
            StringBuffer ruleNameL = new StringBuffer();
            for (int i = 0; i < cut; ++i) {
                rhs.add(rule.rhs[i]);
                if (i > 0) {
                    ruleNameL.append('+');
                }
                ruleNameL.append(rule.rhs[i]);
            }
            if (cut > 1) {
                tmp.addAll(this.split(new RuleTuple(ruleNameL.toString(), rhs)));
            }
            rhs = new ArrayList();
            StringBuffer ruleNameR = new StringBuffer();
            for (int i = cut; i < rule.rhs.length; ++i) {
                rhs.add(rule.rhs[i]);
                if (i > cut) {
                    ruleNameR.append('+');
                }
                ruleNameR.append(rule.rhs[i]);
            }
            if (cut < rule.rhs.length) {
                tmp.addAll(this.split(new RuleTuple(ruleNameR.toString(), rhs)));
            }
            tmp.add(new RuleTuple(rule.head, new String[]{ruleNameL.toString(), ruleNameR.toString()}));
        }
        return tmp;
    }

    private Set<RuleTuple> extractBinaryRules(Set<RuleTuple> rules) {
        TreeSet<RuleTuple> tmp = new TreeSet<RuleTuple>();
        for (RuleTuple rule : rules) {
            tmp.addAll(this.split(rule));
        }
        return tmp;
    }

    public ParseNode parseInterval(int begin, int end, int symbolSplit, Matrix backPtr) {
        int symbol = Service.Y(symbolSplit);
        if (begin + 1 == end) {
            return new ParseNode(begin, end, symbol, symbol, this);
        }
        int mid = Service.X(symbolSplit);
        int[] pres = (int[])backPtr.get(Service.pair(begin, mid));
        if (pres == null) {
            return null;
        }
        int[] posts = (int[])backPtr.get(Service.pair(mid, end));
        if (posts == null) {
            return null;
        }
        for (int pre : pres) {
            for (int post : posts) {
                int s2;
                int s1 = Service.Y(pre);
                Set<Integer> A = this.doubleRhsRules.get(Service.pair(s1, s2 = Service.Y(post)));
                if (A == null || !A.contains(symbol)) continue;
                ParseNode ret = null;
                for (ChomskiTuple t : this.rules) {
                    if (t.rhs0 != s1 || t.rhs1 != s2 || !this.singleRhsRules[t.head].contains(symbol)) continue;
                    ret = new ParseNode(begin, end, t.head, -1, this);
                    ret.lft = this.parseInterval(begin, mid, pre, backPtr);
                    if (ret.lft == null) continue;
                    ret.lft.payloadOut = t.rhs0;
                    ret.rgt = this.parseInterval(mid, end, post, backPtr);
                    if (ret.rgt == null) continue;
                    ret.rgt.payloadOut = t.rhs1;
                    return ret;
                }
            }
        }
        return null;
    }

    public ParseNode forest(int len, Matrix backPtr) {
        if (backPtr.get(Service.pair(0, len)) != null) {
            ParseNode ret = null;
            int[] sms = (int[])backPtr.get(Service.pair(0, len));
            TreeSet<Integer> orderedSms = new TreeSet<Integer>();
            for (int i : sms) {
                orderedSms.add(i);
            }
            Iterator i$ = orderedSms.iterator();
            while (i$.hasNext()) {
                int sm = (Integer)i$.next();
                ret = this.parseInterval(0, len, sm, backPtr);
                if (ret == null) continue;
                return ret;
            }
        }
        ArrayList<Integer> cover = new ArrayList<Integer>();
        Iterator i$ = backPtr.keySet().iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            ArrayList<Integer> nodes = new ArrayList<Integer>();
            boolean alreadyCovered = false;
            Iterator i$2 = cover.iterator();
            while (i$2.hasNext()) {
                int n = (Integer)i$2.next();
                if (Service.X(key) <= Service.X(n) && Service.Y(key) > Service.Y(n) || Service.X(key) < Service.X(n) && Service.Y(key) >= Service.Y(n)) {
                    nodes.add(n);
                }
                if ((Service.X(key) < Service.X(n) || Service.Y(key) >= Service.Y(n)) && (Service.X(key) <= Service.X(n) || Service.Y(key) > Service.Y(n))) continue;
                alreadyCovered = true;
                break;
            }
            for (Integer x : nodes) {
                cover.remove(x);
            }
            if (alreadyCovered) continue;
            cover.add(key);
        }
        ParseNode pseudoRoot = new ParseNode(0, len, -1, -1, this);
        block5: for (Integer n : cover) {
            ParseNode ret = null;
            int[] sms = (int[])backPtr.get(n);
            if (sms == null) continue;
            TreeSet<Integer> orderedSms = new TreeSet<Integer>();
            for (int i : sms) {
                orderedSms.add(i);
            }
            Iterator i$3 = orderedSms.iterator();
            while (i$3.hasNext()) {
                int sm = (Integer)i$3.next();
                ret = this.parseInterval(Service.X(n), Service.Y(n), sm, backPtr);
                if (ret == null) continue;
                pseudoRoot.addTopLevel(ret);
                continue block5;
            }
        }
        return pseudoRoot;
    }

    public static int[] toArray(Set<Integer> s) {
        int[] ret = new int[s.size()];
        int i = 0;
        for (int ii : s) {
            ret[i++] = ii;
        }
        return ret;
    }

    protected static int splitInterval(Matrix matrix, int x, int y, int symbol, boolean leftDirection) {
        int i;
        int n = i = leftDirection ? x + 1 : y - 1;
        while (x < i && i < y) {
            int[] tmpIYsymbols;
            int[] tmpIXsymbols = (int[])matrix.get(Service.pair(x, i));
            if (tmpIXsymbols != null && (tmpIYsymbols = (int[])matrix.get(Service.pair(i, y))) != null) {
                for (int tmp : tmpIXsymbols) {
                    if (Service.Y(tmp) != symbol) continue;
                    for (int tmp2 : tmpIYsymbols) {
                        if (Service.Y(tmp2) != symbol) continue;
                        return i;
                    }
                }
            }
            i = leftDirection ? i + 1 : i - 1;
        }
        return -1;
    }

    protected static int splitInterval(Matrix matrix, int x, int y, int symbol, int delimiter, boolean leftDirection) {
        int i;
        int n = i = leftDirection ? x + 1 : y - 1;
        while (x < i && i < y) {
            int[] tmp;
            for (int s : tmp = (int[])matrix.get(Service.pair(i, i + 1))) {
                if (Service.Y(s) != delimiter) continue;
                int[] tmp1 = (int[])matrix.get(Service.pair(x, i));
                if (tmp1 == null) break;
                for (int s1 : tmp1) {
                    if (Service.Y(s1) != symbol) continue;
                    return i;
                }
                break;
            }
            i = leftDirection ? i + 1 : i - 1;
        }
        return -1;
    }

    protected static boolean containsSymbol(int[] cellContent, int symbol) {
        if (cellContent == null) {
            return false;
        }
        for (int sb : cellContent) {
            if (symbol != Service.Y(sb)) continue;
            return true;
        }
        return false;
    }

    protected static boolean containsEither(int[] cellContent, int[] symbols) {
        for (int s : symbols) {
            if (!CYK.containsSymbol(cellContent, s)) continue;
            return true;
        }
        return false;
    }

    public static void printErrors(String axioms, List<LexerToken> src, ParseNode root) {
        int begin = 0;
        int end = axioms.length();
        int iteration = 0;
        for (ParseNode node : root.children()) {
            if (iteration == 0) {
                ++iteration;
                continue;
            }
            if (begin < src.get((int)node.from).begin) {
                begin = src.get((int)node.from).begin;
            }
            if (src.size() <= node.to) {
                end = src.get((int)(src.size() - 1)).end;
            } else if (src.get((int)node.to).end < end) {
                end = src.get((int)node.to).end;
            }
            if (1 > iteration++) continue;
            break;
        }
        System.out.println(axioms.substring(begin, end));
    }

    public class ChomskiTuple
    implements Comparable<ChomskiTuple> {
        public int head;
        public int rhs0;
        public int rhs1;

        public ChomskiTuple(int h, int r0, int r1) {
            this.head = h;
            this.rhs0 = r0;
            this.rhs1 = r1;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ChomskiTuple && this.compareTo((ChomskiTuple)obj) == 0;
        }

        public int hashCode() {
            throw new RuntimeException("hashCode inconssitent with equals");
        }

        @Override
        public int compareTo(ChomskiTuple src) {
            if (this.head == 0 || src.head == 0) {
                throw new RuntimeException("head==0 || src.head==0");
            }
            int cmp = this.head - src.head;
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.rhs0 - src.rhs0;
            if (cmp != 0) {
                return cmp;
            }
            return this.rhs1 - src.rhs1;
        }

        public String toString() {
            if (this.rhs1 == -1) {
                return CYK.this.allSymbols[this.head] + ": " + CYK.this.allSymbols[this.rhs0] + ";";
            }
            return CYK.this.allSymbols[this.head] + ": " + CYK.this.allSymbols[this.rhs0] + "  " + CYK.this.allSymbols[this.rhs1] + ";";
        }
    }
}

