/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;

public class BNFGrammar {
    private static CYK cyk = BNFGrammar.bnfParser();
    static int rule;
    static int grammar;
    static int identifier;
    static int variable;
    static int disjunct;
    static int concat;

    private static CYK bnfParser() {
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        rules.add(new RuleTuple("variable", new String[]{"identifier"}));
        rules.add(new RuleTuple("variable", new String[]{"string_literal"}));
        rules.add(new RuleTuple("concat", new String[]{"variable"}));
        rules.add(new RuleTuple("concat", new String[]{"concat", "variable"}));
        rules.add(new RuleTuple("disjunct", new String[]{"concat"}));
        rules.add(new RuleTuple("disjunct", new String[]{"disjunct", "'|'", "concat"}));
        rules.add(new RuleTuple("rule", new String[]{"identifier", "':'", "disjunct", "';'"}));
        rules.add(new RuleTuple("grammar", new String[]{"rule"}));
        rules.add(new RuleTuple("grammar", new String[]{"grammar", "rule"}));
        cyk = new CYK(rules){

            @Override
            public int[] atomicSymbols() {
                return new int[]{rule};
            }
        };
        rule = BNFGrammar.cyk.symbolIndexes.get("rule");
        grammar = BNFGrammar.cyk.symbolIndexes.get("grammar");
        identifier = BNFGrammar.cyk.symbolIndexes.get("identifier");
        variable = BNFGrammar.cyk.symbolIndexes.get("variable");
        disjunct = BNFGrammar.cyk.symbolIndexes.get("disjunct");
        concat = BNFGrammar.cyk.symbolIndexes.get("concat");
        return cyk;
    }

    public static ParseNode parseGrammarFile(List<LexerToken> src, String input) throws Exception {
        Matrix ret = cyk.initArray1(src);
        int size = ret.size();
        cyk.closure(ret, 0, size + 1, new TreeMap<Integer, Integer>(), -1);
        ParseNode root = cyk.forest(size, ret);
        if (!root.contains(grammar)) {
            CYK.printErrors(input, src, root);
            throw new Exception("Parse error in grammar file");
        }
        return root;
    }

    public static Set<RuleTuple> grammar(ParseNode root, List<LexerToken> src) {
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        if (root.contains(rule)) {
            ret.addAll(BNFGrammar.rule(root, src));
        } else {
            for (ParseNode child : root.children()) {
                ret.addAll(BNFGrammar.grammar(child, src));
            }
        }
        return ret;
    }

    private static Set<RuleTuple> rule(ParseNode node, List<LexerToken> src) {
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        String header = null;
        for (ParseNode child : node.children()) {
            if (child.contains(identifier)) {
                header = child.content(src);
                continue;
            }
            if (!child.contains(disjunct)) continue;
            ret.addAll(BNFGrammar.disjunct(header, child, src));
        }
        return ret;
    }

    private static Set<RuleTuple> disjunct(String header, ParseNode node, List<LexerToken> src) {
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        if (node.contains(concat) || node.contains(disjunct) && node.from + 1 == node.to) {
            ret.add(BNFGrammar.concat(header, node, src));
        } else {
            for (ParseNode child : node.children()) {
                if (child.contains(disjunct)) {
                    ret.addAll(BNFGrammar.disjunct(header, child, src));
                    continue;
                }
                if (!child.contains(concat)) continue;
                ret.add(BNFGrammar.concat(header, child, src));
            }
        }
        return ret;
    }

    private static RuleTuple concat(String header, ParseNode node, List<LexerToken> src) {
        LinkedList<String> payload = new LinkedList<String>();
        for (int i = node.from; i < node.to; ++i) {
            payload.add(src.get((int)i).content);
        }
        return new RuleTuple(header, payload);
    }
}

