/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.java2;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import oracle.jbo.common.JBOClassLoader;

public class JDK2ClassLoader
implements JBOClassLoader {
    public void init() {
    }

    public Class loadClassForName(String className) throws ClassNotFoundException {
        try {
            ClassLoader cl = this.getCurrentClassLoader();
            return Class.forName(className, true, cl);
        }
        catch (SecurityException se) {
            throw new ClassNotFoundException(className, se);
        }
    }

    public InputStream loadResourceAsStream(String name) {
        InputStream in = null;
        ClassLoader cl = this.getCurrentClassLoader();
        in = cl.getResourceAsStream(name);
        if (in == null && name.startsWith("/")) {
            in = cl.getResourceAsStream(name.substring(1));
        }
        return in;
    }

    public ClassLoader getCurrentClassLoader() {
        ClassLoader cl = JDK2ClassLoader.class.getClassLoader();
        return cl == null ? this.getClass().getClassLoader() : cl;
    }

    private static void printClassLoader(ClassLoader cl) {
        JDK2ClassLoader.printClassLoaderTree(cl, 0);
    }

    private static void printClassLoaderTree(ClassLoader cl, int level) {
        if (cl != null) {
            JDK2ClassLoader.indent(level);
            if (cl instanceof URLClassLoader) {
                StringBuffer sb = new StringBuffer("URLS=");
                URL[] urls = ((URLClassLoader)cl).getURLs();
                int j = 0;
                while (j < urls.length) {
                    sb = sb.append(" " + urls[j].toExternalForm());
                    ++j;
                }
                JDK2ClassLoader.indent(level);
            }
            JDK2ClassLoader.printClassLoaderTree(cl.getParent(), ++level);
        }
    }

    private static void indent(int level) {
        int i = 0;
        while (i < level) {
            ++i;
        }
    }
}

