/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.Collections;
import java.util.List;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.provider.ModelProvider;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.dvt.binding.pattern.sparkchart.SparkChartOptions;
import oracle.adfdt.view.dvt.binding.provider.DvtCoreProvider;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.binding.creator.CreatorPresentationManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.DefaultOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsResources;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.SparkChartOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.util.BindingUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.PresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.ISparkChartOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ComponentOptionsPageProvider;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.SparkChartOptionsPageProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SparkChartOptionsMapper
extends DefaultOptionsMapper<SparkChartOptions> {
    private static final String SUBTYPE_AREA = "area";
    private static final String SUBTYPE_BAR = "bar";
    private static final String SUBTYPE_FLOATING_BAR = "floatingBar";
    private static final String SUBTYPE_LINE = "line";
    private ISparkChartOptionsModel _model;
    private List<AttributeDefinition> _attrDefs = Collections.emptyList();

    public SparkChartOptionsMapper(BindOperationType opType, Widget<SparkChartOptions> widget, CreatorParams<SparkChartOptions> params) {
        super(opType, widget, params);
    }

    private AttributeDefinition getAttributeDefinition(String name) {
        for (AttributeDefinition attrDef : this._attrDefs) {
            if (!attrDef.getName().equals(name)) continue;
            return attrDef;
        }
        return null;
    }

    public ISparkChartOptionsModel getModel() {
        if (this._model == null) {
            NamedDefinition namedDef = this.getDefinition();
            if (BindingUtil.isAccessorDefinition(namedDef)) {
                AccessorDefinition accessorDef = (AccessorDefinition)namedDef;
                StructureDefinition structureDef = accessorDef.getStructure();
                this._attrDefs = BindingUtil.getAttributeDefinitions(structureDef, false);
                this._model = new SparkChartOptionsModel(CreatorPresentationManager.getInstance().getCreatorPresentation(this.getType().toString()), this._attrDefs);
            }
            if (this._model != null) {
                this.initModel(this._model);
            }
        }
        return this._model;
    }

    private NamedDefinition getDefinition() {
        ModelProvider modelProvider = this.getParams().getModelProvider();
        if (modelProvider instanceof DvtCoreProvider) {
            return ((DvtCoreProvider)modelProvider).getDefinition();
        }
        return null;
    }

    private void initModel(ISparkChartOptionsModel model) {
        if (this.getBindingContextType() != BindOperationType.CREATE) {
            String subType = ((SparkChartOptions)this.getPatternOptions()).getExtendedProperties().getSubType();
            String variationType = SUBTYPE_AREA.equals(subType) ? "AREA_VERT_ABS" : (SUBTYPE_BAR.equals(subType) ? "BAR_VERT_CLUST" : (SUBTYPE_FLOATING_BAR.equals(subType) ? "BAR_VERT_FLOAT_STACK" : "LINE_VERT_ABS"));
            model.setPresentationLayout((IPresentationLayout)new PresentationLayout(variationType, null));
        }
    }

    private GraphType getType() {
        return GraphType.SPARKCHART;
    }

    @Override
    public ComponentOptionsPageProvider createPageProvider() {
        return new SparkChartOptionsPageProvider((IOptionsMapper)this);
    }

    @Override
    public IStatus validateModel() {
        if (!BindingUtil.isNumericAttribute(this.getAttributeDefinition(this.getModel().getValue()))) {
            String message = GraphOptionsResources.error_missingSingleNumericDataPoint;
            String param = this.getModel().isBar() ? GraphOptionsResources.sparkChart_barLabel : (this.getModel().isFloatingBar() ? GraphOptionsResources.sparkChart_barHeightLabel : (this.getModel().isArea() ? GraphOptionsResources.sparkChart_areaLabel : GraphOptionsResources.sparkChart_lineLabel));
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", NLS.bind((String)message, (Object)param));
        }
        if (this.getModel().isFloatingBar()) {
            if (!BindingUtil.isNumericAttribute(this.getAttributeDefinition(this.getModel().getFloatValue()))) {
                String message = GraphOptionsResources.error_missingSingleNumericDataPoint;
                String param = GraphOptionsResources.sparkChart_barFloatLabel;
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", NLS.bind((String)message, (Object)param));
            }
            if (this.getModel().getValue().equals(this.getModel().getFloatValue())) {
                String message = GraphOptionsResources.error_duplicateValue;
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", NLS.bind((String)message, (Object)this.getModel().getValue()));
            }
        }
        return null;
    }

    @Override
    public void updateOptions() {
        IPresentationLayout layout = this.getModel().getPresentationLayout();
        if (this.getBindingContextType() == BindOperationType.CREATE && layout != null) {
            String subType = this.getModel().isBar() ? SUBTYPE_BAR : (this.getModel().isFloatingBar() ? SUBTYPE_FLOATING_BAR : (this.getModel().isArea() ? SUBTYPE_AREA : SUBTYPE_LINE));
            ((SparkChartOptions)this.getPatternOptions()).getExtendedProperties().setSubType(subType);
        }
        ((SparkChartOptions)this.getPatternOptions()).setValue(this.getAttributeDefinition(this.getModel().getValue()));
        if (this.getModel().isFloatingBar()) {
            ((SparkChartOptions)this.getPatternOptions()).setFloatValue(this.getAttributeDefinition(this.getModel().getFloatValue()));
        } else {
            ((SparkChartOptions)this.getPatternOptions()).setFloatValue(null);
        }
    }
}

