/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.ArrayList;
import java.util.List;
import oracle.binding.meta.AttributeDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IScatterGraphOptionsModel;

class ScatterGraphOptionsModel
extends GraphOptionsModel
implements IScatterGraphOptionsModel {
    static final String VARIATION_TYPE_POLAR = "POLAR";
    private boolean _isAutoAssign = true;
    private int _xAxisDataPointIndex = -1;
    private int _yAxisDataPointIndex = -1;
    private boolean _markerColorSet = false;

    public ScatterGraphOptionsModel(GraphType type, ICreatorPresentation creatorPresentation, List<AttributeDefinition> attributes) {
        super(type, creatorPresentation, attributes);
        super.setDataOnSeries(false);
    }

    @Override
    public void setDataOnSeries(boolean dataOnSeries) {
    }

    @Override
    public void setSeriesItemContexts(List<EdgeItemContext> series) {
        this._markerColorSet = false;
        if (series != null && !series.isEmpty()) {
            this._markerColorSet = true;
        }
        super.setSeriesItemContexts(series);
    }

    @Override
    public void setGroupsItemContexts(List<EdgeItemContext> groups) {
        this._xAxisDataPointIndex = -1;
        this._yAxisDataPointIndex = -1;
        if (groups != null && !groups.isEmpty()) {
            int index = 0;
            for (EdgeItemContext item : groups) {
                if (item.isNumeric() && !item.isTreatAsText()) {
                    this._xAxisDataPointIndex = index;
                    if (this._xAxisDataPointIndex + 1 >= groups.size() || !(item = groups.get(this._xAxisDataPointIndex + 1)).isNumeric() || item.isTreatAsText()) break;
                    this._yAxisDataPointIndex = this._xAxisDataPointIndex + 1;
                    break;
                }
                ++index;
            }
        }
        super.setGroupsItemContexts(groups);
    }

    @Override
    public void resetData() {
        this.setSeriesItemContexts(null);
        this.setGroupsItemContexts(null);
        this._isAutoAssign = true;
    }

    public EdgeItemContext getXAxisDataPoint() {
        List<EdgeItemContext> groups = this.getGroupsItemContexts();
        if (this._xAxisDataPointIndex < 0 || this._xAxisDataPointIndex >= groups.size()) {
            return null;
        }
        return groups.get(this._xAxisDataPointIndex);
    }

    public void setXAxisDataPoint(EdgeItemContext dataPoint) {
        if (dataPoint != null && !dataPoint.isNumeric()) {
            return;
        }
        ArrayList<EdgeItemContext> groups = new ArrayList<EdgeItemContext>(this.getGroupsItemContexts());
        if (this._xAxisDataPointIndex < 0) {
            this._xAxisDataPointIndex = 0;
            groups.add(this._xAxisDataPointIndex, dataPoint);
            if (this._yAxisDataPointIndex >= 0) {
                ++this._yAxisDataPointIndex;
            }
        } else {
            groups.set(this._xAxisDataPointIndex, dataPoint);
        }
        super.setGroupsItemContexts(groups);
    }

    public EdgeItemContext getYAxisDataPoint() {
        List<EdgeItemContext> groups = this.getGroupsItemContexts();
        if (this._yAxisDataPointIndex < 0 || this._yAxisDataPointIndex >= groups.size()) {
            return null;
        }
        return groups.get(this._yAxisDataPointIndex);
    }

    public void setYAxisDataPoint(EdgeItemContext dataPoint) {
        ArrayList<EdgeItemContext> groups = new ArrayList<EdgeItemContext>(this.getGroupsItemContexts());
        if (this._yAxisDataPointIndex < 0) {
            this._yAxisDataPointIndex = this._xAxisDataPointIndex < 0 ? 0 : this._xAxisDataPointIndex + 1;
            groups.add(this._yAxisDataPointIndex, dataPoint);
        } else {
            groups.set(this._yAxisDataPointIndex, dataPoint);
        }
        super.setGroupsItemContexts(groups);
    }

    public List<EdgeItemContext> getMarkerTypes() {
        return this.getSeriesItemContexts();
    }

    public void setMarkerTypes(List<EdgeItemContext> itemContexts) {
        this.setSeriesItemContexts(itemContexts);
    }

    public EdgeItemContext getMarkerColor() {
        List<EdgeItemContext> series = this.getSeriesItemContexts();
        if (!this._markerColorSet || series.isEmpty()) {
            return null;
        }
        return series.get(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMarkerColor(EdgeItemContext dataValue) {
        ArrayList<EdgeItemContext> series = new ArrayList<EdgeItemContext>(this.getSeriesItemContexts());
        if (dataValue == null) {
            if (!this._markerColorSet) return;
            series.remove(0);
            this._markerColorSet = false;
        } else if (this._markerColorSet) {
            series.set(0, dataValue);
        } else {
            this._markerColorSet = true;
            series.add(0, dataValue);
        }
        super.setSeriesItemContexts(series);
    }

    public EdgeItemContext getMarkerShape() {
        List<EdgeItemContext> series = this.getSeriesItemContexts();
        if (this._markerColorSet) {
            return series.size() > 1 ? series.get(1) : null;
        }
        return series.isEmpty() ? null : series.get(0);
    }

    public void setMarkerShape(EdgeItemContext dataValue) {
        ArrayList<EdgeItemContext> series = new ArrayList<EdgeItemContext>(this.getSeriesItemContexts());
        if (dataValue == null) {
            if (this._markerColorSet && series.size() > 1) {
                series.remove(1);
            } else if (!this._markerColorSet && series.size() > 0) {
                series.remove(0);
            }
        } else if (this._markerColorSet) {
            if (series.size() < 2) {
                series.add(dataValue);
            } else {
                series.set(1, dataValue);
            }
        } else if (series.isEmpty()) {
            series.add(dataValue);
        } else {
            series.set(0, dataValue);
        }
        super.setSeriesItemContexts(series);
    }

    public List<EdgeItemContext> getMarkerTooltips() {
        ArrayList<EdgeItemContext> tooltip = new ArrayList<EdgeItemContext>(this.getGroupsItemContexts());
        if (this._yAxisDataPointIndex >= 0) {
            tooltip.remove(this._yAxisDataPointIndex);
        }
        if (this._xAxisDataPointIndex >= 0) {
            tooltip.remove(this._xAxisDataPointIndex);
        }
        return tooltip;
    }

    public void setMarkerTooltips(List<EdgeItemContext> itemContexts) {
        List<EdgeItemContext> oldGroups = this.getGroupsItemContexts();
        ArrayList<EdgeItemContext> newGroups = new ArrayList<EdgeItemContext>();
        if (this._xAxisDataPointIndex >= 0) {
            newGroups.add(oldGroups.get(this._xAxisDataPointIndex));
            this._xAxisDataPointIndex = 0;
        }
        if (this._yAxisDataPointIndex >= 0) {
            newGroups.add(oldGroups.get(this._yAxisDataPointIndex));
            int n = this._yAxisDataPointIndex = this._xAxisDataPointIndex < 0 ? 0 : this._xAxisDataPointIndex + 1;
        }
        if (itemContexts != null && !itemContexts.isEmpty()) {
            newGroups.addAll(itemContexts);
        }
        super.setGroupsItemContexts(newGroups);
    }

    public boolean isAutomaticallyAssigned() {
        return this._isAutoAssign;
    }

    public void setAutomaticallyAssigned(boolean isAutoAssign) {
        this._isAutoAssign = isAutoAssign;
    }

    public boolean isPolar() {
        return this.getPresentationLayout() != null && VARIATION_TYPE_POLAR.equals(this.getPresentationLayout().getVariationType());
    }
}

