/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.List;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphFootnote;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphSubtitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphTitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendArea;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendTitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.O1Title;
import oracle.adfdt.view.dvt.binding.pattern.graph.ParetoGraphOptions;
import oracle.adfdt.view.dvt.binding.pattern.graph.Y1MajorTick;
import oracle.adfdt.view.dvt.binding.pattern.graph.Y1Title;
import oracle.adfdt.view.dvt.binding.pattern.graph.Y2Title;
import oracle.adfdt.view.dvt.binding.pattern.options.GraphBindingOptions;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.AxisGraphOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsResources;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.ICommonAxisGraphOptions;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParetoGraphOptionsMapper
extends AxisGraphOptionsMapper<ParetoGraphOptions> {
    private static final String PARETOLINE_TAG_NAME = "paretoLine";
    private static final String PARETOMARKER_TAG_NAME = "paretoMarker";
    private static final String QUICKLAYOUT_PARETO2 = "pareto2_all_titles";
    private static final String QUICKLAYOUT_PARETO3 = "pareto3_no_gridlines";

    public ParetoGraphOptionsMapper(BindOperationType opType, Widget<ParetoGraphOptions> widget, CreatorParams<ParetoGraphOptions> params) {
        super(opType, widget, params);
    }

    @Override
    protected GraphType getType() {
        return GraphType.PARETO;
    }

    @Override
    protected String getSeriesLabel() {
        return GraphOptionsResources.paretoGraph_seriesLabel;
    }

    @Override
    public IStatus validateModel() {
        if (!this.getModel().isNameValuePair()) {
            List edge = this.getModel().getSeriesItemContexts();
            if (edge == null || edge.size() < 1 || edge.get(0) == null || !((EdgeItemContext)edge.get(0)).isNumeric() || ((EdgeItemContext)edge.get(0)).isTreatAsText()) {
                String message = GraphOptionsResources.error_missingSingleNumericDataPoint;
                String param = this.getSeriesLabel();
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", NLS.bind((String)message, (Object)param));
            }
            if (edge.size() != 1) {
                String message = "Program Error: too many data points for pareto series edge";
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message);
            }
        }
        return null;
    }

    @Override
    public void updateOptions() {
        IPresentationLayout layout = this.getModel().getPresentationLayout();
        if (this.getBindingContextType() == BindOperationType.CREATE && layout != null) {
            ((ParetoGraphOptions)this.getPatternOptions()).setGraphSubType(layout.getVariationType());
            String quickLayout = layout.getQuickLayout();
            if (quickLayout.equals(QUICKLAYOUT_PARETO2)) {
                this.configureParetoQuickLayout2();
            } else if (quickLayout.equals(QUICKLAYOUT_PARETO3)) {
                this.configureParetoQuickLayout3();
            }
        }
        this.update(this.getCommonGraphOptions());
    }

    private void configureParetoQuickLayout2() {
        ParetoGraphOptions options = (ParetoGraphOptions)this.getPatternOptions();
        ICommonAxisGraphOptions commonOptions = this.getCommonGraphOptions();
        GraphFootnote graphFootnote = new GraphFootnote();
        graphFootnote.setText(GraphOptionsResources.quickLayout_graphFootnote);
        options.getExtendedProperties().setGraphFootnote(graphFootnote);
        GraphSubtitle graphSubtitle = new GraphSubtitle();
        graphSubtitle.setText(GraphOptionsResources.quickLayout_graphSubtitle);
        options.getExtendedProperties().setGraphSubtitle(graphSubtitle);
        GraphTitle graphTitle = new GraphTitle();
        graphTitle.setText(GraphOptionsResources.quickLayout_graphTitle);
        options.getExtendedProperties().setGraphTitle(graphTitle);
        this.addO1Title(commonOptions);
        this.addY1Title(commonOptions);
        Y2Title title = new Y2Title();
        title.setText(GraphOptionsResources.quickLayout_y2Title);
        options.getExtendedProperties().setY2Title(title);
    }

    private void configureParetoQuickLayout3() {
        Y1MajorTick y1MajorTick = new Y1MajorTick();
        y1MajorTick.setTickStyle("GS_NONE");
        ((ParetoGraphOptions)this.getPatternOptions()).getExtendedProperties().setY1MajorTick(y1MajorTick);
    }

    @Override
    public void postProcess(Node node) {
        Element graphElement = ParetoGraphOptionsMapper.getSingleBindRoot(node);
        if (graphElement == null || !this.getType().toString().equals(graphElement.getLocalName())) {
            return;
        }
        IPresentationLayout layout = this.getModel().getPresentationLayout();
        if (this.getBindingContextType() == BindOperationType.CREATE && layout != null) {
            Element refChild = ParetoGraphOptionsMapper.addBackgroundTag(graphElement);
            refChild = this.addAxisTags(layout.getVariationType(), graphElement, refChild);
            refChild = ParetoGraphOptionsMapper.addTag(graphElement, "graphPlotArea", refChild);
            refChild = ParetoGraphOptionsMapper.addTag(graphElement, PARETOLINE_TAG_NAME, refChild);
            refChild = ParetoGraphOptionsMapper.addTag(graphElement, PARETOMARKER_TAG_NAME, refChild);
        }
    }

    @Override
    protected ICommonAxisGraphOptions getCommonGraphOptions() {
        return new ParetoGraphOptionsWrapper((ParetoGraphOptions)this.getPatternOptions());
    }

    private class ParetoGraphOptionsWrapper
    implements ICommonAxisGraphOptions {
        private ParetoGraphOptions _graphOptions;

        ParetoGraphOptionsWrapper(ParetoGraphOptions graphOptions) {
            this._graphOptions = graphOptions;
        }

        @Override
        public String getGraphType() {
            return this._graphOptions.getGraphType();
        }

        @Override
        public String getGraphSubType() {
            return this._graphOptions.getGraphSubType();
        }

        @Override
        public void setGraphSubType(String graphSubType) {
            this._graphOptions.setGraphSubType(graphSubType);
        }

        @Override
        public GraphBindingOptions getBindingOptions() {
            return this._graphOptions.getBindingOptions();
        }

        @Override
        public void setRowSelection(boolean rowSelection) {
            this._graphOptions.setRowSelection(rowSelection);
        }

        @Override
        public boolean isRowSelection() {
            return this._graphOptions.isRowSelection();
        }

        @Override
        public void setGraphFootnote(GraphFootnote graphFootnote) {
            this._graphOptions.getExtendedProperties().setGraphFootnote(graphFootnote);
        }

        @Override
        public void setGraphSubtitle(GraphSubtitle graphSubtitle) {
            this._graphOptions.getExtendedProperties().setGraphSubtitle(graphSubtitle);
        }

        @Override
        public void setGraphTitle(GraphTitle graphTitle) {
            this._graphOptions.getExtendedProperties().setGraphTitle(graphTitle);
        }

        @Override
        public void setLegendArea(LegendArea legendArea) {
            this._graphOptions.getExtendedProperties().setLegendArea(legendArea);
        }

        @Override
        public void setLegendTitle(LegendTitle legendTitle) {
            this._graphOptions.getExtendedProperties().setLegendTitle(legendTitle);
        }

        @Override
        public void setO1Title(O1Title o1Title) {
            this._graphOptions.getExtendedProperties().setO1Title(o1Title);
        }

        @Override
        public void setY1Title(Y1Title y1Title) {
            this._graphOptions.getExtendedProperties().setY1Title(y1Title);
        }
    }
}

