/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.binding.meta.AttributeDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.AttributeDefinitionEdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.PresentationOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGraphOptionsModel;

class GraphOptionsModel
extends PresentationOptionsModel
implements IGraphOptionsModel {
    private final GraphType _type;
    private final List<EdgeItemContext> _allEdgeItemContexts;
    private final List<EdgeItemContext> _seriesItemContexts = new ArrayList<EdgeItemContext>();
    private final List<EdgeItemContext> _groupsItemContexts = new ArrayList<EdgeItemContext>();
    private boolean _dataOnSeries;
    private boolean _rowSelection;

    public GraphOptionsModel(GraphType type, ICreatorPresentation creatorPresentation, List<AttributeDefinition> attributes) {
        super("graphType", creatorPresentation);
        if (type == null) {
            throw new IllegalArgumentException("Programming Error: Graph type cannot be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Programming Error: Attribute definitions cannot be null");
        }
        this._type = type;
        ArrayList<AttributeDefinitionEdgeItemContext> items = new ArrayList<AttributeDefinitionEdgeItemContext>(attributes.size());
        for (AttributeDefinition attr : attributes) {
            items.add(new AttributeDefinitionEdgeItemContext(attr));
        }
        this._allEdgeItemContexts = Collections.unmodifiableList(items);
    }

    public GraphType getType() {
        return this._type;
    }

    public void resetData() {
        this.setSeriesItemContexts(null);
        this.setGroupsItemContexts(null);
        this.setDataOnSeries(true);
    }

    public List<EdgeItemContext> getAllEdgeItemContexts() {
        return this._allEdgeItemContexts;
    }

    public EdgeItemContext findEdgeItemContext(String name) {
        if (name != null && !name.isEmpty()) {
            for (EdgeItemContext itemContext : this._allEdgeItemContexts) {
                if (!itemContext.getName().equals(name)) continue;
                return itemContext;
            }
        }
        return null;
    }

    public List<EdgeItemContext> getSeriesItemContexts() {
        return Collections.unmodifiableList(this._seriesItemContexts);
    }

    public void setSeriesItemContexts(List<EdgeItemContext> itemContexts) {
        this._seriesItemContexts.clear();
        if (itemContexts != null && !itemContexts.isEmpty()) {
            this._seriesItemContexts.addAll(itemContexts);
        }
    }

    public List<EdgeItemContext> getGroupsItemContexts() {
        return Collections.unmodifiableList(this._groupsItemContexts);
    }

    public void setGroupsItemContexts(List<EdgeItemContext> itemContexts) {
        this._groupsItemContexts.clear();
        if (itemContexts != null && !itemContexts.isEmpty()) {
            this._groupsItemContexts.addAll(itemContexts);
        }
    }

    public boolean isDataOnSeries() {
        return this._dataOnSeries;
    }

    public void setDataOnSeries(boolean dataOnSeries) {
        this._dataOnSeries = dataOnSeries;
    }

    public boolean isNameValuePair() {
        return false;
    }

    public void setNameValuePair(boolean isNameValuePair) {
        throw new UnsupportedOperationException("Program error: name-value pair not yet supported");
    }

    public boolean isRowSelection() {
        return this._rowSelection;
    }

    public void setRowSelection(boolean rowSelection) {
        this._rowSelection = rowSelection;
    }
}

