/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.binding.meta.AttributeDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.util.BindingUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.PresentationOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GaugeLabelPosition;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GaugeType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGaugeOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGaugeThreshold;

class GaugeOptionsModel
extends PresentationOptionsModel
implements IGaugeOptionsModel {
    public static final List<GaugeLabelPosition> TOP_LABEL_POSITIONS = Collections.unmodifiableList(new ArrayList<GaugeLabelPosition>(Arrays.asList(GaugeLabelPosition.ABOVE, GaugeLabelPosition.INSIDE)));
    public static final List<GaugeLabelPosition> BOTTOM_LABEL_POSITIONS = Collections.unmodifiableList(new ArrayList<GaugeLabelPosition>(Arrays.asList(GaugeLabelPosition.BELOW, GaugeLabelPosition.INSIDE)));
    public static final List<GaugeLabelPosition> METRIC_LABEL_POSITIONS = Collections.unmodifiableList(new ArrayList<GaugeLabelPosition>(Arrays.asList(GaugeLabelPosition.BELOW, GaugeLabelPosition.WITH_BOTTOM_LABEL, GaugeLabelPosition.INSIDE)));
    private static final String SET_SUFFIX = "_SET";
    private static final String THRESHOLD_SUFFIX = "_THRESHOLDS";
    private static final String DEFAULT_COLOR_STRING = "#d62800";
    private static final String MAX_THRESHOLD_COLOR_STRING = "#84ae31";
    private static final String YELLOW_COLOR_STRING = "#ffcf21";
    private final GaugeType _gaugeType;
    private final List<String> _attributes;
    private final List<String> _numericAttributes;
    private final Set<String> _usedNumericAttrs = new HashSet<String>();
    private String _metricValue;
    private String _minValue;
    private String _maxValue;
    private boolean _showTopLabel;
    private String _topLabel;
    private GaugeLabelPosition _topLabelPosition = GaugeLabelPosition.ABOVE;
    private boolean _showBottomLabel;
    private String _bottomLabel;
    private GaugeLabelPosition _bottomLabelPosition = GaugeLabelPosition.BELOW;
    private boolean _showMetricLabel;
    private GaugeLabelPosition _metricLabelPosition = GaugeLabelPosition.WITH_BOTTOM_LABEL;
    private final List<IGaugeThreshold> _thresholds = new ArrayList<IGaugeThreshold>();

    public GaugeOptionsModel(GaugeType type, ICreatorPresentation creatorPresentation, List<AttributeDefinition> attributes) {
        super("graphType", creatorPresentation);
        this._gaugeType = type;
        if (attributes == null) {
            throw new IllegalArgumentException("Programming Error: Attribute definitions cannot be null");
        }
        ArrayList<String> attrs = new ArrayList<String>();
        ArrayList<String> numericAttrs = new ArrayList<String>();
        for (AttributeDefinition attrDef : attributes) {
            attrs.add(attrDef.getName());
            if (!BindingUtil.isNumericAttribute(attrDef)) continue;
            numericAttrs.add(attrDef.getName());
        }
        this._attributes = Collections.unmodifiableList(attrs);
        this._numericAttributes = Collections.unmodifiableList(numericAttrs);
    }

    public void resetData() {
        if (this.getPresentationLayout() != null && this.getPresentationLayout().getVariationType() != null) {
            if (this.getPresentationLayout().getVariationType().endsWith(THRESHOLD_SUFFIX) || this.getPresentationLayout().getVariationType().endsWith(SET_SUFFIX)) {
                if (this._thresholds.isEmpty()) {
                    this.createGaugeThreshold(false);
                    IGaugeThreshold threshold = this.createGaugeThreshold(false);
                    threshold.setFillColor(YELLOW_COLOR_STRING);
                }
            } else if (!this._thresholds.isEmpty()) {
                this._thresholds.clear();
            }
        }
    }

    public GaugeType getGaugeType() {
        return this._gaugeType;
    }

    public List<String> getMetricValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (String value : this._numericAttributes) {
            if (!value.equals(this.getMetricValue()) && this._usedNumericAttrs.contains(value)) continue;
            values.add(value);
        }
        return values;
    }

    public String getMetricValue() {
        return this._metricValue;
    }

    public void setMetricValue(String value) {
        if (this._metricValue != null) {
            this._usedNumericAttrs.remove(this._metricValue);
        }
        this._metricValue = value;
        if (this._numericAttributes.contains(value)) {
            this._usedNumericAttrs.add(this._metricValue);
        }
    }

    public List<String> getMinValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (String value : this._numericAttributes) {
            if (!value.equals(this.getMinValue()) && this._usedNumericAttrs.contains(value)) continue;
            values.add(value);
        }
        return values;
    }

    public String getMinValue() {
        return this._minValue;
    }

    public void setMinValue(String value) {
        if (this._minValue != null) {
            this._usedNumericAttrs.remove(this._minValue);
        }
        this._minValue = value;
        if (this._numericAttributes.contains(value)) {
            this._usedNumericAttrs.add(this._minValue);
        }
    }

    public List<String> getMaxValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (String value : this._numericAttributes) {
            if (!value.equals(this.getMaxValue()) && this._usedNumericAttrs.contains(value)) continue;
            values.add(value);
        }
        return values;
    }

    public String getMaxValue() {
        return this._maxValue;
    }

    public void setMaxValue(String value) {
        if (this._maxValue != null) {
            this._usedNumericAttrs.remove(this._maxValue);
        }
        this._maxValue = value;
        if (this._numericAttributes.contains(value)) {
            this._usedNumericAttrs.add(this._maxValue);
        }
    }

    public List<String> getLabels() {
        return this._attributes;
    }

    public boolean showTopLabel() {
        return this._showTopLabel;
    }

    public void setShowTopLabel(boolean showTopLabel) {
        this._showTopLabel = showTopLabel;
    }

    public String getTopLabel() {
        return this._topLabel;
    }

    public void setTopLabel(String label) {
        this._topLabel = label;
    }

    public List<GaugeLabelPosition> getTopLabelPositions() {
        return TOP_LABEL_POSITIONS;
    }

    public GaugeLabelPosition getTopLabelPosition() {
        return this._topLabelPosition;
    }

    public void setTopLabelPosition(GaugeLabelPosition position) {
        this._topLabelPosition = position;
    }

    public boolean showBottomLabel() {
        return this._showBottomLabel;
    }

    public void setShowBottomLabel(boolean showBottomLabel) {
        this._showBottomLabel = showBottomLabel;
    }

    public String getBottomLabel() {
        return this._bottomLabel;
    }

    public void setBottomLabel(String label) {
        this._bottomLabel = label;
    }

    public List<GaugeLabelPosition> getBottomLabelPositions() {
        return BOTTOM_LABEL_POSITIONS;
    }

    public GaugeLabelPosition getBottomLabelPosition() {
        return this._bottomLabelPosition;
    }

    public void setBottomLabelPosition(GaugeLabelPosition position) {
        this._bottomLabelPosition = position;
    }

    public boolean showMetricLabel() {
        return this._showMetricLabel;
    }

    public void setShowMetricLabel(boolean showMetricLabel) {
        this._showMetricLabel = showMetricLabel;
    }

    public List<GaugeLabelPosition> getMetricLabelPositions() {
        return METRIC_LABEL_POSITIONS;
    }

    public GaugeLabelPosition getMetricLabelPosition() {
        return this._metricLabelPosition;
    }

    public void setMetricLabelPosition(GaugeLabelPosition position) {
        this._metricLabelPosition = position;
    }

    public List<IGaugeThreshold> getGaugeThresholds() {
        return Collections.unmodifiableList(this._thresholds);
    }

    public IGaugeThreshold createGaugeThreshold(boolean isMax) {
        Threshold threshold = null;
        if (this._thresholds.size() == 0) {
            threshold = new Threshold(true, 0);
            threshold.setFillColor(MAX_THRESHOLD_COLOR_STRING);
            this._thresholds.add(threshold);
        }
        if (!isMax) {
            threshold = new Threshold(false, this._thresholds.size() - 1);
            this._thresholds.add(this._thresholds.size() - 1, threshold);
            ((Threshold)this._thresholds.get(this._thresholds.size() - 1)).resetIndex(this._thresholds.size() - 1);
        }
        return threshold;
    }

    public void removeGaugeThreshold(IGaugeThreshold threshold) {
        if (!threshold.isMaxThreshold()) {
            if (this._thresholds.size() > 1) {
                this._thresholds.remove(threshold);
            }
            if (this._thresholds.size() == 1) {
                this._thresholds.clear();
            }
            int i = 0;
            for (IGaugeThreshold t : this._thresholds) {
                ((Threshold)t).resetIndex(i++);
            }
        }
    }

    private class Threshold
    implements IGaugeThreshold {
        private final boolean _isMaxThreshold;
        private int _index = 0;
        private String _maxValue;
        private String _text;
        private String _color = "#d62800";

        public Threshold(boolean isMax, int index) {
            this._isMaxThreshold = isMax;
            this._index = index;
        }

        public boolean isMaxThreshold() {
            return this._isMaxThreshold;
        }

        public int getIndex() {
            return this._index;
        }

        public void resetIndex(int index) {
            this._index = index;
        }

        public String getMaxValue() {
            return this._maxValue;
        }

        public void setMaxValue(String value) {
            this._maxValue = value;
        }

        public String getText() {
            return this._text;
        }

        public void setText(String text) {
            this._text = text;
        }

        public String getFillColor() {
            return this._color;
        }

        public void setFillColor(String color) {
            this._color = color;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this._color == null ? 0 : this._color.hashCode());
            result = 31 * result + this._index;
            result = 31 * result + (this._isMaxThreshold ? 1231 : 1237);
            result = 31 * result + (this._maxValue == null ? 0 : this._maxValue.hashCode());
            result = 31 * result + (this._text == null ? 0 : this._text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Threshold other = (Threshold)obj;
            return this._index == other.getIndex() && this._isMaxThreshold == other.isMaxThreshold() && DTRTUtil.equals((Object)this.getMaxValue(), (Object)other.getMaxValue()) && DTRTUtil.equals((Object)this.getText(), (Object)other.getText()) && DTRTUtil.equals((Object)this.getFillColor(), (Object)other.getFillColor());
        }
    }
}

