/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.ArrayList;
import java.util.List;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.provider.ModelProvider;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.dvt.binding.pattern.common.SpecialEffects;
import oracle.adfdt.view.dvt.binding.pattern.gauge.BottomLabel;
import oracle.adfdt.view.dvt.binding.pattern.gauge.GaugeBackground;
import oracle.adfdt.view.dvt.binding.pattern.gauge.GaugeFrame;
import oracle.adfdt.view.dvt.binding.pattern.gauge.GaugeLegendArea;
import oracle.adfdt.view.dvt.binding.pattern.gauge.GaugeLegendTitle;
import oracle.adfdt.view.dvt.binding.pattern.gauge.GaugeOptions;
import oracle.adfdt.view.dvt.binding.pattern.gauge.GaugePlotArea;
import oracle.adfdt.view.dvt.binding.pattern.gauge.Indicator;
import oracle.adfdt.view.dvt.binding.pattern.gauge.IndicatorBar;
import oracle.adfdt.view.dvt.binding.pattern.gauge.IndicatorBase;
import oracle.adfdt.view.dvt.binding.pattern.gauge.MetricLabel;
import oracle.adfdt.view.dvt.binding.pattern.gauge.Threshold;
import oracle.adfdt.view.dvt.binding.pattern.gauge.ThresholdSet;
import oracle.adfdt.view.dvt.binding.pattern.gauge.TickLabel;
import oracle.adfdt.view.dvt.binding.pattern.gauge.TickMark;
import oracle.adfdt.view.dvt.binding.pattern.gauge.TopLabel;
import oracle.adfdt.view.dvt.binding.pattern.gauge.extension.GaugeExtendedProperties;
import oracle.adfdt.view.dvt.binding.pattern.options.GaugeBindingOptions;
import oracle.adfdt.view.dvt.binding.provider.DvtCoreProvider;
import oracle.adfdtinternal.view.dvt.binding.resource.DVTCreatorBundle;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.binding.creator.CreatorPresentationManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.DefaultOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GaugeOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.util.BindingUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.PresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GaugeLabelPosition;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GaugeType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGaugeOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGaugeThreshold;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ComponentOptionsPageProvider;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.gauge.GaugeOptionsPageProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;

public class GaugeOptionsMapper
extends DefaultOptionsMapper<GaugeOptions> {
    private static final String QUICKLAYOUT_QL1 = "GQL1_default";
    private static final String QUICKLAYOUT_QL2 = "GQL2_default_with_legend";
    private static final String QUICKLAYOUT_QL3 = "GQL3_metric_below_gauge";
    private static final String QUICKLAYOUT_QL4 = "GQL4_metric_inside_gauge";
    private static final String QUICKLAYOUT_QL5 = "GQL5_legend_bottom";
    private static final String QUICKLAYOUT_QL6 = "GQL6_no_labels";
    private final GaugeType _gaugeType;
    private IGaugeOptionsModel _model;

    public GaugeOptionsMapper(BindOperationType opType, Widget<GaugeOptions> widget, GaugeType type, CreatorParams<GaugeOptions> params) {
        super(opType, widget, params);
        this._gaugeType = type;
    }

    public IGaugeOptionsModel getModel() {
        if (this._model == null) {
            NamedDefinition namedDef = this.getDefinition();
            if (BindingUtil.isAccessorDefinition(namedDef)) {
                AccessorDefinition accessorDef = (AccessorDefinition)namedDef;
                StructureDefinition structureDef = accessorDef.getStructure();
                List<AttributeDefinition> attrDefs = BindingUtil.getAttributeDefinitions(structureDef, false);
                this._model = new GaugeOptionsModel(this.getGaugeType(), CreatorPresentationManager.getInstance().getCreatorPresentation("gauge:" + this.getGaugeType()), attrDefs);
            }
            if (this._model != null) {
                this.initModel(this._model);
            }
        }
        return this._model;
    }

    private GaugeType getGaugeType() {
        return this._gaugeType;
    }

    private NamedDefinition getDefinition() {
        ModelProvider modelProvider = this.getParams().getModelProvider();
        if (modelProvider instanceof DvtCoreProvider) {
            return ((DvtCoreProvider)modelProvider).getDefinition();
        }
        return null;
    }

    private void initModel(IGaugeOptionsModel model) {
        List list;
        GaugeBindingOptions bindOpts = ((GaugeOptions)this.getPatternOptions()).getBindingOptions();
        model.setMetricValue(bindOpts.getMetricValue());
        GaugeExtendedProperties extendedProps = ((GaugeOptions)this.getPatternOptions()).getExtendedProperties();
        model.setMinValue(extendedProps.getMinValueAsString());
        model.setMaxValue(extendedProps.getMaxValueAsString());
        TopLabel topLabel = extendedProps.getTopLabel();
        if (topLabel != null) {
            model.setShowTopLabel(true);
            model.setTopLabel(topLabel.getText());
            model.setTopLabelPosition(GaugeLabelPosition.forType((String)topLabel.getPosition()));
        } else {
            model.setShowTopLabel(this.getBindingContextType() == BindOperationType.CREATE);
        }
        BottomLabel bottomLabel = extendedProps.getBottomLabel();
        if (bottomLabel != null) {
            model.setShowBottomLabel(true);
            model.setBottomLabel(bottomLabel.getText());
            model.setBottomLabelPosition(GaugeLabelPosition.forType((String)bottomLabel.getPosition()));
        } else {
            model.setShowBottomLabel(this.getBindingContextType() == BindOperationType.CREATE);
        }
        MetricLabel metricLabel = extendedProps.getMetricLabel();
        if (metricLabel != null) {
            model.setShowMetricLabel(true);
            model.setMetricLabelPosition(GaugeLabelPosition.forType((String)metricLabel.getPosition()));
        } else {
            model.setShowMetricLabel(this.getBindingContextType() == BindOperationType.CREATE);
        }
        ThresholdSet thresholdSet = extendedProps.getThresholdSet();
        if (thresholdSet != null && (list = thresholdSet.getThreshold()) != null && !list.isEmpty()) {
            Threshold threshold = (Threshold)list.get(list.size() - 1);
            IGaugeThreshold modelThreshold = model.createGaugeThreshold(true);
            modelThreshold.setMaxValue(threshold.getThresholdMaxValueAsString());
            modelThreshold.setText(threshold.getText());
            modelThreshold.setFillColor(threshold.getFillColor());
            int i = 0;
            while (i < list.size() - 1) {
                threshold = (Threshold)list.get(i);
                modelThreshold = model.createGaugeThreshold(false);
                modelThreshold.setMaxValue(threshold.getThresholdMaxValueAsString());
                modelThreshold.setText(threshold.getText());
                modelThreshold.setFillColor(threshold.getFillColor());
                ++i;
            }
        }
        PresentationLayout layout = null;
        if (this.getBindingContextType() != BindOperationType.CREATE) {
            String variationType = "";
            layout = new PresentationLayout(variationType, null);
        }
        model.setPresentationLayout(layout);
    }

    @Override
    public ComponentOptionsPageProvider createPageProvider() {
        return new GaugeOptionsPageProvider((IOptionsMapper)this);
    }

    @Override
    public IStatus validateModel() {
        if (this.getModel().getMetricValue() == null) {
            String message = Messages.error_missingMetricValue;
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message);
        }
        String minValue = this.getModel().getMinValue();
        if (minValue != null && !minValue.trim().isEmpty() && !this.isNumber(minValue)) {
            String message = Messages.error_minValueNotANumber;
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message);
        }
        String maxValue = this.getModel().getMaxValue();
        if (maxValue != null && !maxValue.trim().isEmpty() && !this.isNumber(maxValue)) {
            String message = Messages.error_maxValueNotANumber;
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message);
        }
        List thresholds = this.getModel().getGaugeThresholds();
        if (thresholds != null && !thresholds.isEmpty()) {
            StringBuilder param = new StringBuilder();
            for (IGaugeThreshold threshold : thresholds) {
                if (threshold.getMaxValue() == null || threshold.getMaxValue().isEmpty()) {
                    if (threshold.isMaxThreshold()) continue;
                    if (param.length() > 0) {
                        param.append(", ");
                    }
                    param.append(threshold.getIndex() + 1);
                    continue;
                }
                if (this.isNumber(threshold.getMaxValue())) continue;
                String message = Messages.error_thresholdValueNotANumber;
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", NLS.bind((String)message, (Object)threshold.getMaxValue()));
            }
            if (param.length() > 0) {
                String message = param.indexOf(",") > 0 ? Messages.error_missingThresholdValuePlural : Messages.error_missingThresholdValue;
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", NLS.bind((String)message, (Object)param.toString()));
            }
        }
        return null;
    }

    private boolean isNumber(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public void updateOptions() {
        if (this.getBindingContextType() == BindOperationType.CREATE) {
            ((GaugeOptions)this.getPatternOptions()).setGaugeType(this.getGaugeType().toString());
        }
        GaugeBindingOptions bindOpts = ((GaugeOptions)this.getPatternOptions()).getBindingOptions();
        bindOpts.setMetricValue(this.getModel().getMetricValue());
        GaugeExtendedProperties extendedProps = ((GaugeOptions)this.getPatternOptions()).getExtendedProperties();
        extendedProps.setMinValueAsString(this.getModel().getMinValue());
        extendedProps.setMaxValueAsString(this.getModel().getMaxValue());
        if (this.getBindingContextType() == BindOperationType.CREATE) {
            this.addBackground(extendedProps);
        }
        this.updateThresholds(extendedProps);
        if (this.getBindingContextType() == BindOperationType.CREATE) {
            this.addOtherChildTagOptions(extendedProps);
        }
        this.updateLabels(extendedProps);
    }

    private void addBackground(GaugeExtendedProperties extendedProps) {
        SpecialEffects se;
        GaugeBackground gb = extendedProps.getGaugeBackground();
        if (gb == null) {
            gb = new GaugeBackground();
            extendedProps.setGaugeBackground(gb);
        }
        if ((se = gb.getSpecialEffects()) == null) {
            se = new SpecialEffects();
            gb.setSpecialEffects(se);
        }
    }

    private void updateThresholds(GaugeExtendedProperties extendedProps) {
        ArrayList<Threshold> thrList;
        List thresholds = this.getModel().getGaugeThresholds();
        if (thresholds == null || thresholds.isEmpty()) {
            return;
        }
        ThresholdSet ts = extendedProps.getThresholdSet();
        if (ts == null) {
            ts = new ThresholdSet();
            extendedProps.setThresholdSet(ts);
        }
        if ((thrList = ts.getThreshold()) == null) {
            thrList = new ArrayList<Threshold>();
        }
        if (thrList.isEmpty()) {
            for (IGaugeThreshold modelThr : thresholds) {
                Threshold thr = new Threshold();
                if (!modelThr.isMaxThreshold()) {
                    thr.setThresholdMaxValueAsString(modelThr.getMaxValue());
                }
                if (modelThr.getText() != null) {
                    thr.setText(modelThr.getText());
                }
                thr.setFillColor(modelThr.getFillColor());
                thrList.add(thr);
            }
        }
        ts.setThreshold(thrList);
    }

    private void addOtherChildTagOptions(GaugeExtendedProperties extendedProps) {
        IndicatorBar indicatorBar;
        if (this.getModel().getGaugeType() == GaugeType.DIAL) {
            IndicatorBase indicatorBase;
            Indicator indicator;
            GaugeFrame gf = extendedProps.getGaugeFrame();
            if (gf == null) {
                gf = new GaugeFrame();
                extendedProps.setGaugeFrame(gf);
            }
            if ((indicator = extendedProps.getIndicator()) == null) {
                indicator = new Indicator();
                extendedProps.setIndicator(indicator);
            }
            if ((indicatorBase = extendedProps.getIndicatorBase()) == null) {
                indicatorBase = new IndicatorBase();
                extendedProps.setIndicatorBase(indicatorBase);
            }
        } else if (this.getModel().getGaugeType() != GaugeType.LED && (indicatorBar = extendedProps.getIndicatorBar()) == null) {
            indicatorBar = new IndicatorBar();
            extendedProps.setIndicatorBar(indicatorBar);
        }
        if (this.getModel().getGaugeType() != GaugeType.LED) {
            TickMark tickMark;
            TickLabel tickLabel;
            GaugePlotArea gpa = extendedProps.getGaugePlotArea();
            if (gpa == null) {
                gpa = new GaugePlotArea();
                extendedProps.setGaugePlotArea(gpa);
            }
            if ((tickLabel = extendedProps.getTickLabel()) == null) {
                tickLabel = new TickLabel();
                extendedProps.setTickLabel(tickLabel);
            }
            if ((tickMark = extendedProps.getTickMark()) == null) {
                tickMark = new TickMark();
                extendedProps.setTickMark(tickMark);
            }
        }
    }

    private void updateLabels(GaugeExtendedProperties extendedProps) {
        IPresentationLayout layout = this.getModel().getPresentationLayout();
        if (this.getBindingContextType() == BindOperationType.CREATE && layout != null) {
            this.updateTopLabel(extendedProps);
            String quickLayout = layout.getQuickLayout();
            if (quickLayout.equals(QUICKLAYOUT_QL1)) {
                this.updateBottomLabel(extendedProps);
                this.updateMetricLabel(extendedProps);
            } else if (quickLayout.equals(QUICKLAYOUT_QL2)) {
                this.updateBottomLabel(extendedProps);
                this.addLegendTitle(extendedProps);
                this.addLegendArea(extendedProps, "LAP_RIGHT");
                this.updateMetricLabel(extendedProps);
            } else if (quickLayout.equals(QUICKLAYOUT_QL3)) {
                this.updateBottomLabel(extendedProps);
                this.updateMetricLabel(extendedProps);
            } else if (quickLayout.equals(QUICKLAYOUT_QL4)) {
                this.updateBottomLabel(extendedProps);
                if (!(layout.getVariationType().equals("DIAL") || layout.getVariationType().equals("STATUSMETER") || layout.getVariationType().equals("VERTICALSTATUSMETER"))) {
                    this.addLegendTitle(extendedProps);
                    this.addLegendArea(extendedProps, "LAP_RIGHT");
                }
                this.updateMetricLabel(extendedProps);
            } else if (quickLayout.equals(QUICKLAYOUT_QL5)) {
                this.updateBottomLabel(extendedProps);
                this.addLegendArea(extendedProps, "LAP_BOTTOM");
                this.updateMetricLabel(extendedProps);
            } else if (quickLayout.equals(QUICKLAYOUT_QL6)) {
                this.updateMetricLabel(extendedProps);
                this.updateBottomLabel(extendedProps);
            }
        } else {
            this.updateBottomLabel(extendedProps);
            this.updateMetricLabel(extendedProps);
        }
    }

    private void updateTopLabel(GaugeExtendedProperties extendedProps) {
        if (this.getModel().showTopLabel()) {
            TopLabel label = extendedProps.getTopLabel();
            if (label == null) {
                label = new TopLabel();
                extendedProps.setTopLabel(label);
            }
            label.setText(this.getModel().getTopLabel() == null || this.getModel().getTopLabel().isEmpty() ? null : this.getModel().getTopLabel());
            label.setPosition(this.getModel().getTopLabelPosition().getType());
        } else {
            extendedProps.setTopLabel(null);
        }
    }

    private void updateBottomLabel(GaugeExtendedProperties extendedProps) {
        if (this.getModel().showBottomLabel()) {
            BottomLabel label = extendedProps.getBottomLabel();
            if (label == null) {
                label = new BottomLabel();
                extendedProps.setBottomLabel(label);
            }
            label.setText(this.getModel().getBottomLabel() == null || this.getModel().getBottomLabel().isEmpty() ? null : this.getModel().getBottomLabel());
            label.setPosition(this.getModel().getBottomLabelPosition().getType());
        } else {
            extendedProps.setBottomLabel(null);
        }
    }

    private void updateMetricLabel(GaugeExtendedProperties extendedProps) {
        if (this.getModel().showMetricLabel()) {
            MetricLabel label = extendedProps.getMetricLabel();
            if (label == null) {
                label = new MetricLabel();
                extendedProps.setMetricLabel(label);
            }
            label.setPosition(this.getModel().getMetricLabelPosition().getType());
        } else {
            extendedProps.setMetricLabel(null);
        }
    }

    private void addLegendTitle(GaugeExtendedProperties extendedProps) {
        GaugeLegendTitle title = extendedProps.getGaugeLegendTitle();
        if (title == null) {
            title = new GaugeLegendTitle();
            title.setText(DVTCreatorBundle.get((String)"GAUGE_LEGEND_TITLE"));
            extendedProps.setGaugeLegendTitle(title);
        }
    }

    private void addLegendArea(GaugeExtendedProperties extendedProps, String position) {
        GaugeLegendArea area = extendedProps.getGaugeLegendArea();
        if (area == null) {
            area = new GaugeLegendArea();
            area.setPosition(position);
            extendedProps.setGaugeLegendArea(area);
        }
    }

    @Override
    public void postProcess(Node node) {
    }

    private static class Messages
    extends NLS {
        public static String error_missingMetricValue;
        public static String error_missingThresholdValue;
        public static String error_missingThresholdValuePlural;
        public static String error_minValueNotANumber;
        public static String error_maxValueNotANumber;
        public static String error_thresholdValueNotANumber;

        static {
            NLS.initializeMessages((String)GaugeOptionsMapper.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

