/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.dvt.binding.pattern.graph.FunnelGraphOptions;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphFootnote;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphSubtitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphTitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendArea;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendTitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.SliceLabel;
import oracle.adfdt.view.dvt.binding.pattern.options.GraphBindingOptions;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsResources;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.ICommonGraphOptions;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FunnelGraphOptionsMapper
extends GraphOptionsMapper<FunnelGraphOptions> {
    private static final String QUICKLAYOUT_FUNNEL2 = "funnel2_all_titles";
    private static final String QUICKLAYOUT_FUNNEL3 = "funnel3_no_sliceLabel";

    public FunnelGraphOptionsMapper(BindOperationType opType, Widget<FunnelGraphOptions> widget, CreatorParams<FunnelGraphOptions> params) {
        super(opType, widget, params);
    }

    @Override
    protected GraphType getType() {
        return GraphType.FUNNEL;
    }

    @Override
    public IStatus validateModel() {
        if (!this.getModel().isNameValuePair()) {
            List edge = this.getModel().getSeriesItemContexts();
            if (edge == null || edge.size() < 2 || edge.get(0) == null || !((EdgeItemContext)edge.get(0)).isNumeric() || ((EdgeItemContext)edge.get(0)).isTreatAsText() || edge.get(1) == null || !((EdgeItemContext)edge.get(1)).isNumeric() || ((EdgeItemContext)edge.get(1)).isTreatAsText()) {
                String message = GraphOptionsResources.funnelGraph_seriesDataError;
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message);
            }
            if (edge.size() != 2) {
                String message = "Program Error: too many data points for funnel series edge";
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message);
            }
            edge = this.getModel().getGroupsItemContexts();
            if (edge.size() == 0) {
                String message = GraphOptionsResources.error_emptyAttribute;
                String param = GraphOptionsResources.funnelGraph_groupsLabel;
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", NLS.bind((String)message, (Object)param));
            }
        }
        return this.getDuplicateValueError();
    }

    protected IStatus getDuplicateValueError() {
        ArrayList allItems = new ArrayList(this.getModel().getGroupsItemContexts());
        allItems.addAll(this.getModel().getSeriesItemContexts());
        HashSet<String> itemSet = new HashSet<String>();
        for (EdgeItemContext item : allItems) {
            if (itemSet.contains(item.getName())) {
                String message = GraphOptionsResources.error_duplicateValue;
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", NLS.bind((String)message, (Object)item.getName()));
            }
            itemSet.add(item.getName());
        }
        return null;
    }

    @Override
    public void updateOptions() {
        IPresentationLayout layout = this.getModel().getPresentationLayout();
        if (this.getBindingContextType() == BindOperationType.CREATE && layout != null) {
            ((FunnelGraphOptions)this.getPatternOptions()).setGraphSubType(layout.getVariationType());
            String quickLayout = layout.getQuickLayout();
            if (quickLayout.equals(QUICKLAYOUT_FUNNEL2)) {
                FunnelGraphOptionsMapper.configureQuickLayout2(this.getCommonGraphOptions());
            } else if (quickLayout.equals(QUICKLAYOUT_FUNNEL3)) {
                FunnelGraphOptionsMapper.configureFunnelQuickLayout3((FunnelGraphOptions)this.getPatternOptions());
            }
        }
        this.update(this.getCommonGraphOptions());
    }

    private static void configureFunnelQuickLayout3(FunnelGraphOptions options) {
        LegendArea legendArea = new LegendArea();
        legendArea.setRendered(false);
        options.getExtendedProperties().setLegendArea(legendArea);
        SliceLabel sliceLabel = new SliceLabel();
        sliceLabel.setRendered(false);
        options.getExtendedProperties().setSliceLabel(sliceLabel);
    }

    @Override
    public void postProcess(Node node) {
        Element graphElement = FunnelGraphOptionsMapper.getSingleBindRoot(node);
        if (graphElement == null || !this.getType().toString().equals(graphElement.getLocalName())) {
            return;
        }
        IPresentationLayout layout = this.getModel().getPresentationLayout();
        if (this.getBindingContextType() == BindOperationType.CREATE && layout != null) {
            FunnelGraphOptionsMapper.addBackgroundTag(graphElement);
            String quickLayout = layout.getQuickLayout();
            if (quickLayout.equals("QL1_default") || quickLayout.equals(QUICKLAYOUT_FUNNEL2)) {
                this.updateLegendAreaAutomaticPlacementAttr(graphElement);
            }
        }
        graphElement.removeAttribute("threeDEffect");
    }

    @Override
    protected ICommonGraphOptions getCommonGraphOptions() {
        return new FunnelGraphOptionsWrapper((FunnelGraphOptions)this.getPatternOptions());
    }

    private class FunnelGraphOptionsWrapper
    implements ICommonGraphOptions {
        private FunnelGraphOptions _graphOptions;

        FunnelGraphOptionsWrapper(FunnelGraphOptions graphOptions) {
            this._graphOptions = graphOptions;
        }

        @Override
        public String getGraphType() {
            return this._graphOptions.getGraphType();
        }

        @Override
        public String getGraphSubType() {
            return this._graphOptions.getGraphSubType();
        }

        @Override
        public void setGraphSubType(String graphSubType) {
            this._graphOptions.setGraphSubType(graphSubType);
        }

        @Override
        public GraphBindingOptions getBindingOptions() {
            return this._graphOptions.getBindingOptions();
        }

        @Override
        public void setRowSelection(boolean rowSelection) {
            this._graphOptions.setRowSelection(rowSelection);
        }

        @Override
        public boolean isRowSelection() {
            return this._graphOptions.isRowSelection();
        }

        @Override
        public void setGraphFootnote(GraphFootnote graphFootnote) {
            this._graphOptions.getExtendedProperties().setGraphFootnote(graphFootnote);
        }

        @Override
        public void setGraphSubtitle(GraphSubtitle graphSubtitle) {
            this._graphOptions.getExtendedProperties().setGraphSubtitle(graphSubtitle);
        }

        @Override
        public void setGraphTitle(GraphTitle graphTitle) {
            this._graphOptions.getExtendedProperties().setGraphTitle(graphTitle);
        }

        @Override
        public void setLegendArea(LegendArea legendArea) {
            this._graphOptions.getExtendedProperties().setLegendArea(legendArea);
        }

        @Override
        public void setLegendTitle(LegendTitle legendTitle) {
            this._graphOptions.getExtendedProperties().setLegendTitle(legendTitle);
        }
    }
}

