/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.TaskFlowWidget;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.ui.Messages;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.webtier.ui.bean.NewManagedBeanDialog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class DynamicRegionBeanPage
extends WizardPage {
    private IWebPageContext context;
    private IWebPageContext.IManagedBean managedBean;
    private org.eclipse.swt.widgets.List beanList;
    private Map<String, IWebPageContext.IManagedBean> managedBeanMap;
    private Map<IWebPageContext.IManagedBean, NewManagedBeanDialog> newManagedBeans;

    public DynamicRegionBeanPage(IWebPageContext context) {
        super("DynamicRegionBeanPage1");
        this.context = context;
    }

    public void dispose() {
        this.context = null;
        this.beanList = null;
        this.managedBean = null;
        if (this.newManagedBeans != null) {
            this.newManagedBeans.clear();
            this.newManagedBeans = null;
        }
        if (this.managedBeanMap != null) {
            this.managedBeanMap.clear();
            this.managedBeanMap = null;
        }
        super.dispose();
    }

    public IWebPageContext.IManagedBean getManagedBean(IProgressMonitor monitor) throws Exception {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)(3 + (this.newManagedBeans != null ? this.newManagedBeans.size() : 0)));
        NewManagedBeanDialog dialog = this.getDialogForManagedBean();
        if (dialog != null) {
            dialog.saveJavaClass(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)3));
        }
        if (this.newManagedBeans != null) {
            for (IWebPageContext.IManagedBean bean : this.newManagedBeans.keySet()) {
                if (DTRTUtil.equals((Object)this.managedBean, (Object)bean)) continue;
                this.context.getManagedBeanManager().removeManagedBean(bean, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
            }
            this.newManagedBeans.clear();
            this.newManagedBeans = null;
        }
        ProgressMonitorUtil.done((IProgressMonitor)monitor);
        return this.managedBean;
    }

    public boolean isNewManagedBean() {
        return this.getDialogForManagedBean() != null;
    }

    private NewManagedBeanDialog getDialogForManagedBean() {
        return this.newManagedBeans != null ? this.newManagedBeans.get(this.managedBean) : null;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.DynamicRegionWizard_beanTitle);
        this.setMessage(Messages.DynamicRegionWizard_beanMessage);
        Composite beanComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(15, 15).numColumns(2).applyTo(beanComposite);
        GridDataFactory topAlignmentFactory = GridDataFactory.swtDefaults().align(1, 128);
        this.beanList = new org.eclipse.swt.widgets.List(beanComposite, 2052);
        DTRTUIUtil.applyGrabAllGridData((Control)this.beanList);
        this.beanList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicRegionBeanPage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.beanList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (DynamicRegionBeanPage.this.beanList.getSelectionIndex() == 0) {
                    DynamicRegionBeanPage.this.addNewManagedBean();
                }
            }
        });
        ToolBar toolBar = new ToolBar(beanComposite, 0x800000);
        toolBar.setBackground(parent.getBackground());
        topAlignmentFactory.applyTo((Control)toolBar);
        ToolItem addBean = new ToolItem(toolBar, 8);
        addBean.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_ADD));
        addBean.setToolTipText(Messages.DynamicRegionWizard_beanAddBeanToolTip);
        addBean.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DynamicRegionBeanPage.this.addNewManagedBean();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        try {
            this.beanList.setItems(this.getSelectableManagedBeanLabels());
            this.beanList.select(0);
        }
        catch (Exception e) {
            DTRTvBundle.log(e);
            this.updateStatus((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", "An error has ocurred while retrieving the beans.", (Throwable)e));
            addBean.setEnabled(false);
        }
        this.setPageComplete(this.managedBean != null);
        this.setControl((Control)beanComposite);
    }

    private void addNewManagedBean() {
        NewManagedBeanDialog.BeanNameValidator beanNameValidator;
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add(Messages.DynamicRegionWizard_beanApplicationScope);
        scopes.add(Messages.DynamicRegionWizard_beanBackingBeanScope);
        scopes.add(Messages.DynamicRegionWizard_beanPageFlowScope);
        scopes.add(Messages.DynamicRegionWizard_beanRequestScope);
        scopes.add(Messages.DynamicRegionWizard_beanSessionScope);
        scopes.add(Messages.DynamicRegionWizard_beanViewScope);
        try {
            beanNameValidator = this.getBeanNameValidator();
        }
        catch (Exception e) {
            DTRTvBundle.log(e);
            this.updateStatus((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", "Unable to create the bean.", (Throwable)e));
            return;
        }
        NewManagedBeanDialog newBeanDialog = new NewManagedBeanDialog(this.beanList.getShell(), scopes, Messages.DynamicRegionWizard_beanViewScope, Messages.DynamicRegionWizard_beanViewScope, false, beanNameValidator, this.context.getWebPageFile().getProject(), false);
        if (newBeanDialog.open() == 0) {
            String beanName = newBeanDialog.getBeanName();
            String beanClassName = newBeanDialog.getBeanClassName();
            IPath beanPath = newBeanDialog.getBeanJavaFilePath();
            try {
                IWebPageContext.IManagedBean managedBean = this.context.getManagedBeanManager().addTaskFlowManagedBean(Variable.SCOPE.ADF_VIEW_SCOPE, beanName, beanClassName, beanPath, null);
                if (this.canBeSelected(managedBean)) {
                    String label = DTRTUtil.getLabel((IDescribable)managedBean);
                    if (this.managedBeanMap == null) {
                        this.managedBeanMap = new HashMap<String, IWebPageContext.IManagedBean>();
                    }
                    this.managedBeanMap.put(label, managedBean);
                    this.beanList.add(label);
                    this.beanList.select(this.beanList.getItemCount() - 1);
                    if (this.newManagedBeans == null) {
                        this.newManagedBeans = new HashMap<IWebPageContext.IManagedBean, NewManagedBeanDialog>();
                    }
                    this.newManagedBeans.put(managedBean, newBeanDialog);
                } else {
                    this.context.getManagedBeanManager().removeManagedBean(managedBean, null);
                }
            }
            catch (Exception e) {
                DTRTvBundle.log(e);
                this.updateStatus((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", "Unable to create the bean.", (Throwable)e));
                return;
            }
            this.validate();
        }
    }

    private void updateStatus(IStatus status) {
        if (status.isOK()) {
            this.beanList.setToolTipText(DTRTUtil.getToolTipText((IDescribable)this.managedBean));
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.beanList.setToolTipText(null);
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        }
    }

    private void validate() {
        if (this.managedBeanMap == null) {
            this.updateStatus((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", "There are no beans to select. You can create one or cancel this operation."));
            return;
        }
        int index = this.beanList.getSelectionIndex();
        if (index == -1) {
            this.updateStatus((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", "Select a bean."));
            return;
        }
        String selected = this.beanList.getItem(index);
        IWebPageContext.IManagedBean iManagedBean = this.managedBean = this.managedBeanMap != null ? this.managedBeanMap.get(selected) : null;
        if (this.managedBean == null) {
            this.updateStatus((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", "Select a bean."));
            return;
        }
        this.updateStatus((IStatus)new Status(0, "oracle.eclipse.tools.adf.dtrt.v120102", null));
    }

    private String[] getSelectableManagedBeanLabels() throws Exception {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(Messages.DynamicRegionWizard_beanEmptyComboItem);
        List<? extends IWebPageContext.IManagedBean> managedBeans = TaskFlowWidget.collectManagedBeans(this.context, null);
        if (!managedBeans.isEmpty()) {
            this.managedBeanMap = new HashMap<String, IWebPageContext.IManagedBean>(managedBeans.size());
            for (IWebPageContext.IManagedBean iManagedBean : managedBeans) {
                String label = DTRTUtil.getLabel((IDescribable)iManagedBean);
                this.managedBeanMap.put(label, iManagedBean);
                if (!this.canBeSelected(iManagedBean)) continue;
                labels.add(label);
            }
        }
        Collections.sort(labels);
        return labels.toArray(new String[labels.size()]);
    }

    private boolean canBeSelected(IWebPageContext.IManagedBean managedBean) {
        return managedBean != null && managedBean.getScope() == Variable.SCOPE.ADF_VIEW_SCOPE && !this.context.getManagedBeanManager().isBoundToTaskFlow(managedBean);
    }

    private NewManagedBeanDialog.BeanNameValidator getBeanNameValidator() throws Exception {
        List exclusionList;
        if (this.managedBeanMap != null && !this.managedBeanMap.isEmpty()) {
            exclusionList = new ArrayList(this.managedBeanMap.size());
            for (IWebPageContext.IManagedBean managedBean : this.managedBeanMap.values()) {
                exclusionList.add(DTRTUtil.getLabel((IDescribable)managedBean));
            }
        } else {
            exclusionList = Collections.emptyList();
        }
        return new NewManagedBeanDialog.BeanNameValidator(exclusionList);
    }
}

