/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.adf.controller.metadata.binding.TaskFlowBinding;
import oracle.eclipse.tools.adf.common.util.ProjectUtils;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.bind.BindCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.IInternalWidget;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.WidgetType;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.BaseObject;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonBundleIcon;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public final class TaskFlowWidget
extends BaseObject<IWebPageContext.ITaskFlowProxy>
implements IInternalWidget {
    private static final IDescriptor DYNAMIC_REGION_LINK_TYPE_DESCRIPTOR = new BaseDescriptor(){

        public String getLabel() {
            return WidgetType.DYNAMIC_REGION_LINK.toString();
        }
    };
    private WidgetType type;
    private IBindingObject taskFlowBinding;
    private IWebPageContext.IBindPosition bindPosition;

    public static boolean hasEL(String string) {
        if (string != null) {
            int index = string.indexOf("#{");
            if (index < 0) {
                index = string.indexOf("${");
            }
            if (index >= 0) {
                return string.indexOf(125, index) > 0;
            }
        }
        return false;
    }

    public static List<TaskFlowWidget> getWidgets(IObjectTranslator translator, IPageDefinition pageDefinition, IWebPageContext.ITaskFlowProxy taskFlow, IWebPageContext.IBindPosition bindPosition) {
        if (taskFlow != null) {
            ArrayList<TaskFlowWidget> widgets = new ArrayList<TaskFlowWidget>(2);
            if (taskFlow.usesPageFragments()) {
                if (!taskFlow.getParameters().isEmpty()) {
                    widgets.add(new TaskFlowWidget(taskFlow, bindPosition, WidgetType.REGION_WITH_PARAMETERS));
                } else {
                    widgets.add(new TaskFlowWidget(taskFlow, bindPosition, WidgetType.REGION));
                }
                widgets.add(new TaskFlowWidget(taskFlow, bindPosition, WidgetType.DYNAMIC_REGION));
                for (Map.Entry<IBindingObject, String> entry : TaskFlowWidget.getTaskFlowIdByDynamicTaskFlowBindingMap(translator, pageDefinition).entrySet()) {
                    IBindingObject key = entry.getKey();
                    String[] parseTaskFlowIdEL = TaskFlowWidget.parseTaskFlowIdEL(translator, key);
                    if (parseTaskFlowIdEL != null && parseTaskFlowIdEL.length > 2) {
                        widgets.add(new TaskFlowWidget(taskFlow, bindPosition, key, String.format(Messages.TaskFlowWidget_ForTaskFlowBinding_StringFormatTwoArgs, key.getId(), parseTaskFlowIdEL[1])));
                        continue;
                    }
                    widgets.add(new TaskFlowWidget(taskFlow, bindPosition, WidgetType.DYNAMIC_REGION_LINK));
                }
            } else {
                widgets.add(new TaskFlowWidget(taskFlow, bindPosition, WidgetType.TASK_FLOW_CALL_BUTTON));
                widgets.add(new TaskFlowWidget(taskFlow, bindPosition, WidgetType.TASK_FLOW_CALL_LINK));
            }
            if (!widgets.isEmpty()) {
                return Collections.unmodifiableList(widgets);
            }
        }
        return Collections.emptyList();
    }

    public static String getWebProjectRelativePath(IResource resource) {
        IPath path = ProjectUtils.computeWebContentRelativePath((IResource)resource);
        String aux = path.toString();
        assert (aux != null);
        assert (aux.length() > 0);
        assert (aux.charAt(0) == '/') : aux;
        return aux;
    }

    public static Map<String, String> collectTaskFlowBindNames(IObjectTranslator translator, IPageDefinition pageDefinition) {
        Collection<String> taskFlowIds = TaskFlowWidget.getTaskFlowIdByDynamicTaskFlowBindingMap(translator, pageDefinition).values();
        if (!taskFlowIds.isEmpty()) {
            HashMap<String, String> map = new HashMap<String, String>(taskFlowIds.size());
            for (String taskFlowId : taskFlowIds) {
                String[] parsed = TaskFlowWidget.parseTaskFlowIdEL(taskFlowId);
                if (parsed == null) continue;
                map.put(parsed[1], parsed[2]);
            }
            if (!map.isEmpty()) {
                return Collections.unmodifiableMap(map);
            }
        }
        return Collections.emptyMap();
    }

    public static List<? extends IWebPageContext.IManagedBean> collectManagedBeans(IWebPageContext context, IProgressMonitor monitor) throws Exception {
        Map<String, String> taskFlowBindNameByManagedBeanName = TaskFlowWidget.collectTaskFlowBindNames(OEPEContextImpl.getTranslator((IOEPEContext)context), context.getPageDefinition());
        return context.getManagedBeanManager().collectManagedBeans(taskFlowBindNameByManagedBeanName, monitor);
    }

    public static String[] parseTaskFlowIdEL(IObjectTranslator translator, IBindingObject bindingObject) {
        return TaskFlowWidget.parseTaskFlowIdEL(TaskFlowWidget.getELTaskFlowId(translator, bindingObject));
    }

    private static String[] parseTaskFlowIdEL(String taskFlowId) {
        if (taskFlowId != null) {
            int sanityCheckIndex;
            int elEndIndex;
            int elStartIndex = taskFlowId.indexOf("${");
            if (elStartIndex < 0) {
                elStartIndex = taskFlowId.indexOf("#{");
            }
            if (elStartIndex >= 0 && (elEndIndex = taskFlowId.indexOf(125, elStartIndex)) > elStartIndex + 3 && ((sanityCheckIndex = taskFlowId.indexOf(123, elStartIndex += 2)) < 0 || sanityCheckIndex > elEndIndex)) {
                int managedBeanIndex;
                String[] parsed = new String[3];
                int scopeIndex = taskFlowId.indexOf("Scope.", elStartIndex);
                if (scopeIndex > elStartIndex) {
                    parsed[0] = taskFlowId.substring(elStartIndex, scopeIndex);
                    managedBeanIndex = scopeIndex + "Scope.".length();
                } else {
                    managedBeanIndex = elStartIndex;
                }
                int bindNameSeparatorIndex = taskFlowId.indexOf(46, managedBeanIndex);
                if (managedBeanIndex < bindNameSeparatorIndex && bindNameSeparatorIndex < elEndIndex - 1) {
                    parsed[1] = taskFlowId.substring(managedBeanIndex, bindNameSeparatorIndex);
                    parsed[2] = taskFlowId.substring(bindNameSeparatorIndex + 1, elEndIndex);
                }
                if (parsed[1] != null) {
                    return parsed;
                }
            }
        }
        return null;
    }

    private static Map<IBindingObject, String> getTaskFlowIdByDynamicTaskFlowBindingMap(IObjectTranslator translator, IPageDefinition pageDefinition) {
        LinkedHashMap<IBindingObject, String> map = new LinkedHashMap<IBindingObject, String>();
        for (IBindingObject bindingObject : DTRTObjectUtil.getBindingObjects((IPageDefinition)pageDefinition)) {
            String taskFlowId = TaskFlowWidget.getELTaskFlowId(translator, bindingObject);
            if (taskFlowId == null) continue;
            map.put(bindingObject, taskFlowId);
        }
        return map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }

    private static String getELTaskFlowId(IObjectTranslator translator, IBindingObject bindingObject) {
        String taskFlowId;
        Object element;
        if (translator != null && bindingObject != null && (element = translator.toADFObject((IObject)bindingObject)) instanceof TaskFlowBinding && TaskFlowWidget.hasEL(taskFlowId = ((TaskFlowBinding)element).getTaskFlowId())) {
            return taskFlowId;
        }
        return null;
    }

    private TaskFlowWidget(IWebPageContext.ITaskFlowProxy decoratedObject, IWebPageContext.IBindPosition bindPosition, WidgetType type, String label) {
        super((Object)decoratedObject, label);
        if (decoratedObject.getTaskFlowId() == null) {
            throw new IllegalArgumentException("The task flow id cannot be null");
        }
        if (decoratedObject.getTaskFlowFile() == null) {
            throw new IllegalArgumentException("The task flow file cannot be null");
        }
        this.bindPosition = bindPosition;
        this.type = type;
    }

    private static String createLabel(IWebPageContext.ITaskFlowProxy decoratedObject, WidgetType type) {
        if (type == WidgetType.DYNAMIC_REGION_LINK) {
            String taskFlowId = decoratedObject.getTaskFlowId();
            if (taskFlowId == null) {
                taskFlowId = type.toString();
            }
            return taskFlowId;
        }
        return type.toString();
    }

    private TaskFlowWidget(IWebPageContext.ITaskFlowProxy decoratedObject, IWebPageContext.IBindPosition bindPosition, IBindingObject taskFlowBinding, String dynamicTaskFlowIdEL) {
        this(decoratedObject, bindPosition, WidgetType.DYNAMIC_REGION_LINK, dynamicTaskFlowIdEL);
        this.taskFlowBinding = taskFlowBinding;
    }

    private TaskFlowWidget(IWebPageContext.ITaskFlowProxy taskFlow, IWebPageContext.IBindPosition bindPosition, WidgetType type) {
        this(taskFlow, bindPosition, type, TaskFlowWidget.createLabel(taskFlow, type));
    }

    public void dispose() {
        this.bindPosition = null;
        super.dispose();
    }

    protected URI computeURI() {
        return this.type == WidgetType.DYNAMIC_REGION_LINK ? DTRTvCommonUtil.createWidgetURI((Object[])new Object[]{((IWebPageContext.ITaskFlowProxy)this.getDecoratedObject()).getTaskFlowFile(), ((IWebPageContext.ITaskFlowProxy)this.getDecoratedObject()).getTaskFlowId(), this.type.name(), this.taskFlowBinding.getId()}) : DTRTvCommonUtil.createWidgetURI((Object[])new Object[]{((IWebPageContext.ITaskFlowProxy)this.getDecoratedObject()).getTaskFlowFile(), ((IWebPageContext.ITaskFlowProxy)this.getDecoratedObject()).getTaskFlowId(), this.type.name()});
    }

    public boolean isDeleted() {
        return false;
    }

    public IWebPageContext.ITaskFlowProxy forObject() {
        return (IWebPageContext.ITaskFlowProxy)this.getDecoratedObject();
    }

    @Override
    public IWebPageContext.IBindPosition getBindPosition() {
        return this.bindPosition;
    }

    @Override
    public Node getNodeToBind() {
        throw new UnsupportedOperationException("No support to bind/rebind/edit a task flow binding");
    }

    @Override
    public BindOperationType getBindOperationType() {
        return BindOperationType.CREATE;
    }

    public WidgetType getType() {
        return this.type;
    }

    public IObject getParent() {
        return null;
    }

    public String getId() {
        return this.type == WidgetType.DYNAMIC_REGION_LINK ? String.valueOf(this.type.name()) + '_' + this.taskFlowBinding.getId() : this.type.name();
    }

    public IDescriptor getTypeDescriptor() {
        return this.type == WidgetType.DYNAMIC_REGION_LINK ? DYNAMIC_REGION_LINK_TYPE_DESCRIPTOR : null;
    }

    public ImageManager.IImageData getImageData() {
        return this.type == WidgetType.DYNAMIC_REGION_LINK ? DTRTvCommonBundleIcon.LINK : DTRTBundleIcon.WEB_PAGE;
    }

    public IBindingObject getBindingObject() {
        return this.taskFlowBinding;
    }

    public Map<String, ?> collectUserInput(BindCommand command) throws Exception {
        HashMap<String, Object> userInput = new HashMap<String, Object>();
        if (!this.type.collectUserInput(command, this, userInput).isOK()) {
            command.getCommandStack().getManagedBeanManager().reset();
            throw new InterruptedException();
        }
        return userInput;
    }

    public IBindingObject createBindingObject(IWebPageContext context, Map<String, Object> executionParameters, IProgressMonitor progressMonitor) throws Exception {
        if (!OEPEContextImpl.isPerformingOperation((IOEPEContext)context)) {
            throw new IllegalStateException("Only commands should create binding objects.");
        }
        return this.type.createBindingObject(context, this.forObject(), executionParameters);
    }

    public DocumentFragment createDocumentFragment(IWebPageContext context, Document document, IBindingObject bindingObject, Map<String, Object> executionParameters, IProgressMonitor progressMonitor) throws Exception {
        if (!OEPEContextImpl.isPerformingOperation((IOEPEContext)context)) {
            throw new IllegalStateException("Only commands should modify objects.");
        }
        if (this.taskFlowBinding != null) {
            assert (bindingObject == null);
            bindingObject = this.taskFlowBinding;
        }
        return this.type.createDocumentFragment(context, document, this.forObject(), bindingObject, executionParameters);
    }

    public int hashCode() {
        return this.baseObjectHashCode();
    }

    public boolean equals(Object obj) {
        return this.baseObjectEquals(obj);
    }
}

