/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.object;

import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonUtil;
import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;

public class DataControlJavaTypeResolver {
    private IOEPEContext context;
    private IProject classLoadProject;

    public DataControlJavaTypeResolver(IOEPEContext context) {
        this.context = context;
    }

    public DataControlJavaTypeResolver(IOEPEContext context, IProject classLoadProject) {
        this.context = context;
        this.classLoadProject = classLoadProject;
    }

    public Class<?> resolve(NamedDefinition namedDefinition) {
        switch (namedDefinition.getDefinitionType()) {
            case 30: {
                AttributeDefinition attribute = (AttributeDefinition)namedDefinition;
                return this.classOrNull(attribute.getJavaTypeString());
            }
            case 40: {
                AccessorDefinition accessor = (AccessorDefinition)namedDefinition;
                if (accessor.isCollection()) {
                    if (accessor.isScalarCollection()) {
                        String javaTypeString = accessor.getJavaTypeString();
                        return this.classOrNull(javaTypeString);
                    }
                    return null;
                }
                StructureDefinition structure = accessor.getStructure();
                if (structure == null) break;
                String fullName = structure.getFullName();
                return this.classOrNull(fullName);
            }
        }
        return null;
    }

    private Class<?> classOrNull(String javaTypeString) {
        if (javaTypeString == null) {
            return null;
        }
        IAppClassLoaderProvider.IClassLoader classLoader = this.getClassLoader();
        if (classLoader != null) {
            try {
                Class clazz = classLoader.loadClass(javaTypeString);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                if (Platform.inDebugMode()) {
                    DTRTvBundle.log(e);
                }
            }
            catch (UnsupportedClassVersionError e) {
                if (Platform.inDebugMode()) {
                    DTRTvBundle.log(e);
                }
            }
            finally {
                classLoader.close();
            }
        }
        return null;
    }

    private IAppClassLoaderProvider.IClassLoader getClassLoader() {
        if (this.classLoadProject != null) {
            return DTRTvCommonUtil.getClassLoader((IResource)this.classLoadProject);
        }
        IDTRTManager manager = DTRTvContextUtil.getManager(this.context);
        if (manager != null) {
            return DTRTvCommonUtil.getClassLoader((IResource)manager.getProject());
        }
        return null;
    }

    public Class<?> resolveCollectionBaseType(NamedDefinition namedDefinition) {
        if (namedDefinition != null) {
            switch (namedDefinition.getDefinitionType()) {
                case 40: {
                    AccessorDefinition accessor = (AccessorDefinition)namedDefinition;
                    if (!accessor.isCollection()) break;
                    if (accessor.isScalarCollection()) {
                        Definition find = accessor.getStructure().getAttributeDefinitions().find("element");
                        if (!(find instanceof AttributeDefinition)) break;
                        String javaTypeString = ((AttributeDefinition)find).getJavaTypeString();
                        return this.classOrNull(javaTypeString);
                    }
                    StructureDefinition structure = accessor.getStructure();
                    if (structure == null) break;
                    String fullName = structure.getFullName();
                    return this.classOrNull(fullName);
                }
            }
        }
        return null;
    }
}

