/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef;

import java.util.Hashtable;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.DataControlDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.binding.meta.VariableDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.PDefViewObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.ViewAttribute;

public final class ViewAttributeDefinition
implements AttributeDefinition {
    private ViewAttribute viewAttribute;
    private StructureDefinition definitionParent;
    private Hashtable<Object, Object> properties;

    public static ViewAttributeDefinition createChildViewAttributeDefinition(StructureDefinition definitionParent, ViewAttribute viewAttribute) {
        if (viewAttribute != null) {
            if (!(definitionParent instanceof StructureDef)) {
                throw new IllegalArgumentException("Unsupported definitionParent: " + definitionParent);
            }
            ViewAttributeDefinition viewAttributeDefinition = new ViewAttributeDefinition(definitionParent, viewAttribute);
            ((StructureDef)definitionParent).addAttribute((AttributeDefinition)viewAttributeDefinition);
            return viewAttributeDefinition;
        }
        return null;
    }

    private ViewAttributeDefinition(StructureDefinition definitionParent, ViewAttribute viewAttribute) {
        if (definitionParent == null) {
            throw new IllegalArgumentException("definitionParent cannot be null");
        }
        if (viewAttribute == null) {
            throw new IllegalArgumentException("viewAttribute cannot be null");
        }
        this.definitionParent = definitionParent;
        this.viewAttribute = viewAttribute;
        PDefViewObject.markAsExtrinsic((NamedDefinition)this);
    }

    public Definition getDefinitionParent() {
        return this.definitionParent;
    }

    public ViewAttribute getViewAttribute() {
        return this.viewAttribute;
    }

    public DataControlDefinition getDataControlDefinition() {
        Definition parent = this.getDefinitionParent();
        if (parent != null) {
            int type = parent.getDefinitionType();
            switch (type) {
                case 30: 
                case 40: 
                case 70: 
                case 80: 
                case 100: {
                    return ((VariableDefinition)parent).getDataControlDefinition();
                }
                case 20: {
                    return ((StructureDefinition)parent).getDataControlDefinition();
                }
                case 60: {
                    return ((OperationDefinition)parent).getDataControlDefinition();
                }
                case 50: {
                    return (DataControlDefinition)parent;
                }
            }
        }
        return null;
    }

    public int getDefinitionType() {
        return 30;
    }

    public String getName() {
        return this.viewAttribute.getName();
    }

    public String getFullName() {
        return this.viewAttribute.getFullName();
    }

    public boolean isReadOnly() {
        return this.viewAttribute.isReadOnly();
    }

    public boolean isKey() {
        return this.viewAttribute.isKey();
    }

    public String getJavaTypeString() {
        return this.viewAttribute.getType();
    }

    public String getSourceTypeString() {
        String type = this.viewAttribute.getSQLType();
        return type != null ? type : this.getJavaTypeString();
    }

    public Hashtable getProperties() {
        return this.properties == null ? (this.properties = new Hashtable()) : this.properties;
    }

    public Object getProperty(String propertyName) {
        return this.properties != null ? this.properties.get(propertyName) : null;
    }
}

