/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef;

import java.util.ArrayList;
import java.util.List;
import oracle.adfdt.model.objects.DomIterableFactory;
import oracle.adfdt.transaction.FetchingTask;
import oracle.binding.meta.NamedDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.JavaUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.DTRTBaseElementObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.BaseAttribute;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.ListBinding;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.PDefAttribute;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.ViewAccessor;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.ViewAttribute;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.ViewAttributeDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.ViewObjectUtil;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class PDefViewObject
extends DTRTBaseElementObject {
    public static final String ELEMENT_TAG = "PDefViewObject";
    private static final String PROP_EXTRINSIC = "PDefViewObject.isExtrinsic";

    public static boolean isExtrinsic(BaseAttribute attribute) {
        return attribute instanceof ViewAttribute;
    }

    public static boolean isExtrinsic(NamedDefinition namedDefinition) {
        return namedDefinition != null && (namedDefinition instanceof ViewAttributeDefinition || Boolean.TRUE == namedDefinition.getProperty(PROP_EXTRINSIC));
    }

    static void markAsExtrinsic(NamedDefinition namedDefinition) {
        if (namedDefinition != null) {
            namedDefinition.getProperties().put(PROP_EXTRINSIC, Boolean.TRUE);
        }
    }

    public PDefViewObject(IFile file) {
        super(file);
    }

    public String getNameSpaceUrl() {
        return "http://xmlns.oracle.com/bc4j";
    }

    public String getXMLElementTag() {
        return ELEMENT_TAG;
    }

    @Override
    public void setFullName(String fullName) {
        super.setFullName(fullName);
        if (fullName != null) {
            assert (fullName.indexOf(46) > 0) : fullName;
            ViewObjectUtil.XMLAttribute.NAME.setValue(this, JavaUtil.toSimpleName((String)fullName));
        }
    }

    public String getName() {
        return ViewObjectUtil.XMLAttribute.NAME.getValue(this);
    }

    public String getVersion() {
        return this.getAttribute("Version");
    }

    public final BaseAttribute getBaseAttribute(final String name) {
        if (name != null) {
            FetchingTask task = new FetchingTask(){

                public Object run() {
                    for (Element element : DomIterableFactory.elementIterable((Node)PDefViewObject.this.getElement())) {
                        String tagName;
                        if (element.getNamespaceURI() == null || !element.getNamespaceURI().equals(PDefViewObject.this.getNameSpaceUrl()) || !"PDefAttribute".equals(tagName = element.getTagName()) && !"ViewAttribute".equals(tagName) || !name.equals(element.getAttribute(ViewObjectUtil.XMLAttribute.NAME.getName()))) continue;
                        BaseAttribute attribute = tagName.equals("PDefAttribute") ? new PDefAttribute(PDefViewObject.this) : new ViewAttribute(PDefViewObject.this);
                        attribute.initializeFromElement(PDefViewObject.this.getTransactionManager(), element);
                        return attribute;
                    }
                    return null;
                }
            };
            return (BaseAttribute)this.getTransactionManager().fetchUnderReadLock(task);
        }
        return null;
    }

    public final List<? extends ViewAttribute> getExtrinsicAttributes() {
        return this.getAttributes("ViewAttribute");
    }

    private List<? extends BaseAttribute> getAttributes(final String elementTag) {
        FetchingTask task = new FetchingTask(){

            public Object run() {
                ArrayList<PDefAttribute> attributes = new ArrayList<PDefAttribute>();
                for (Element element : DomIterableFactory.elementIterable((Node)PDefViewObject.this.getElement())) {
                    BaseAttribute attribute;
                    if (element.getNamespaceURI() == null || !element.getNamespaceURI().equals(PDefViewObject.this.getNameSpaceUrl())) continue;
                    String tagName = element.getTagName();
                    if (elementTag != null && !elementTag.equals(tagName)) continue;
                    BaseAttribute baseAttribute = tagName.equals("PDefAttribute") ? new PDefAttribute(PDefViewObject.this) : (attribute = tagName.equals("ViewAttribute") ? new ViewAttribute(PDefViewObject.this) : null);
                    if (attribute == null) {
                        throw new IllegalArgumentException("Unknown elementTag: " + elementTag);
                    }
                    attribute.initializeFromElement(PDefViewObject.this.getTransactionManager(), element);
                    attributes.add((PDefAttribute)attribute);
                }
                return DTRTUtil.toUnmodifiablePrunedList(attributes);
            }
        };
        return (List)this.getTransactionManager().fetchUnderReadLock(task);
    }

    public List<String> getListBindingNames() {
        FetchingTask task = new FetchingTask(){

            public Object run() {
                List<? extends Element> list = ViewObjectUtil.basicGetElements(PDefViewObject.this.getElement(), PDefViewObject.this.getNameSpaceUrl(), "ListBinding");
                ArrayList<String> names = new ArrayList<String>(list.size());
                for (Element element : list) {
                    String name = element.getAttribute(ViewObjectUtil.XMLAttribute.NAME.getName());
                    if (DTRTUtil.isEmpty((String)name)) continue;
                    names.add(name);
                }
                return names;
            }
        };
        return (List)this.getTransactionManager().fetchUnderReadLock(task);
    }

    public List<String> getViewAccessorNames() {
        FetchingTask task = new FetchingTask(){

            public Object run() {
                List<? extends Element> list = ViewObjectUtil.basicGetElements(PDefViewObject.this.getElement(), PDefViewObject.this.getNameSpaceUrl(), "ViewAccessor");
                ArrayList<String> names = new ArrayList<String>(list.size());
                for (Element element : list) {
                    String name = element.getAttribute(ViewObjectUtil.XMLAttribute.NAME.getName());
                    if (DTRTUtil.isEmpty((String)name)) continue;
                    names.add(name);
                }
                return names;
            }
        };
        return (List)this.getTransactionManager().fetchUnderReadLock(task);
    }

    public final ListBinding getListBinding(final String name) {
        FetchingTask task = new FetchingTask(){

            public Object run() {
                Element element = ViewObjectUtil.basicGetElement(PDefViewObject.this.getElement(), PDefViewObject.this.getNameSpaceUrl(), "ListBinding", name);
                if (element != null) {
                    ListBinding listBinding = new ListBinding(PDefViewObject.this);
                    listBinding.initializeFromElement(PDefViewObject.this.getTransactionManager(), element);
                    return listBinding;
                }
                return null;
            }
        };
        return (ListBinding)this.getTransactionManager().fetchUnderReadLock(task);
    }

    public final ViewAccessor getViewAccessor(final String name) {
        FetchingTask task = new FetchingTask(){

            public Object run() {
                Element element = ViewObjectUtil.basicGetElement(PDefViewObject.this.getElement(), PDefViewObject.this.getNameSpaceUrl(), "ViewAccessor", name);
                if (element != null) {
                    ViewAccessor viewAccessor = new ViewAccessor(PDefViewObject.this);
                    viewAccessor.initializeFromElement(PDefViewObject.this.getTransactionManager(), element);
                    return viewAccessor;
                }
                return null;
            }
        };
        return (ViewAccessor)this.getTransactionManager().fetchUnderReadLock(task);
    }

    public void handleChange(BaseAttribute baseAttribute) {
        if (this.getElement() != null && baseAttribute != null && baseAttribute.getViewObject() == this && baseAttribute.isEmpty() && baseAttribute.getElement() != null) {
            this.removeChild(baseAttribute.getElement());
        }
    }

    public boolean isEmpty() {
        return !ViewObjectUtil.hasChildElement(this.getElement());
    }

    public void delete() throws Exception {
        IDTRTManager manager = DTRTvUtil.getManager(this);
        if (manager != null) {
            manager.delete((Object)this);
        }
    }

    public final PDefAttribute createPDefAttribute(String name) {
        return ViewObjectUtil.createViewObjectChild(new PDefAttribute(this), name);
    }

    public ListBinding createListBinding(String name) {
        return ViewObjectUtil.createViewObjectChild(new ListBinding(this), name);
    }

    public ViewAccessor createViewAccessor(String name) {
        return ViewObjectUtil.createViewObjectChild(new ViewAccessor(this), name);
    }

    public void remove(ListBinding listBinding) {
        if (this.getElement() != null && listBinding != null && listBinding.getViewObject() == this && listBinding.getElement() != null) {
            this.removeChild(listBinding.getElement());
        }
    }
}

