/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef;

import oracle.adfdt.model.objects.DomIterableFactory;
import oracle.adfdt.transaction.FetchingTask;
import oracle.adfdt.transaction.Task;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.BaseViewObjectChild;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.PDefViewObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.SchemaBasedProperty;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.ViewObjectUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseAttribute
extends BaseViewObjectChild {
    private static final String ELEM_PROPERTIES = "Properties";

    protected BaseAttribute(PDefViewObject parent) {
        super(parent);
    }

    public boolean isEmpty() {
        Element element = this.getElement();
        if (element == null) {
            return true;
        }
        if (!ViewObjectUtil.hasChildElement(element)) {
            int numberOfAttributes = element.getAttributes().getLength();
            return numberOfAttributes == 0 || numberOfAttributes == 1 && this.getName() != null;
        }
        return false;
    }

    public final void setLOVName(String value) {
        ViewObjectUtil.XMLAttribute.LOV_NAME.setValue(this, value);
    }

    public final String getLOVName() {
        return ViewObjectUtil.XMLAttribute.LOV_NAME.getValue(this);
    }

    public final boolean hasSchemaBasedProperties(final SchemaBasedProperty.SchemaBasedPropertyType ... schemaBasedPropertyTypes) {
        FetchingTask task = new FetchingTask(){

            public Object run() {
                Element schemaBasedPropertiesElement = BaseAttribute.this.getSchemaBasedPropertiesElement();
                if (schemaBasedPropertiesElement != null) {
                    for (Element element : DomIterableFactory.elementIterable((Node)schemaBasedPropertiesElement)) {
                        if (element.getNamespaceURI() == null || !element.getNamespaceURI().equals(BaseAttribute.this.getNameSpaceUrl())) continue;
                        if (schemaBasedPropertyTypes == null || schemaBasedPropertyTypes.length == 0) {
                            return true;
                        }
                        SchemaBasedProperty.SchemaBasedPropertyType[] schemaBasedPropertyTypeArray = schemaBasedPropertyTypes;
                        int n = schemaBasedPropertyTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            SchemaBasedProperty.SchemaBasedPropertyType schemaBasedPropertyType = schemaBasedPropertyTypeArray[n2];
                            if (schemaBasedPropertyType.getElementTag().equals(element.getLocalName())) {
                                return true;
                            }
                            ++n2;
                        }
                    }
                }
                return false;
            }
        };
        return (Boolean)this.getTransactionManager().fetchUnderReadLock(task);
    }

    public final SchemaBasedProperty getSchemaBasedProperty(final SchemaBasedProperty.SchemaBasedPropertyType schemaBasedPropertyType) {
        if (schemaBasedPropertyType != null) {
            FetchingTask task = new FetchingTask(){

                public Object run() {
                    return BaseAttribute.this.doGetSchemaBasedProperty(schemaBasedPropertyType);
                }
            };
            return (SchemaBasedProperty)this.getTransactionManager().fetchUnderReadLock(task);
        }
        return null;
    }

    public final SchemaBasedProperty createSchemaBasedProperty(final SchemaBasedProperty.SchemaBasedPropertyType schemaBasedPropertyType) {
        if (schemaBasedPropertyType != null) {
            final SchemaBasedProperty[] ret = new SchemaBasedProperty[1];
            Task task = new Task(){

                public void run() {
                    SchemaBasedProperty schemaBasedProperty = BaseAttribute.this.doGetSchemaBasedProperty(schemaBasedPropertyType);
                    if (schemaBasedProperty == null) {
                        Element schemaBasedPropertiesElement = BaseAttribute.this.getSchemaBasedPropertiesElement();
                        if (schemaBasedPropertiesElement == null) {
                            Element propertiesXMLElement = BaseAttribute.this.getPropertiesXMLElement();
                            if (propertiesXMLElement == null) {
                                propertiesXMLElement = BaseAttribute.this.createAndAddElement(BaseAttribute.this.getNameSpaceUrl(), BaseAttribute.ELEM_PROPERTIES);
                            }
                            schemaBasedPropertiesElement = BaseAttribute.this.getDocument().createElementNS(BaseAttribute.this.getNameSpaceUrl(), "SchemaBasedProperties");
                            propertiesXMLElement.appendChild(schemaBasedPropertiesElement);
                        }
                        Element element = BaseAttribute.this.getDocument().createElementNS(BaseAttribute.this.getNameSpaceUrl(), schemaBasedPropertyType.getElementTag());
                        schemaBasedPropertiesElement.appendChild(element);
                        schemaBasedProperty = new SchemaBasedProperty(BaseAttribute.this);
                        schemaBasedProperty.initializeFromElement(BaseAttribute.this.getTransactionManager(), element);
                        ret[0] = schemaBasedProperty;
                    }
                }
            };
            this.getTransactionManager().runTaskUnderTransaction("createSchemaBasedProperty", task);
            return ret[0];
        }
        return null;
    }

    private SchemaBasedProperty doGetSchemaBasedProperty(SchemaBasedProperty.SchemaBasedPropertyType schemaBasedPropertyType) {
        Element schemaBasedPropertiesElement = this.getSchemaBasedPropertiesElement();
        if (schemaBasedPropertiesElement != null) {
            for (Element element : DomIterableFactory.elementIterable((Node)schemaBasedPropertiesElement)) {
                if (element.getNamespaceURI() == null || !element.getNamespaceURI().equals(this.getNameSpaceUrl()) || !schemaBasedPropertyType.getElementTag().equals(element.getLocalName())) continue;
                SchemaBasedProperty schemaBasedProperty = new SchemaBasedProperty(this);
                schemaBasedProperty.initializeFromElement(this.getTransactionManager(), element);
                return schemaBasedProperty;
            }
        }
        return null;
    }

    private Element getPropertiesXMLElement() {
        return this.findDirectChild(this.getNameSpaceUrl(), ELEM_PROPERTIES);
    }

    private Element getSchemaBasedPropertiesElement() {
        FetchingTask task = new FetchingTask(){

            public Object run() {
                Element propertiesXMLElement = BaseAttribute.this.getPropertiesXMLElement();
                if (propertiesXMLElement != null) {
                    for (Element element : DomIterableFactory.elementIterable((Node)propertiesXMLElement)) {
                        if (!element.getTagName().equals("SchemaBasedProperties") || element.getNamespaceURI() == null || !element.getNamespaceURI().equals(BaseAttribute.this.getNameSpaceUrl())) continue;
                        return element;
                    }
                }
                return null;
            }
        };
        return (Element)this.getTransactionManager().fetchUnderReadLock(task);
    }

    public void removeSchemaBaseProperty(final SchemaBasedProperty.SchemaBasedPropertyType schemaBasedPropertyType) {
        if (schemaBasedPropertyType != null) {
            Task task = new Task(){

                public void run() {
                    Element schemaBasedPropertiesElement = BaseAttribute.this.getSchemaBasedPropertiesElement();
                    if (schemaBasedPropertiesElement != null) {
                        for (Element element : DomIterableFactory.elementIterable((Node)schemaBasedPropertiesElement)) {
                            if (element.getNamespaceURI() == null || !element.getNamespaceURI().equals(BaseAttribute.this.getNameSpaceUrl()) || !schemaBasedPropertyType.getElementTag().equals(element.getLocalName())) continue;
                            Node schemaBasedPropertiesXMLElement = element.getParentNode();
                            if (!$assertionsDisabled && !schemaBasedPropertiesXMLElement.getLocalName().equals("SchemaBasedProperties")) {
                                throw new AssertionError((Object)schemaBasedPropertiesXMLElement.getLocalName());
                            }
                            schemaBasedPropertiesXMLElement.removeChild(element);
                            if (!ViewObjectUtil.hasChildElement(schemaBasedPropertiesXMLElement)) {
                                Node propertiesXMLElement = schemaBasedPropertiesXMLElement.getParentNode();
                                if (!$assertionsDisabled && !propertiesXMLElement.getLocalName().equals(BaseAttribute.ELEM_PROPERTIES)) {
                                    throw new AssertionError((Object)propertiesXMLElement.getLocalName());
                                }
                                propertiesXMLElement.removeChild(schemaBasedPropertiesXMLElement);
                                if (!ViewObjectUtil.hasChildElement(propertiesXMLElement)) {
                                    propertiesXMLElement.getParentNode().removeChild(propertiesXMLElement);
                                }
                            }
                            return;
                        }
                    }
                }
            };
            this.getTransactionManager().runTaskUnderTransaction("removeSchemaBaseProperty", task);
        }
    }
}

