/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl;

import javax.swing.Icon;
import oracle.adf.model.binding.DCDefBase;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.ElementObjectFactory;
import oracle.adfdt.model.objects.Executable;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class UnsupportedElementObjectFactory
implements ElementObjectFactory {
    private final String namespace;

    public UnsupportedElementObjectFactory(String namespace) {
        this.namespace = namespace;
    }

    public String getNameSpaceUrl() {
        return this.namespace;
    }

    public BaseElementObject create(Element element) {
        if (this.isBinding(element)) {
            return new UnsupportedBinding(element.getNodeName());
        }
        if (this.isExecutable(element)) {
            return new UnsupportedExecutable(element.getNodeName());
        }
        return null;
    }

    private boolean isBinding(Element element) {
        return element.getParentNode().getNodeName().equals("bindings");
    }

    private boolean isExecutable(Element element) {
        return element.getParentNode().getNodeName().equals("executables");
    }

    private static class UnsupportedBinding
    extends ControlBinding {
        private String tagName;
        private String id;

        UnsupportedBinding(String tagName) {
            this.tagName = tagName;
        }

        public String getId() {
            if (this.id == null) {
                this.id = super.getId();
                if (this.id == null) {
                    this.id = DTRTvCommonUtil.computeUniqueValue((Document)this.getDocument(), (String)"id", (String)"UnknownBindingId");
                }
            }
            return this.id;
        }

        public String getXMLElementTag() {
            return this.tagName;
        }

        protected DCDefBase createDefInstance() {
            return null;
        }
    }

    private static class UnsupportedExecutable
    extends Executable {
        private String tagName;

        UnsupportedExecutable(String tagName) {
            this.tagName = tagName;
        }

        public String getXMLElementTag() {
            return this.tagName;
        }

        protected String getDefaultDefClassName() {
            return null;
        }

        public Icon getIcon() {
            return null;
        }
    }
}

