/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.util.JavaUtil;
import oracle.eclipse.tools.adf.dtrt.util.SaveSummary;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IManagerListener;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ElementManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.IManagedFile;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonBundleIcon;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

abstract class PersistenceManager
extends ElementManager {
    private ResourceChangeListener resourceChangeListener = new ResourceChangeListener();

    @Override
    public void dispose() {
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
            this.resourceChangeListener = null;
        }
        super.dispose();
    }

    @Override
    public final void addListener(IManagerListener listener) {
        super.addListener(listener);
        if (this.getListeners().size() == 1) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener, 1);
        }
    }

    @Override
    public final void removeListener(IManagerListener listener) {
        super.removeListener(listener);
        if (this.getListeners().isEmpty()) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        }
    }

    @Override
    public final boolean needsSaving() {
        if (!this.getFilesToBeDeleted().isEmpty()) {
            return true;
        }
        ElementManager.ElementManagerVisitor<IFile> visitor = new ElementManager.ElementManagerVisitor<IFile>((ElementManager)this){

            @Override
            protected <E> IFile visit(E element, IManagedFile<E, ?> managedFile, IProgressMonitor monitor) throws InterruptedException {
                return managedFile.needsSaving(element) ? managedFile.getFile() : null;
            }

            @Override
            protected boolean continueVisiting(Collection<IFile> collection) {
                return collection.isEmpty();
            }
        };
        try {
            return !visitor.run(null).isEmpty();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CoreException e) {
            DTRTvBundle.log(e);
        }
        return false;
    }

    @Override
    public IOEPEExecutableContext.ISaveSummary save(IOEPEExecutableContext context, List<? extends IOEPEExecutableContext.IContextSaveParticipant> saveParticipants, IProgressMonitor monitor) throws CoreException, InterruptedException {
        return this.save(context, saveParticipants, null, monitor);
    }

    private <E> IOEPEExecutableContext.ISaveSummary save(IOEPEExecutableContext context, List<? extends IOEPEExecutableContext.IContextSaveParticipant> saveParticipants, Collection<? extends IFile> filter, IProgressMonitor monitor) throws CoreException, InterruptedException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)5);
        ElementManager.ElementManagerVisitor visitor = new ElementManager.ElementManagerVisitor<Pair<E, IManagedFile<E, ?>>>(this){

            @Override
            protected <E1> Pair<E, IManagedFile<E, ?>> visit(E1 element, IManagedFile<E1, ?> managedFile, IProgressMonitor monitor) {
                return managedFile.needsSaving(element) ? new Pair(element, managedFile) : null;
            }
        };
        if (saveParticipants == null) {
            saveParticipants = Collections.emptyList();
        }
        if (!saveParticipants.isEmpty() && context == null) {
            throw new IllegalArgumentException("The context cannot be null if saveParticipants is not empty.");
        }
        Collection<Pair<E, IManagedFile<E, ?>>> collection = visitor.run(filter, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        IOEPEExecutableContext.ISaveSummary saveSummary = this.doSave(context, saveParticipants, collection, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)4));
        ProgressMonitorUtil.done((IProgressMonitor)monitor);
        return saveSummary;
    }

    private <E> IOEPEExecutableContext.ISaveSummary doSave(final IOEPEExecutableContext context, final List<? extends IOEPEExecutableContext.IContextSaveParticipant> saveParticipants, final Collection<Pair<E, IManagedFile<E, ?>>> collection, IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (!(collection.isEmpty() && this.getFilesToBeDeleted().isEmpty() && saveParticipants.isEmpty())) {
            HashSet<IResource> resourcesToLock = new HashSet<IResource>();
            final HashSet<IFile> readOnlyFiles = new HashSet<IFile>(2 + collection.size() / 3);
            final HashMap<IFile, Long> participantResourcesMap = !saveParticipants.isEmpty() ? new HashMap<IFile, Long>() : null;
            for (IOEPEExecutableContext.IContextSaveParticipant iContextSaveParticipant : saveParticipants) {
                for (IResource resource : iContextSaveParticipant.getResources(context)) {
                    if (resource.isAccessible()) {
                        IFile file;
                        if (resource instanceof IFile && (file = (IFile)resource).isReadOnly()) {
                            readOnlyFiles.add(file);
                        }
                        this.markForLock(resourcesToLock, resource, true);
                    } else {
                        this.markForLock(resourcesToLock, resource, false);
                    }
                    if (!(resource instanceof IFile) || participantResourcesMap == null) continue;
                    participantResourcesMap.put((IFile)resource, resource.getModificationStamp());
                }
            }
            for (Pair pair : collection) {
                IFile file = ((IManagedFile)pair.getSecond()).getFile();
                if (file.isAccessible()) {
                    if (file.isReadOnly()) {
                        readOnlyFiles.add(file);
                    }
                    this.markForLock(resourcesToLock, (IResource)file, true);
                    continue;
                }
                this.markForLock(resourcesToLock, (IResource)file, false);
            }
            for (IFile iFile : this.getFilesToBeDeleted()) {
                if (!iFile.isAccessible()) continue;
                if (iFile.isReadOnly()) {
                    readOnlyFiles.add(iFile);
                }
                this.markForLock(resourcesToLock, (IResource)iFile.getParent(), null);
            }
            final IOEPEExecutableContext.ISaveSummary[] iSaveSummaryArray = new IOEPEExecutableContext.ISaveSummary[1];
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ArrayList<IFile> deletedFiles;
                    ArrayList<IFile> changedFiles;
                    ArrayList<IFile> createdFiles;
                    ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)(collection.size() + PersistenceManager.this.getFilesToBeDeleted().size() + 2 * saveParticipants.size()));
                    if (!readOnlyFiles.isEmpty()) {
                        IFile[] files = readOnlyFiles.toArray(new IFile[readOnlyFiles.size()]);
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        IStatus status = workspace.validateEdit(files, IWorkspace.VALIDATE_PROMPT);
                        if (!status.isOK()) {
                            if (ImageManager.getInstance().getImage((ImageManager.IImageData)DTRTvCommonBundleIcon.ACCESSOR_ATTRIBUTE) == null) {
                                MultiStatus readOnlyStatus = new MultiStatus("oracle.eclipse.tools.adf.dtrt.v120102", 0, "One or more files are read-only", null);
                                IFile[] iFileArray = files;
                                int n = files.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IFile file = iFileArray[n2];
                                    readOnlyStatus.add((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", String.format("'%s' is read only", file.getFullPath())));
                                    ++n2;
                                }
                                throw new CoreException((IStatus)readOnlyStatus);
                            }
                            return;
                        }
                    }
                    for (IOEPEExecutableContext.IContextSaveParticipant saveParticipant : saveParticipants) {
                        IWorkspaceRunnable runnable = saveParticipant.getWorkspaceRunnable(context);
                        if (runnable == null) continue;
                        runnable.run(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
                    }
                    if (!collection.isEmpty()) {
                        createdFiles = new ArrayList<IFile>(collection.size());
                        changedFiles = new ArrayList<IFile>(collection.size());
                        for (Pair pair : collection) {
                            Object element = pair.getFirst();
                            IManagedFile managedFile = (IManagedFile)pair.getSecond();
                            IFile file = managedFile.getFile();
                            boolean isAccessibleBeforeSave = file.isAccessible();
                            try {
                                managedFile.save(element, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                                if (!$assertionsDisabled && !file.isAccessible()) {
                                    throw new AssertionError();
                                }
                                if (isAccessibleBeforeSave) {
                                    changedFiles.add(file);
                                } else {
                                    createdFiles.add(file);
                                }
                                if (!PersistenceManager.this.shouldBeSourceFile(element)) continue;
                                JavaUtil.ensureIsSourceFile((IFile)managedFile.getFile(), (String)"adfmsrc");
                            }
                            catch (Exception e) {
                                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", "Failure while saving " + managedFile.getFile().getFullPath(), (Throwable)e));
                            }
                        }
                    } else {
                        createdFiles = null;
                        changedFiles = null;
                    }
                    if (!PersistenceManager.this.getFilesToBeDeleted().isEmpty()) {
                        deletedFiles = new ArrayList<IFile>(PersistenceManager.this.getFilesToBeDeleted().size());
                        Iterator<IFile> i = PersistenceManager.this.getFilesToBeDeleted().iterator();
                        while (i.hasNext()) {
                            IFile file = i.next();
                            if (file.isAccessible()) {
                                try {
                                    file.delete(true, true, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                                    deletedFiles.add(file);
                                }
                                catch (Exception e) {
                                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", "Failure while deleting " + file.getFullPath(), (Throwable)e));
                                }
                            }
                            i.remove();
                        }
                    } else {
                        deletedFiles = null;
                    }
                    if (participantResourcesMap != null) {
                        for (IFile file : participantResourcesMap.keySet()) {
                            long afterTimeStamp;
                            long beforeTimeStamp;
                            if (PersistenceManager.this.contains(createdFiles, changedFiles, deletedFiles, file) || (beforeTimeStamp = ((Long)participantResourcesMap.get(file)).longValue()) == (afterTimeStamp = file.getModificationStamp())) continue;
                            if (afterTimeStamp == -1L) {
                                if (deletedFiles == null) {
                                    deletedFiles = new ArrayList(participantResourcesMap.size());
                                }
                                deletedFiles.add(file);
                                continue;
                            }
                            if (beforeTimeStamp == -1L) {
                                if (createdFiles == null) {
                                    createdFiles = new ArrayList(participantResourcesMap.size());
                                }
                                createdFiles.add(file);
                                continue;
                            }
                            if (changedFiles == null) {
                                changedFiles = new ArrayList(participantResourcesMap.size());
                            }
                            changedFiles.add(file);
                        }
                    }
                    iSaveSummaryArray[0] = new SaveSummary(createdFiles, deletedFiles, changedFiles);
                    ProgressMonitorUtil.done((IProgressMonitor)monitor);
                }
            };
            IProject externalFoldersProject = ResourcesPlugin.getWorkspace().getRoot().getProject(".org.eclipse.jdt.core.external.folders");
            resourcesToLock.add((IResource)externalFoldersProject);
            MultiRule rule = new MultiRule((ISchedulingRule[])resourcesToLock.toArray(new IResource[resourcesToLock.size()]));
            ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)rule, 1, monitor);
            if (iSaveSummaryArray[0] != null) {
                return iSaveSummaryArray[0];
            }
        }
        return new SaveSummary(null, null, null);
    }

    private <T> boolean contains(Collection<? extends T> collection1, Collection<? extends T> collection2, Collection<? extends T> collection3, T element) {
        return collection1 != null && collection1.contains(element) || collection2 != null && collection2.contains(element) || collection3 != null && collection3.contains(element);
    }

    private void markForLock(Set<IResource> resources, IResource resource, Boolean isAccessible) {
        IResource accessibleResource;
        resources.add(resource);
        if (isAccessible != Boolean.TRUE && (accessibleResource = DTRTUtil.getAccessibleResource((IResource)resource)) != null) {
            resources.add(accessibleResource);
        }
    }

    protected abstract boolean manageNewADFmRegistries(IResourceDelta var1);

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta rootDelta;
            if (PersistenceManager.this.getListeners() != null && !PersistenceManager.this.getListeners().isEmpty() && this.isValidDelta(rootDelta = event.getDelta(), false)) {
                IResourceDelta delta;
                Collection<? extends ElementManager.MonitoredStructure> monitoredStructures = PersistenceManager.this.getMonitoredStructures();
                for (ElementManager.MonitoredStructure monitoredStructure : monitoredStructures) {
                    delta = rootDelta.findMember(monitoredStructure.getResource().getFullPath());
                    if (!this.isValidDelta(delta, true)) continue;
                    PersistenceManager.this.handleMonitoredStructureChange();
                    return;
                }
                if (PersistenceManager.this.manageNewADFmRegistries(rootDelta)) {
                    PersistenceManager.this.handleExternalChange();
                    return;
                }
                for (IFile iFile : PersistenceManager.this.getFilesToBeDeleted()) {
                    delta = rootDelta.findMember(iFile.getFullPath());
                    if (!this.isValidDelta(delta, true)) continue;
                    PersistenceManager.this.handleExternalChange();
                    return;
                }
                ElementManager.ElementManagerVisitor<Object> elementManagerVisitor = new ElementManager.ElementManagerVisitor<Object>((ElementManager)PersistenceManager.this){

                    @Override
                    protected <E> Object visit(E element, IManagedFile<E, ?> managedFile, IProgressMonitor monitor) throws InterruptedException, CoreException {
                        IResourceDelta delta;
                        if (managedFile.hasChangedExternally() && ResourceChangeListener.this.isValidDelta(delta = rootDelta.findMember(managedFile.getFile().getFullPath()), true)) {
                            return element;
                        }
                        return null;
                    }

                    @Override
                    protected boolean continueVisiting(Collection<Object> collection) {
                        return collection.isEmpty();
                    }
                };
                try {
                    Collection collection = elementManagerVisitor.run(null);
                    if (!collection.isEmpty()) {
                        PersistenceManager.this.handleExternalChange();
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    DTRTvBundle.log(e);
                }
            }
        }

        private boolean isValidDelta(IResourceDelta delta, boolean checkFlags) {
            return delta != null && delta.getKind() != 0 && delta.getResource() != null && !delta.getResource().isDerived() && (!checkFlags || delta.getKind() == 1 || delta.getKind() == 2 || (delta.getFlags() & 0x100) != 0 || (delta.getFlags() & 0x4000) != 0 || (delta.getFlags() & 0x40000) != 0);
        }
    }
}

