/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl;

import java.beans.PropertyVetoException;
import java.util.Locale;
import java.util.Map;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.model.objects.Application;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.adfdt.model.objects.PageDefinitionUsage;
import oracle.eclipse.tools.adf.common.util.ProjectUtils;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.DTRTManagerImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DefaultPrefixLookup;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.MetadataProvidedDefaultPrefixLookup;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.NamespaceUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class ADFDesignTimeContextImpl
implements ADFDesignTimeContext {
    private DTRTManagerImpl manager;

    public ADFDesignTimeContextImpl(DTRTManagerImpl manager) {
        this.manager = manager;
    }

    public void dispose() {
        this.manager = null;
    }

    public Document getViewDocument() {
        return this.manager.getWebPageDocument();
    }

    public PageDefinition findAndCachePageDefinition() {
        return this.findPageDefinition();
    }

    public PageDefinition findPageDefinition() {
        Application application = this.manager.getApplication(false);
        return this.manager.getPageDefinition(application, false);
    }

    public PageDefinition findOrCreatePageDefinition(PageDefinitionUsage pdUsage) {
        return pdUsage.findOrCreatePageDefinition();
    }

    public PageDefinition findOrCreatePageDefinition() {
        Application application = this.manager.getApplication(true);
        return this.manager.getPageDefinition(application, true);
    }

    public PageDefinitionUsage findOrCreatePageDefinitionUsage(Application application) {
        String viewPath = this.getNormalizedPagePath();
        if (viewPath == null) {
            throw new IllegalStateException("Web page file is not set correctly in the context");
        }
        String usageId = application.findPageMapEntry(viewPath);
        if (usageId != null) {
            return application.findPageDefinitionUsage(usageId);
        }
        try {
            PageDefinitionUsage usage = application.createPageDefinitionUsage();
            usage.setId(DTRTvUtil.computePageDefinitionUsageId(application, true));
            usage.setPath(this.manager.computeUniquePageDefinitionFullName());
            application.addPageDefinitionUsage(usage);
            application.addPageMapEntry(viewPath, usage.getId());
            return usage;
        }
        catch (PropertyVetoException e) {
            DTRTvBundle.log(e);
            return null;
        }
    }

    public Application findOrCreateApplication() {
        return this.manager.getApplication(true);
    }

    public void prepareAppendElement(Element root, Element subtree) {
        NamespaceUtils.fixPrefixes((Node)root, (Node)subtree, (DefaultPrefixLookup)new MetadataProvidedDefaultPrefixLookup(this.manager.getProject()), (boolean)true);
    }

    public String getNormalizedPagePath() {
        IPath path;
        IFile file;
        IPageDefinition.IBoundSource boundSource = this.manager.getBoundSource();
        if (boundSource != null && (file = boundSource.getFile()) != null && (path = ProjectUtils.computeWebContentRelativePath((IResource)file)) != null) {
            return path.toString();
        }
        return null;
    }

    public Object getEnvironmentContext() {
        return this.manager;
    }

    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public DocumentFragment parseDocumentFragment(Map namespaces, String text) {
        Document document = this.getViewDocument();
        if (document == null) {
            throw new IllegalStateException("The view document is not set");
        }
        return DTRTvCommonUtil.createDocumentFragment((Document)document, (Map)namespaces, (String)text);
    }

    public String generateUniqueIdForView(String baseId) {
        return DTRTvCommonUtil.computeUniqueValue((Document)this.getViewDocument(), (String)"id", (String)baseId);
    }

    public boolean launchBindingEditor(ControlBinding binding) {
        throw new UnsupportedOperationException();
    }

    public void setupEnvironmentForView() {
    }

    public void setupApplication(Application application) {
    }

    public void setupEnvironmentForADFModelController() {
    }

    public void setupEnvironmentForDataControl(DataControl control) {
    }
}

