/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.facade.estore;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import oracle.adf.controller.ControllerException;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.EMFObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.estore.ExceptionHandler;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.estore.ImplicitTypeConverter;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.estore.OepeExtendedMetadata;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.estore.PropertyGetter;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.estore.PropertySetter;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.estore.ReadResult;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.meta.DecoratingObject;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class EStoreDtrtBindingAdapter {
    private final EMFObjectTranslator factory;
    private final InternalEObject.EStore estore;
    private final ExceptionHandler excpHandler;
    private final ExtendedMetaData emfExtendedMetaData;
    private final OepeExtendedMetadata oepeExtendedMetadata = OepeExtendedMetadata.INSTANCE;
    private final ImplicitTypeConverter implicitConverter = new ImplicitTypeConverter();
    private final PropertyGetter propertyGetter = new PropertyGetter();
    private final PropertySetter propertySetter = new PropertySetter();

    public EStoreDtrtBindingAdapter(EMFObjectTranslator factory, InternalEObject.EStore estore, ExceptionHandler exceptionHandler, ExtendedMetaData emfExtendedMetaData) {
        this.factory = factory;
        this.estore = estore;
        this.excpHandler = exceptionHandler;
        this.emfExtendedMetaData = emfExtendedMetaData;
    }

    public ReadResult getFeature(DecoratingObject object, EStructuralFeature feature, int index) {
        Object dtrtBaseObject = this.adaptEObject(object);
        if (!feature.isMany()) {
            long curTime = System.nanoTime();
            ReadResult singleValueFeature = this.getSingleValueFeature(object, dtrtBaseObject, feature);
            if (DTRTvBundle.isTraceOptionEnabled(DTRTvBundle.OPTIONS.ESTORE_TRACE)) {
                System.out.printf("Time in getFeature for %s on %s: %d ns\n", feature.getName(), object.getClass().getName(), System.nanoTime() - curTime);
            }
            return singleValueFeature;
        }
        return this.getMultiValueFeature(object, dtrtBaseObject, feature, index);
    }

    private ReadResult getMultiValueFeature(DecoratingObject object, Object dtrtBaseObject, EStructuralFeature feature, int index) {
        EStructuralFeature actualFeature = this.oepeExtendedMetadata.getDerivedFeature(feature);
        if (feature.getEType() instanceof EClass) {
            return this.getMultiValueReference(object, dtrtBaseObject, feature, actualFeature, index);
        }
        return this.getMultiValueAttribute(object, dtrtBaseObject, feature, actualFeature, index);
    }

    private ReadResult getMultiValueAttribute(DecoratingObject object, Object dtrtBaseObject, EStructuralFeature feature, EStructuralFeature actualFeature, int index) {
        Method readMethod = this.propertyGetter.getReadMethod(dtrtBaseObject, actualFeature);
        try {
            Object value = readMethod.invoke(dtrtBaseObject, null);
            if (feature != actualFeature) {
                value = this.tryConvertToTargetFeature(feature, actualFeature, object, value);
            }
            if (value instanceof Object[]) {
                throw new IllegalArgumentException();
            }
            if (value instanceof List) {
                BasicEList newObject = new BasicEList(((List)value).size());
                for (Object listValue : (List)value) {
                    newObject.add(listValue);
                }
                if (index == -1) {
                    return ReadResult.create(newObject, ReadResult.SetStatus.SET_VALID);
                }
                return ReadResult.create(newObject.get(index), ReadResult.SetStatus.SET_VALID);
            }
            if (value == null) {
                return ReadResult.create(null, ReadResult.SetStatus.UNSET);
            }
        }
        catch (IllegalArgumentException e) {
            this.defaultHandleException(e);
        }
        catch (IllegalAccessException e) {
            this.defaultHandleException(e);
        }
        catch (InvocationTargetException e) {
            this.defaultHandleException(e);
        }
        throw new IllegalStateException();
    }

    private ReadResult getMultiValueReference(DecoratingObject object, Object dtrtBaseObject, EStructuralFeature feature, EStructuralFeature actualFeature, int index) {
        try {
            Object value = this.propertyGetter.getProperty(object, actualFeature, dtrtBaseObject);
            if (feature != actualFeature) {
                value = this.tryConvertToTargetFeature(feature, actualFeature, object, value);
            }
            if (value instanceof Object[]) {
                throw new IllegalArgumentException();
            }
            if (value instanceof List) {
                if (!this.oepeExtendedMetadata.isSyntheticReference(actualFeature)) {
                    BasicEList newObject = new BasicEList(((List)value).size());
                    for (Object listValue : (List)value) {
                        EStoreEObjectImpl baseObject = (EStoreEObjectImpl)this.factory.create(object, listValue);
                        if (baseObject == null) continue;
                        baseObject.eSetStore(this.estore);
                        newObject.add((Object)baseObject);
                    }
                    value = newObject;
                }
                if (index == -1) {
                    return ReadResult.create(value, ReadResult.SetStatus.SET_VALID);
                }
                return ReadResult.create(((List)value).get(index), ReadResult.SetStatus.SET_VALID);
            }
            if (value == null) {
                return ReadResult.create(null, ReadResult.SetStatus.UNSET);
            }
        }
        catch (IllegalArgumentException e) {
            this.defaultHandleException(e);
        }
        catch (IllegalAccessException e) {
            this.defaultHandleException(e);
        }
        catch (InvocationTargetException e) {
            this.defaultHandleException(e);
        }
        throw new IllegalStateException();
    }

    private Object adaptEObject(DecoratingObject boundNode) {
        Object dtrtBaseObject = boundNode.getDecoratedObject();
        return dtrtBaseObject;
    }

    private ReadResult getSingleValueFeature(DecoratingObject baseObject, Object boundNode, EStructuralFeature feature) {
        EStructuralFeature actualFeature = this.oepeExtendedMetadata.getDerivedFeature(feature);
        if (feature.getEType() instanceof EClass) {
            return this.getSingleValueReference(baseObject, boundNode, feature, actualFeature);
        }
        return this.getSingleValueAttribute(baseObject, boundNode, feature, actualFeature);
    }

    private ReadResult getSingleValueReference(DecoratingObject baseObj, Object boundNode, EStructuralFeature feature, EStructuralFeature actualFeature) {
        try {
            boolean syntheticReference;
            Object value = this.propertyGetter.getProperty(baseObj, actualFeature, boundNode);
            if (feature != actualFeature) {
                value = this.tryConvertToTargetFeature(feature, actualFeature, baseObj, value);
            }
            if (!(syntheticReference = OepeExtendedMetadata.INSTANCE.isSyntheticReference(feature))) {
                value = this.factory.create(baseObj, value);
            }
            ReadResult.SetStatus status = ReadResult.SetStatus.UNSET;
            if (value != null) {
                if (!syntheticReference && value instanceof EStoreEObjectImpl) {
                    ((EStoreEObjectImpl)value).eSetStore(this.estore);
                }
                status = ReadResult.SetStatus.SET_VALID;
            }
            return ReadResult.create(value, status);
        }
        catch (IllegalArgumentException e) {
            this.defaultHandleException(e);
        }
        catch (IllegalAccessException e) {
            this.defaultHandleException(e);
        }
        catch (InvocationTargetException e) {
            this.defaultHandleException(e);
        }
        throw new IllegalStateException();
    }

    private ReadResult getSingleValueAttribute(DecoratingObject baseObject, Object boundNode, EStructuralFeature feature, EStructuralFeature actualFeature) {
        try {
            Object value = this.propertyGetter.getProperty(baseObject, actualFeature, boundNode);
            if (feature != actualFeature) {
                value = this.tryConvertToTargetFeature(feature, actualFeature, baseObject, value);
            }
            ReadResult.SetStatus status = ReadResult.SetStatus.SET_VALID;
            if (feature.getDefaultValue() == value) {
                status = ReadResult.SetStatus.UNSET;
            }
            ReadResult create = ReadResult.create(value, status);
            return create;
        }
        catch (IllegalArgumentException e) {
            this.defaultHandleException(e);
        }
        catch (IllegalAccessException e) {
            this.defaultHandleException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (boundNode instanceof BaseElementObject && (cause instanceof NumberFormatException || cause instanceof ControllerException)) {
                return this.rawSingleValueAttribute((BaseElementObject)boundNode, feature, cause);
            }
            this.defaultHandleException(e);
        }
        throw new IllegalStateException();
    }

    private Object tryConvertToTargetFeature(EStructuralFeature feature, EStructuralFeature actualFeature, DecoratingObject sourceObject, Object value) {
        return this.implicitConverter.convert(feature, actualFeature, sourceObject, value);
    }

    private ReadResult rawSingleValueAttribute(BaseElementObject boundNode, EStructuralFeature feature, Throwable cause) {
        String attrName = this.guessAttributeName(feature);
        String attribute = boundNode.getAttribute(attrName);
        if (attribute == null) {
            attrName = String.valueOf(Character.toUpperCase(attrName.charAt(0))) + (attrName.length() > 1 ? attrName.substring(1) : "");
            attribute = boundNode.getAttribute(attrName);
        }
        if (attribute == null || attribute.equals(feature.getDefaultValue())) {
            return ReadResult.create(null, ReadResult.SetStatus.UNSET);
        }
        return ReadResult.create(null, ReadResult.SetStatus.SET_INVALID, this.excpHandler.createStatus(cause), attribute);
    }

    private String guessAttributeName(EStructuralFeature feature) {
        return this.emfExtendedMetaData.getName(feature);
    }

    private void defaultHandleException(Exception e) {
        this.excpHandler.rethrow(e);
    }

    public Object setFeature(DecoratingObject object, EStructuralFeature feature, int index, Object value) {
        Object dtrtBaseObject = this.adaptEObject(object);
        if (!feature.isMany()) {
            return this.setSingleValueFeature(object, dtrtBaseObject, feature, value);
        }
        throw new UnsupportedOperationException();
    }

    private Object setSingleValueFeature(DecoratingObject baseObject, Object object, EStructuralFeature feature, Object value) {
        ReadResult oldValue = this.getSingleValueFeature(baseObject, object, feature);
        EStructuralFeature actualFeature = this.oepeExtendedMetadata.getDerivedFeature(feature);
        try {
            Object maybeConvertedValue = value;
            if (feature != actualFeature) {
                maybeConvertedValue = this.tryConvertToTargetFeature(actualFeature, feature, baseObject, value);
            }
            this.propertySetter.setProperty(baseObject, object, actualFeature, maybeConvertedValue);
            return oldValue.getValue();
        }
        catch (IllegalArgumentException e) {
            this.defaultHandleException(e);
        }
        catch (IllegalAccessException e) {
            this.defaultHandleException(e);
        }
        catch (InvocationTargetException e) {
            this.defaultHandleException(e);
        }
        throw new IllegalStateException();
    }
}

