/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor.provider;

import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IStructuredTypeObject;
import oracle.eclipse.tools.adf.dtrt.object.IVariableObject;
import oracle.eclipse.tools.adf.dtrt.ui.provider.IObjectContentProviderDelegate;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IVariablesIterator;
import org.eclipse.jface.viewers.Viewer;

public class VariableIteratorContentProvider
implements IObjectContentProviderDelegate {
    private IVariablesIterator rootVariableIterator;

    public void dispose() {
        if (this.rootVariableIterator != null) {
            this.rootVariableIterator = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof IVariablesIterator) {
            this.rootVariableIterator = (IVariablesIterator)newInput;
        } else if (newInput instanceof Collection) {
            Collection collection = (Collection)newInput;
            for (Object o : collection) {
                if (!(o instanceof IVariablesIterator)) continue;
                this.rootVariableIterator = (IVariablesIterator)o;
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        if (this.rootVariableIterator == null) {
            this.inputChanged(null, null, inputElement);
        }
        if (this.rootVariableIterator != null) {
            return new Object[]{this.rootVariableIterator};
        }
        return DTRTUtil.EMPTY_ARRAY;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IVariablesIterator && !((IVariablesIterator)element).getVariableNames().isEmpty() || element instanceof IVariableObject && !((IVariableObject)element).getChildren().isEmpty();
    }

    public Object getParent(Object element) {
        return element != null ? ((IVariableObject)element).getParent() : null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IVariableObject) {
            return ((IVariableObject)parentElement).getChildren().toArray();
        }
        if (parentElement instanceof IVariablesIterator) {
            IStructuredTypeObject structuredTypeObject = ((IVariablesIterator)parentElement).getStructuredTypeObject();
            List children = structuredTypeObject.getChildren();
            return children.toArray();
        }
        return DTRTUtil.EMPTY_ARRAY;
    }

    public IObjectContentProviderDelegate.ProvideType providesForProvideType(Object object) {
        if (object instanceof IVariableObject || object instanceof IVariablesIterator) {
            return IObjectContentProviderDelegate.ProvideType.PROVIDE_VETO;
        }
        if (object instanceof Collection) {
            return IObjectContentProviderDelegate.ProvideType.PROVIDE;
        }
        return IObjectContentProviderDelegate.ProvideType.NO;
    }
}

