/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor;

import java.util.Iterator;
import oracle.adfdt.model.objects.Variable;
import oracle.adfdt.model.objects.VariablesIterator;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.IUndoableRunnableCommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.BaseBindingEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.binding.ErrorTolerantEObjectObservableValue;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.provider.VariableListContentProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.provider.VariablesTableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.EMFObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.SetCommandFactory;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.UndoableRunnableCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ExecutablePackage;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IBaseObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IVariable;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IVariablesIterator;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.RefreshOption;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.command.SelectionOperationHandler;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.EditorLabelMessages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ListBoundComboPropertyEditor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.PropertyEditorFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.SelectionBasedEditorFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.TableFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.TablePropertyEditor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.AbstractAttributeRowEditingSupport;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.EnumLabelProvider;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.TableAttributeEditingSupport;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.viewer.FormTextEditorViewer;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.viewer.PropertyEditorViewer;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.viewer.TablePropertyEditorViewer;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class VariablesIteratorEditor
extends BaseBindingEditor<IVariablesIterator> {
    private PropertyEditorViewer<ListBoundComboPropertyEditor> refreshOptionsCombo;
    private FormTextEditorViewer myIdText;
    private TablePropertyEditorViewer variablesTable;
    private RemoveVariableRunnable removeVariableHandler;

    public VariablesIteratorEditor(IVariablesIterator eObj, IPageDefinitionContext editorContext) {
        super(eObj, editorContext);
    }

    @Override
    protected void refreshUI(ICommand command) {
        super.refreshUI(command);
        ((TablePropertyEditor)this.variablesTable.getPropertyEditor()).getViewer().setInput((Object)this.getContext().getPageDefinition());
    }

    @Override
    public void bindControls(DataBindingContext context, Object model) {
        super.bindControls(context, model);
        this.bind(context, this.refreshOptionsCombo.getPropertyEditor(), (EStructuralFeature)ExecutablePackage.Literals.EXECUTABLE__IMPLICIT_REFRESH_FLAG_ENUM);
        this.bindVariablesTable();
    }

    @Override
    protected void addControls(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        this.myIdText = this.createMyIdText(toolkit, parent);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.myIdText.createControl(toolkit, parent, false, false));
        this.setTypeLabel(this.createTypeLabelFormText(parent));
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.getTypeLabel().createControl(toolkit, parent, false, false));
        this.refreshOptionsCombo = new PropertyEditorViewer((PropertyEditorFactory)this.createLabeledStaticComboPropertyEditorFactory(parent, RefreshOption.VALUES, (ILabelProvider)new EnumLabelProvider(), EditorLabelMessages.VariablesIteratorEditor_RefreshOption));
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.refreshOptionsCombo.createControl(toolkit, parent, false, false));
        DTRTUIUtil.createSectionLabel((FormToolkit)toolkit, (Composite)parent, (String)EditorLabelMessages.VariablesIteratorEditor_Variables);
        this.variablesTable = this.createVariablesTable(toolkit, parent);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.variablesTable.createControl(toolkit, parent, false, false));
        this.createTextEditor((PropertyEditorViewer<TablePropertyEditor>)this.variablesTable, (EStructuralFeature)ExecutablePackage.Literals.GENERIC_ATTR__NAME, 0);
        this.createTextEditor((PropertyEditorViewer<TablePropertyEditor>)this.variablesTable, (EStructuralFeature)ExecutablePackage.Literals.GENERIC_ATTR__TYPE, 1);
    }

    private TablePropertyEditorViewer createVariablesTable(FormToolkit toolkit, Composite parent) {
        TableFactory tableFactory = TableFactory.create().defaults().addColumn(TableFactory.TableColumnFactory.create().defaults().resizable(true).text(EditorLabelMessages.VariablesIteratorEditor_Name)).addColumn(TableFactory.TableColumnFactory.create().defaults().resizable(true).text(EditorLabelMessages.VariablesIteratorEditor_VariablesIteratorEditor_Type));
        return new TablePropertyEditorViewer(this.createTablePropertyEditorFactory(toolkit, parent).editor(this.createTableEditorFactory()), tableFactory);
    }

    private SelectionBasedEditorFactory createTableEditorFactory() {
        SelectionBasedEditorFactory tableEditorFactory = new SelectionBasedEditorFactory();
        oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ActionFactory actionFactory = new oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ActionFactory();
        actionFactory.image(ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_ADD)));
        actionFactory.handler((SelectionOperationHandler)new AddVariableRunnable((IOEPEExecutableContext)this.getContext(), (IVariablesIterator)this.getModel()));
        tableEditorFactory.actionAdd(actionFactory);
        actionFactory = new oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ActionFactory();
        actionFactory.image(ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_DELETE)));
        this.removeVariableHandler = new RemoveVariableRunnable((IOEPEExecutableContext)this.getContext(), (IVariablesIterator)this.getModel());
        actionFactory.handler((SelectionOperationHandler)this.removeVariableHandler);
        tableEditorFactory.actionRemove(actionFactory);
        return tableEditorFactory;
    }

    protected FormTextEditorViewer createMyIdText(FormToolkit toolkit, Composite editorComposite) {
        return new FormTextEditorViewer(this.createFormTextEditorFactory(toolkit, editorComposite, EditorLabelMessages.BaseBindingEditor_1, null), this.getContext(), false);
    }

    @Override
    protected void bindIdText(DataBindingContext context) {
        ErrorTolerantEObjectObservableValue modelObservable = new ErrorTolerantEObjectObservableValue((IOEPEExecutableContext)this.getContext(), (IBaseObject)this.getModel(), (EStructuralFeature)ExecutablePackage.Literals.IBASE_OBJECT__ID);
        this.manageObservable((IObservable)modelObservable);
        this.myIdText.bind(context, (IObservableValue)modelObservable, this.toolkit);
    }

    protected void bindVariablesTable() {
        TableViewer viewer = ((TablePropertyEditor)this.variablesTable.getPropertyEditor()).getViewer();
        viewer.setContentProvider((IContentProvider)new VariableListContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new VariablesTableLabelProvider());
        viewer.setInput((Object)this.getContext().getPageDefinition());
    }

    private void createTextEditor(PropertyEditorViewer<TablePropertyEditor> attributesTable, final EStructuralFeature feature, int columnIndex) {
        TableViewer viewer = ((TablePropertyEditor)attributesTable.getPropertyEditor()).getViewer();
        TextCellEditor cellEditor = new TextCellEditor((Composite)viewer.getTable(), 0);
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, viewer.getTable().getColumn(columnIndex));
        TableAttributeEditingSupport editingSupport = new TableAttributeEditingSupport((ColumnViewer)viewer, (CellEditor)cellEditor, columnIndex, (SelectionOperationHandler)new ChangeVariableRunnable((IOEPEExecutableContext)this.getContext(), (IVariablesIterator)this.getModel(), feature), new AbstractAttributeRowEditingSupport.CanEditValidator(){

            public IStatus validate(Object value) {
                return Status.OK_STATUS;
            }
        }){

            protected Object getValue(Object element) {
                Object value;
                if (element instanceof EObject && (value = ((EObject)element).eGet(feature)) != null) {
                    return value;
                }
                return "";
            }
        };
        viewerColumn.setEditingSupport((EditingSupport)editingSupport);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof EObject) {
                    Object value = ((EObject)element).eGet(feature);
                    if (value != null) {
                        value = "";
                    }
                    cell.setText((String)value);
                }
            }
        });
    }

    public void handleGlobalActionExecution(String actionId, Control control, Event event) {
        if (actionId.equals(ActionFactory.DELETE.getId()) && control == ((TablePropertyEditor)this.variablesTable.getPropertyEditor()).getViewer().getControl()) {
            ICommand command = this.removeVariableHandler.createHandlerCommand(((TablePropertyEditor)this.variablesTable.getPropertyEditor()).getViewer().getSelection());
            this.removeVariableHandler.execute(command);
        }
    }

    public static class AddVariableRunnable
    extends SelectionOperationHandler.DefaultExecutingSelectionOperationHandler {
        private final IVariablesIterator model;

        public AddVariableRunnable(IOEPEExecutableContext context, IVariablesIterator model) {
            super(context);
            this.model = model;
        }

        public ICommand createHandlerCommand(final ISelection selection) {
            IUndoableRunnableCommand command = new UndoableRunnableCommand(this.getContext()).setRunnable(EditorLabelMessages.VariablesIteratorEditor_VariablesIteratorEditor_AddNewVariable, new Runnable(){

                @Override
                public void run() {
                    IVariable var = AddVariableRunnable.this.getNewValue(selection);
                    IObject parent = AddVariableRunnable.this.model.getParent();
                    if (parent instanceof PageDefinition) {
                        ((PageDefinition)parent).getVariables().add((Object)var);
                    }
                }
            });
            return command;
        }

        public void execute(ICommand command) {
            try {
                this.getContext().setExecuteCommand(command).execute((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException e) {
                DTRTvBundle.log(e);
            }
            catch (CoreException e) {
                DTRTvBundle.log(e);
            }
        }

        public IVariable getNewValue(ISelection selection) {
            IVariablesIterator iVarIt = this.model;
            VariablesIterator varIt = (VariablesIterator)iVarIt.getDecoratedObject();
            Variable newVar = new Variable();
            newVar.initializeFromElement(varIt.getTransactionManager(), varIt.getDocument().createElementNS(newVar.getNameSpaceUrl(), newVar.getXMLElementTag()));
            IVariable var = EMFObjectTranslator.INSTANCE.create(newVar, iVarIt);
            var.setName(this.calcUniqueName());
            var.setType("java.lang.String");
            return var;
        }

        private String calcUniqueName() {
            EList<String> existingVariableNames = this.model.getVariableNames();
            int initVal = 1;
            String possibleName = null;
            while (initVal < Short.MAX_VALUE) {
                possibleName = this.calcName(initVal);
                if (!existingVariableNames.contains((Object)possibleName)) break;
                ++initVal;
            }
            if (initVal < Short.MAX_VALUE && possibleName != null) {
                return possibleName;
            }
            throw new IllegalStateException("Can't find a unique variable name for variable iterator");
        }

        private String calcName(int val) {
            return String.format("NewVariable%d", val);
        }
    }

    public static class ChangeVariableRunnable
    extends SelectionOperationHandler.DefaultExecutingSelectionOperationHandler {
        private final EStructuralFeature feature;

        public ChangeVariableRunnable(IOEPEExecutableContext context, IVariablesIterator iVariablesIterator, EStructuralFeature feature) {
            super(context);
            this.feature = feature;
        }

        public ICommand createHandlerCommand(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                Iterator it = ((IStructuredSelection)selection).iterator();
                Object obj1 = it.next();
                Object obj2 = it.next();
                if (obj1 instanceof IVariable && obj2 instanceof String) {
                    SetCommandFactory setCommandFactory = new SetCommandFactory(this.getContext(), (IVariable)obj1, this.feature);
                    return setCommandFactory.create(obj2);
                }
            }
            return null;
        }

        public Object getNewValue(ISelection selection) {
            return null;
        }
    }

    public static class RemoveVariableRunnable
    extends SelectionOperationHandler.DefaultExecutingSelectionOperationHandler {
        private final IVariablesIterator model;

        public RemoveVariableRunnable(IOEPEExecutableContext context, IVariablesIterator model) {
            super(context);
            this.model = model;
        }

        public ICommand createHandlerCommand(final ISelection selection) {
            IUndoableRunnableCommand command = new UndoableRunnableCommand(this.getContext()).setRunnable(EditorLabelMessages.VariablesIteratorEditor_RemoveVariable, new Runnable(){

                @Override
                public void run() {
                    IObject parent;
                    Object var;
                    if (selection instanceof IStructuredSelection && (var = ((IStructuredSelection)selection).getFirstElement()) instanceof IVariable && (parent = RemoveVariableRunnable.this.model.getParent()) instanceof PageDefinition) {
                        ((PageDefinition)parent).getVariables().remove(var);
                    }
                }
            });
            return command;
        }

        public Object getNewValue(ISelection selection) {
            return null;
        }
    }
}

