/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.lovwizard;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectCustomization;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectType;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;

class LOVWizardModel
implements IDisposable {
    private IStructureChild structureChild;
    private StructureObjectCustomization.LOV initialLOV;
    private StructureObjectCustomization.EditableLOV lov;
    private StructureObjectCustomization customization;
    private IStructureChild sourceAccessor;
    private IStructureChild sourceAccessorAttribute;
    private List<IStructureChild> checkedDisplayAttributes;
    private List<IStructureChild> availableDisplayAttributes;

    public LOVWizardModel(IStructureChild structureChild, StructureObjectCustomization.LOV lov, StructureObjectCustomization customization) {
        this.structureChild = structureChild;
        this.customization = customization;
        this.initialLOV = lov;
        this.lov = StructureObjectCustomization.EditableLOV.createCopy(lov);
        if (this.lov.getName() == null) {
            this.lov.setName(customization.computeLOVName(structureChild.getId()));
        }
    }

    public void dispose() {
        this.structureChild = null;
        this.lov = null;
        this.customization = null;
        this.sourceAccessor = null;
        this.sourceAccessorAttribute = null;
        if (this.checkedDisplayAttributes != null) {
            this.checkedDisplayAttributes.clear();
            this.checkedDisplayAttributes = null;
        }
        if (this.availableDisplayAttributes != null) {
            this.availableDisplayAttributes.clear();
            this.availableDisplayAttributes = null;
        }
    }

    public IStructureChild getStructureChild() {
        return this.structureChild;
    }

    public boolean isNewLOV() {
        return this.initialLOV == null;
    }

    public StructureObjectCustomization.EditableLOV getLOV() {
        return this.lov;
    }

    public boolean hasChange() {
        return !StructureObjectCustomization.LOV.areIdentical(this.initialLOV, this.lov);
    }

    public StructureObjectCustomization getCustomization() {
        return this.customization;
    }

    public void setSource(IStructureChild sourceAccessor, IStructureChild sourceAccessorAttribute) {
        assert (sourceAccessor != null || sourceAccessorAttribute == null) : sourceAccessor + " - " + sourceAccessorAttribute;
        String sourceAccessorId = sourceAccessor != null ? sourceAccessor.getId() : null;
        this.lov.setViewInstanceName(sourceAccessorId);
        if (this.initialLOV != null && DTRTUtil.equals((Object)this.lov.getViewInstanceName(), (Object)this.initialLOV.getViewInstanceName())) {
            this.lov.setViewAccessorName(this.initialLOV.getViewAccessorName());
        } else {
            this.lov.setViewAccessorName(this.customization.computeViewAccessorName(sourceAccessorId));
        }
        this.sourceAccessor = sourceAccessor;
        this.lov.setListAttributeName(sourceAccessorAttribute != null ? sourceAccessorAttribute.getId() : null);
        this.sourceAccessorAttribute = sourceAccessorAttribute;
        this.resetAllDisplayAttributes();
    }

    public IStructureChild getSource() {
        return this.sourceAccessorAttribute != null ? this.sourceAccessorAttribute : this.sourceAccessor;
    }

    public IStructureChild getSourceAccessor() {
        return this.sourceAccessor;
    }

    public IStructureChild getSourceAccessorAttribute() {
        return this.sourceAccessorAttribute;
    }

    private void resetAllDisplayAttributes() {
        List<? extends String> displayNames;
        this.getCheckedDisplayAttributes().clear();
        this.getAvailableDisplayAttributes().clear();
        this.getAvailableDisplayAttributes().addAll(this.getAllAccessorAttributes());
        if (!this.getAvailableDisplayAttributes().isEmpty() && !(displayNames = this.getLOV().getDisplayAttributeNames()).isEmpty()) {
            int index = 0;
            block0: for (String string : displayNames) {
                int i = 0;
                while (i < this.getAvailableDisplayAttributes().size()) {
                    if (string.equals(this.getAvailableDisplayAttributes().get(i).getId())) {
                        IStructureChild attribute = this.getAvailableDisplayAttributes().remove(i);
                        this.getAvailableDisplayAttributes().add(index++, attribute);
                        this.getCheckedDisplayAttributes().add(attribute);
                        continue block0;
                    }
                    ++i;
                }
            }
        }
    }

    public List<IStructureChild> getCheckedDisplayAttributes() {
        return this.checkedDisplayAttributes == null ? (this.checkedDisplayAttributes = new LinkedList<IStructureChild>()) : this.checkedDisplayAttributes;
    }

    public List<IStructureChild> getAvailableDisplayAttributes() {
        return this.availableDisplayAttributes == null ? (this.availableDisplayAttributes = new LinkedList<IStructureChild>()) : this.availableDisplayAttributes;
    }

    public void updateLOV() {
        this.getLOV().getModifiableDisplayAttributeNames().clear();
        for (IStructureChild structureChild : this.getCheckedDisplayAttributes()) {
            this.getLOV().getModifiableDisplayAttributeNames().add(structureChild.getId());
        }
    }

    public List<IStructureChild> getAllAccessorAttributes() {
        if (StructureObjectType.getStructureObjectType((IStructureObject)this.structureChild) == StructureObjectType.ACCESSOR && StructureObjectType.getStructureObjectType((IStructureObject)this.getSource()) == StructureObjectType.ACCESSOR) {
            LinkedList<IStructureChild> attributes = new LinkedList<IStructureChild>();
            IStructureChild source = this.getSource();
            for (IStructure referencedStructure : source.getReferencedStructures()) {
                attributes.addAll(StructureUtil.findChildren((IStructureObject)referencedStructure, StructureObjectType.ATTRIBUTE));
            }
            Collections.sort(attributes, DTRTUtil.COMPARATOR);
            return attributes;
        }
        return new LinkedList<IStructureChild>();
    }
}

