/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.lovwizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.BaseWizardPage;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.DescribableTreeElement;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewerComparator;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.editor.ResolvedLOVContentProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.lovwizard.LOVUIOptionsPage;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.lovwizard.LOVWizardModel;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.lovwizard.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;

class LOVSourcePage
extends BaseWizardPage {
    private LOVWizardModel model;
    private Text nameText;
    private TreeViewer sourceTreeViewer;
    private Text sourceText;
    private Text sourceAttributeText;
    private String originalName;

    public LOVSourcePage(LOVWizardModel model) {
        super(LOVSourcePage.class.getName(), Messages.LOVSourcePageTitle, null);
        assert (model.getLOV().getName() != null) : "The wizard should set the name if needed";
        this.model = model;
        this.originalName = model.getLOV().getName();
        this.setMessage(NLS.bind((String)Messages.LOVSourcePageMessage, (Object)DTRTUtil.getLabel((IDescriptor)model.getStructureChild().getSourceTypeDescriptor())));
        this.setPageComplete(false);
    }

    public void dispose() {
        this.model = null;
        this.nameText = null;
        this.sourceTreeViewer = null;
        this.sourceText = null;
        this.sourceAttributeText = null;
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite clientComposite = new Composite(parent, 0);
        this.setControl((Control)clientComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(clientComposite);
        DTRTUIUtil.applyGrabAllGridData((Control)clientComposite);
        GridLayoutFactory twoColumns = GridLayoutFactory.fillDefaults().numColumns(2);
        Composite composite = new Composite(clientComposite, 0);
        twoColumns.applyTo(composite);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)composite);
        new Label(composite, 0).setText(Messages.LOVNameLabel);
        this.nameText = new Text(composite, 2048);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.nameText);
        this.nameText.setText(this.originalName);
        this.nameText.setSelection(0, this.originalName.length());
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LOVSourcePage.this.model.getLOV().setName(LOVSourcePage.this.nameText.getText());
                LOVSourcePage.this.validatePage();
            }
        });
        if (!this.model.isNewLOV()) {
            this.nameText.setEditable(false);
        }
        Composite sourceComposite = new Composite(clientComposite, 0);
        twoColumns.spacing(5, 0).applyTo(sourceComposite);
        DTRTUIUtil.applyGrabAllGridData((Control)sourceComposite);
        Composite composite2 = new Composite(sourceComposite, 0);
        twoColumns.spacing(0, 0).applyTo(composite2);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)composite2);
        Label sourceLabel = new Label(composite2, 0);
        sourceLabel.setText(Messages.LOVSourceLabel);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)sourceLabel);
        ToolBar toolBar = new ToolBar(composite2, 0x800000);
        GridDataFactory.fillDefaults().align(0x1000008, 1024).applyTo((Control)toolBar);
        Action collapseAction = new Action(){

            public void run() {
                LOVSourcePage.this.sourceTreeViewer.collapseAll();
            }
        };
        collapseAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL"));
        collapseAction.setToolTipText(Messages.collapseAll);
        Action expandAction = new Action(){

            public void run() {
                LOVSourcePage.this.sourceTreeViewer.expandAll();
            }
        };
        expandAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_EXPAND_ALL)));
        expandAction.setToolTipText(Messages.expandAll);
        DTRTUIUtil.renderAction((Object)toolBar, (IAction)collapseAction);
        DTRTUIUtil.renderAction((Object)toolBar, (IAction)expandAction);
        this.sourceTreeViewer = new TreeViewer(sourceComposite, 2816);
        DTRTUIUtil.applyGrabAllGridData((Control)this.sourceTreeViewer.getControl()).horizontalSpan = 2;
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.sourceTreeViewer);
        this.sourceTreeViewer.setLabelProvider((IBaseLabelProvider)new DescribableLabelProvider());
        this.sourceTreeViewer.setContentProvider((IContentProvider)new ResolvedLOVContentProvider());
        this.sourceTreeViewer.setComparator((ViewerComparator)new DescribableViewerComparator());
        this.sourceTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DescribableTreeElement element;
                IStructureChild accessor = null;
                IStructureChild accessorAttribute = null;
                Object object = DTRTUIUtil.getFirstElement((ISelection)event.getSelection());
                if (object instanceof DescribableTreeElement && (element = (DescribableTreeElement)object).getParent() instanceof DescribableTreeElement && element.getDescribable() instanceof IStructureChild) {
                    IStructureChild structureChild = (IStructureChild)element.getDescribable();
                    Collection resolvedLOVs = (Collection)LOVSourcePage.this.sourceTreeViewer.getInput();
                    if (StructureUtil.findResolvedLOV(resolvedLOVs, structureChild) != null) {
                        if (StructureUtil.isCollection(structureChild)) {
                            accessor = structureChild;
                        } else {
                            DescribableTreeElement parentElement = (DescribableTreeElement)element.getParent();
                            if (parentElement.getDescribable() instanceof IStructureChild) {
                                accessor = (IStructureChild)parentElement.getDescribable();
                                accessorAttribute = structureChild;
                            }
                        }
                    }
                }
                LOVSourcePage.this.model.setSource(accessor, accessorAttribute);
                if (accessorAttribute != null) {
                    if (!$assertionsDisabled && accessor == null) {
                        throw new AssertionError();
                    }
                    LOVSourcePage.this.sourceText.setText(DTRTUtil.toNotNullString((String)LOVSourcePage.this.model.getLOV().getViewInstanceName()));
                    LOVSourcePage.this.sourceAttributeText.setText(DTRTUtil.toNotNullString((String)LOVSourcePage.this.model.getLOV().getListAttributeName()));
                } else if (accessor != null) {
                    LOVSourcePage.this.sourceText.setText(DTRTUtil.toNotNullString((String)LOVSourcePage.this.model.getLOV().getViewInstanceName()));
                    LOVSourcePage.this.sourceAttributeText.setText(Messages.sourceNotApplicable);
                } else {
                    LOVSourcePage.this.sourceText.setText(DTRTUtil.toNotNullString((String)Messages.sourceNotSet));
                    LOVSourcePage.this.sourceAttributeText.setText(Messages.sourceNotSet);
                }
                LOVSourcePage.this.validatePage();
            }
        });
        composite2 = new Composite(clientComposite, 0);
        twoColumns.applyTo(composite2);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)composite2);
        new Label(composite2, 0).setText(Messages.sourceLabel);
        this.sourceText = new Text(composite2, 0);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.sourceText);
        this.sourceText.setEditable(false);
        this.sourceText.setText(Messages.sourceNotSet);
        composite2 = new Composite(clientComposite, 0);
        twoColumns.applyTo(composite2);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)composite2);
        new Label(composite2, 0).setText(Messages.sourceAttributeLabel);
        this.sourceAttributeText = new Text(composite2, 0);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.sourceAttributeText);
        this.sourceAttributeText.setEditable(false);
        this.sourceAttributeText.setText(Messages.sourceNotSet);
        this.setControl((Control)clientComposite);
    }

    private void validatePage() {
        if (this.getContainer().getCurrentPage() == this) {
            this.setErrorMessage(null);
            IStatus status = this.validateName();
            if (status.isOK()) {
                status = this.validateSource();
            }
            if (!status.isOK()) {
                this.setErrorMessage(status.getMessage());
            }
            IWizardPage[] iWizardPageArray = this.getWizard().getPages();
            int n = iWizardPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                if (page instanceof LOVUIOptionsPage) {
                    ((LOVUIOptionsPage)page).validatePage();
                    break;
                }
                ++n2;
            }
            this.setPageComplete(status.isOK());
        }
    }

    private IStatus validateName() {
        String nameTextValue = this.nameText.getText().trim();
        if (!nameTextValue.equals(this.originalName)) {
            return this.model.getCustomization().isValidLOVName(nameTextValue);
        }
        return Status.OK_STATUS;
    }

    private IStatus validateSource() {
        if (this.model.getSource() == null) {
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", NLS.bind((String)Messages.sourceNoSelectionMessage, (Object)this.model.getStructureChild().getSourceTypeDescriptor().getLabel()));
        }
        return Status.OK_STATUS;
    }

    protected void aboutToBecomeVisible(boolean firstTime) throws Exception {
        if (firstTime) {
            Collection<? extends StructureUtil.ResolvedLOV> resolvedLOVs = StructureUtil.resolveLOV(this.model.getStructureChild(), this.model.getLOV(), false);
            Set<? extends StructureUtil.ResolvedLOV> allResolvedLOVs = StructureUtil.computeResolvedLOVs(this.model.getStructureChild());
            this.sourceTreeViewer.setAutoExpandLevel(-1);
            this.sourceTreeViewer.setInput(allResolvedLOVs);
            if (!resolvedLOVs.isEmpty()) {
                ArrayList<DescribableTreeElement> treeElements = new ArrayList<DescribableTreeElement>(resolvedLOVs.size());
                for (StructureUtil.ResolvedLOV resolvedLOV : resolvedLOVs) {
                    DescribableTreeElement treeElement = ResolvedLOVContentProvider.toTreeElement(resolvedLOV);
                    if (treeElement == null) continue;
                    treeElements.add(treeElement);
                }
                if (!treeElements.isEmpty()) {
                    Collections.sort(treeElements, DTRTUtil.COMPARATOR);
                    this.sourceTreeViewer.collapseAll();
                    this.sourceTreeViewer.setSelection((ISelection)new StructuredSelection(treeElements.get(0)), true);
                }
            }
        }
    }
}

