/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.editor;

import java.util.Collection;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.ui.provider.CustomizedStructureObjectLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewerComparator;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectCustomization;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.editor.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.editor.ResolvedLOVContentProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

class ResolvedLOVDialog
extends TitleAreaDialog {
    private TreeViewer resolvedSourcesTreeViewer;
    private StructureObjectCustomization.LOV lov;
    private IStructureChild structure;
    private Collection<? extends StructureUtil.ResolvedLOV> resolvedLOVs;
    private ISelection doubleClickSelection;

    public ResolvedLOVDialog(Shell parentShell, IStructureChild structure, Collection<? extends StructureUtil.ResolvedLOV> resolvedLOVs) {
        super(parentShell);
        this.setShellStyle(0x10C70 | ResolvedLOVDialog.getDefaultOrientation());
        this.structure = structure;
        this.resolvedLOVs = resolvedLOVs;
        this.lov = StructureUtil.getCustomization((IStructureObject)structure).getLOV();
        assert (this.lov != null);
    }

    public void dispose() {
        this.structure = null;
        this.resolvedLOVs = null;
        this.lov = null;
        this.resolvedSourcesTreeViewer = null;
        this.doubleClickSelection = null;
    }

    public ISelection getSelection() {
        return this.doubleClickSelection;
    }

    protected void configureShell(Shell shell) {
        shell.setSize(500, 400);
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        DTRTUIUtil.applyGrabAllGridData((Control)composite);
        this.setTitle(NLS.bind((String)Messages.showSourcesDialogTitle, (Object)this.lov.getName()));
        this.setMessage(NLS.bind((String)Messages.showSourcesDialogMessage, (Object)this.lov.getName(), (Object)DTRTUtil.getLabel((IDescribable)this.structure)));
        this.resolvedSourcesTreeViewer = new TreeViewer(composite);
        DTRTUIUtil.applyGrabAllGridData((Control)this.resolvedSourcesTreeViewer.getControl());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.resolvedSourcesTreeViewer);
        this.resolvedSourcesTreeViewer.setContentProvider((IContentProvider)new ResolvedLOVContentProvider());
        this.resolvedSourcesTreeViewer.setLabelProvider((IBaseLabelProvider)new CustomizedStructureObjectLabelProvider());
        this.resolvedSourcesTreeViewer.setComparator((ViewerComparator)new DescribableViewerComparator());
        this.resolvedSourcesTreeViewer.setInput(this.resolvedLOVs);
        this.resolvedSourcesTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object object = DTRTUIUtil.getFirstElement((ISelection)event.getSelection());
                IStructureObject structureObject = ResolvedLOVContentProvider.getStructureObject(object);
                if (structureObject != null && !structureObject.equals((Object)ResolvedLOVDialog.this.structure)) {
                    ResolvedLOVDialog.this.doubleClickSelection = (ISelection)new StructuredSelection((Object)structureObject);
                    ResolvedLOVDialog.this.close();
                }
            }
        });
        this.resolvedSourcesTreeViewer.expandAll();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

