/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.command;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandRunnable;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.ISetCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectCustomization;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.command.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.UndoableRunnableCommand;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.SetCommandImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public final class StructureObjectSetCommand
extends UndoableRunnableCommand
implements ISetCommand {
    private IObject object;
    private IDescribable property;
    private IStructureObjectSetCommandParticipant participant;
    private Object value;
    private LOVSetOperation lovSetOperation;
    private boolean checkResolvingStructures = true;

    public StructureObjectSetCommand(IDataControlContext context) {
        super((IOEPEExecutableContext)context);
        this.setUndoInterruptedExecution(true);
    }

    @Override
    public void dispose() {
        this.object = null;
        this.property = null;
        this.value = null;
        this.participant = null;
        super.dispose();
    }

    public final StructureObjectSetCommand clone() {
        return new StructureObjectSetCommand((IDataControlContext)this.getCommandStack()).setObject(this.getObject()).setProperty(this.getProperty()).setValue(this.getValue()).setParticipant(this.getParticipant()).setLOVSetOperation(this.getLOVSetOperation()).setCheckResolvingStructures(this.isCheckResolvingStructures());
    }

    public StructureObjectSetCommand setObject(IObject object) throws IllegalStateException {
        this.checkExecuted();
        this.object = object;
        return this;
    }

    public IObject getObject() {
        return this.object;
    }

    public StructureObjectSetCommand setProperty(IDescribable property) throws IllegalStateException {
        this.checkExecuted();
        this.property = property;
        return this;
    }

    public IDescribable getProperty() {
        return this.property;
    }

    public StructureObjectSetCommand setCheckResolvingStructures(boolean checkResolvingStructures) {
        this.checkResolvingStructures = checkResolvingStructures;
        return this;
    }

    public boolean isCheckResolvingStructures() {
        return this.checkResolvingStructures;
    }

    public StructureObjectSetCommand setLOVSetOperation(LOVSetOperation lovSetOperation) {
        this.lovSetOperation = lovSetOperation;
        return this;
    }

    public LOVSetOperation getLOVSetOperation() {
        return this.lovSetOperation;
    }

    public StructureObjectSetCommand setParticipant(IStructureObjectSetCommandParticipant participant) {
        this.checkExecuted();
        this.participant = participant;
        return this;
    }

    public IStructureObjectSetCommandParticipant getParticipant() {
        return this.participant;
    }

    public StructureObjectSetCommand setValue(Object value) throws IllegalStateException {
        this.checkExecuted();
        this.value = value;
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public List<? extends IObject> getAffectedObjects() {
        return this.getLastOperation() != null && this.getObject() != null ? Collections.singletonList(this.getObject()) : Collections.emptyList();
    }

    private String getCommandLabel() {
        if (this.getProperty() instanceof StructureObjectCustomization.SetableFeature) {
            StructureObjectCustomization.SetableFeature feature = (StructureObjectCustomization.SetableFeature)this.getProperty();
            return feature == StructureObjectCustomization.SetableFeature.LOVFeature && this.getLOVSetOperation() != null ? this.getLOVSetOperation().getCommandLabel() : SetCommandImpl.getLabel((IDescribable)feature);
        }
        return null;
    }

    protected void assertExecution() throws Exception {
        DTRTUtil.assertTrue((boolean)(this.getObject() instanceof IStructureObject), (String)NLS.bind((String)Messages.objectMustBeStructure, (Object)this.getObject()));
        DTRTUtil.assertTrue((boolean)(this.getProperty() instanceof StructureObjectCustomization.SetableFeature), (String)NLS.bind((String)Messages.objectMustBeStructure, (Object)this.getProperty()));
        StructureObjectCustomization.SetableFeature feature = (StructureObjectCustomization.SetableFeature)this.getProperty();
        DTRTUtil.assertTrue((this.getValue() == null || feature.getType().isInstance(this.getValue()) ? 1 : 0) != 0, (String)NLS.bind((String)Messages.valueMustBeFeature, (Object)this.getValue(), feature.getType()));
        DTRTUtil.assertTrue((boolean)((IStructureObject)this.getObject()).canCustomize(), (String)NLS.bind((String)Messages.structureMustBeCustomizable, (Object)this.getObject()));
        if (feature == StructureObjectCustomization.SetableFeature.LOVFeature && this.getLOVSetOperation() != LOVSetOperation.DELETE) {
            DTRTUtil.assertTrue((boolean)(this.getObject() instanceof IStructureChild), (String)NLS.bind((String)Messages.objectMustBeStructureChild, (Object)this.getObject()));
            if (this.isCheckResolvingStructures()) {
                String message = this.getLOVSetOperation() == LOVSetOperation.CREATE ? Messages.noResovledLOVSourcesCreateMessage : Messages.noResovledLOVSourcesEditMessage;
                DTRTUtil.assertTrue((!StructureUtil.computeResolvedLOVs((IStructureChild)this.getObject()).isEmpty() ? 1 : 0) != 0, (String)message);
            }
        }
        if (this.getExecutionRunnable() == null) {
            this.setExecutionRunnable(this.getCommandLabel(), (Runnable)new ICommandRunnable(){

                public void run() {
                    throw new IllegalStateException("Should not be invoked");
                }

                public void dispose() {
                }

                public boolean isDisposed() {
                    return StructureObjectSetCommand.this.isDisposed();
                }

                public List<? extends IObject> run(ICommandStack commandStack, ICommand.CommandOperation operation, IProgressMonitor monitor) throws Exception {
                    return StructureObjectSetCommand.this.run(monitor);
                }
            });
        }
    }

    protected List<? extends IObject> run(IProgressMonitor monitor) throws Exception {
        IStructureObject structureObject = (IStructureObject)this.getObject();
        StructureObjectCustomization customization = StructureUtil.getCustomization(structureObject, true);
        if (customization != null) {
            StructureObjectCustomization.SetableFeature feature = (StructureObjectCustomization.SetableFeature)this.getProperty();
            if (feature == StructureObjectCustomization.SetableFeature.LOVFeature && this.getParticipant() != null) {
                this.setValue(this.getParticipant().getLOV(this, customization));
            }
            customization.setValue(feature, this.getValue());
            return Collections.singletonList(this.getObject());
        }
        return Collections.emptyList();
    }

    protected void beforeUndo(IProgressMonitor monitor) throws Exception {
        StructureObjectCustomization customization = StructureUtil.getCustomization((IStructureObject)this.getObject());
        if (customization != null) {
            customization.dispose();
        }
    }

    protected void beforeRedo(IProgressMonitor monitor) throws Exception {
        StructureObjectCustomization customization = StructureUtil.getCustomization((IStructureObject)this.getObject());
        if (customization != null) {
            customization.dispose();
        }
    }

    public static interface IStructureObjectSetCommandParticipant {
        public StructureObjectCustomization.LOV getLOV(StructureObjectSetCommand var1, StructureObjectCustomization var2) throws Exception;
    }

    public static enum LOVSetOperation {
        CREATE(Messages.commandCreateLOV),
        DELETE(Messages.commandDeleteLOV),
        EDIT(Messages.commandEditLOV);

        private String commandLabel;

        private LOVSetOperation(String commandLabel) {
            this.commandLabel = commandLabel;
        }

        String getCommandLabel() {
            return this.commandLabel;
        }
    }
}

