/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import oracle.binding.meta.NamedDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionStructureObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonBundleIcon;
import org.eclipse.osgi.util.NLS;

public enum StructureObjectType implements IDescribable
{
    ACCESSOR(Messages.accessor, (ImageManager.IImageData)DTRTvCommonBundleIcon.ACCESSOR_ATTRIBUTE, 30),
    ATTRIBUTE(Messages.attribute, (ImageManager.IImageData)DTRTvCommonBundleIcon.ATTRIBUTE_SM, 40),
    CONSTRUCTOR(Messages.constructor, (ImageManager.IImageData)DTRTvCommonBundleIcon.CONSTRUCTOR, 50),
    CRITERIA(Messages.criteria, (ImageManager.IImageData)DTRTvCommonBundleIcon.ALL_QUERIABLE_ATTRIBUTES, 0),
    DATA_CONTROL(Messages.dataControl, (ImageManager.IImageData)DTRTBundleIcon.DATA_CONTROL_GENERIC, 0),
    OPERATION(Messages.operation, (ImageManager.IImageData)DTRTvCommonBundleIcon.METHOD, 20),
    OPERATION_RETURN(Messages.operationReturn, (ImageManager.IImageData)DTRTvCommonBundleIcon.RETURN_VALUE, 30),
    PARAMETER(Messages.parameter, (ImageManager.IImageData)DTRTvCommonBundleIcon.PARAMETER, 20),
    STRUCTURE(Messages.structure, (ImageManager.IImageData)DTRTBundleIcon.STRUCTURE, 20),
    VARIABLE(Messages.variable, (ImageManager.IImageData)DTRTvCommonBundleIcon.ACCESSOR_ATTRIBUTE, 20);

    private final BaseDescriptor descriptor;
    private final int compareCategory;

    public static StructureObjectType getStructureObjectType(IStructureObject structureObject) {
        return structureObject instanceof NamedDefinitionStructureObject ? ((NamedDefinitionStructureObject)structureObject).getStructureObjectType() : null;
    }

    static StructureObjectType getStructureObjectType(NamedDefinition namedDefinition) {
        if (namedDefinition != null) {
            switch (namedDefinition.getDefinitionType()) {
                case 40: {
                    return ACCESSOR;
                }
                case 30: {
                    return ATTRIBUTE;
                }
                case 110: {
                    return CRITERIA;
                }
                case 50: {
                    return DATA_CONTROL;
                }
                case 60: {
                    return DTRTvUtil.isConstructor(namedDefinition) ? CONSTRUCTOR : OPERATION;
                }
                case 100: {
                    return OPERATION_RETURN;
                }
                case 70: {
                    return PARAMETER;
                }
                case 20: {
                    return STRUCTURE;
                }
                case 80: {
                    return VARIABLE;
                }
            }
        }
        return null;
    }

    private StructureObjectType(String label, ImageManager.IImageData imageData, int compareCategory) {
        this.descriptor = StructureUtil.getDescriptor(label, null, imageData);
        this.compareCategory = compareCategory;
    }

    ImageManager.IImageData getImageData() {
        return this.descriptor.getImageData();
    }

    public BaseDescriptor getDescriptor() {
        return this.descriptor;
    }

    int getCompareCategory() {
        return this.compareCategory;
    }

    private static class Messages
    extends NLS {
        public static String accessor;
        public static String attribute;
        public static String constructor;
        public static String criteria;
        public static String dataControl;
        public static String operation;
        public static String operationReturn;
        public static String parameter;
        public static String structure;
        public static String variable;

        static {
            NLS.initializeMessages((String)StructureObjectType.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

