/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.adfdt.model.objects.BeanStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.BasicDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureDefinitionStructure;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectType;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectValidator;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.AttrArray;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.BaseAttribute;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.ListBinding;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.PDefViewObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.SchemaBasedProperty;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.ViewAccessor;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.PropertiesElement;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class StructureObjectCustomization
implements IDisposable {
    private static final String ADFBUNDLE_EL_REGEX = ".*?[\\$#]\\{adfBundle\\s*\\[\\s*([\"'])([\\w\\.]+)\\1\\s*\\]\\s*\\[\\s*([\"'])([\\w\\.]+)\\3\\s*\\]\\s*\\}";
    private static final String DEFAULT_PROPERTIES_ELEMENT = "model.ModelBundle";
    private static Pattern adfbundleELPattern;
    private IDTRTManager manager;
    private BaseAttribute baseAttribute;
    private IStructureChild.StructureChildKind structureChildKind;
    private StructureObjectType structureObjectType;
    private String fullName;
    private Pair<PropertiesElement, String> labelProperty;
    private Pair<PropertiesElement, String> toolTipTextProperty;
    private LOV lov;

    static IFile getCustomizationFile(IStructure structure) {
        PDefViewObject viewObject = StructureObjectCustomization.getViewObject(structure, false);
        return viewObject != null ? ((StructureDefinitionStructure)structure).getStructureProvider().getManager().getElementFile((Object)viewObject) : null;
    }

    static StructureObjectCustomization getCustomization(IStructureObject structureObject, boolean create) {
        if (structureObject.canCustomize()) {
            assert (structureObject instanceof IStructureChild) : "This method only deals with customizations on IStructureChild";
            PDefViewObject viewObject = StructureObjectCustomization.getViewObject(DTRTObjectUtil.getStructure((IStructureObject)structureObject), create);
            if (viewObject != null) {
                BaseAttribute attribute = viewObject.getBaseAttribute(structureObject.getId());
                if (attribute != null && StructureObjectCustomization.hasSupportedCustomizations(attribute)) {
                    return StructureObjectCustomization.createCustomization((IStructureChild)structureObject, attribute);
                }
                if (create) {
                    IStructureChild structureChild = (IStructureChild)structureObject;
                    if (attribute == null) {
                        assert (structureChild.getKind() != IStructureChild.StructureChildKind.EXTRINSIC);
                        attribute = viewObject.createPDefAttribute(structureChild.getId());
                        assert (attribute != null);
                    }
                    return StructureObjectCustomization.createCustomization(structureChild, attribute);
                }
            }
        }
        return null;
    }

    static boolean hasCustomization(IStructureObject structureObject) {
        PDefViewObject viewObject;
        StructureObjectType structureObjectType = StructureObjectType.getStructureObjectType(structureObject);
        if ((structureObjectType == StructureObjectType.ATTRIBUTE || structureObjectType == StructureObjectType.ACCESSOR) && (viewObject = StructureObjectCustomization.getViewObject(DTRTObjectUtil.getStructure((IStructureObject)structureObject), false)) != null) {
            BaseAttribute attribute = viewObject.getBaseAttribute(structureObject.getId());
            return attribute != null && StructureObjectCustomization.hasSupportedCustomizations(attribute);
        }
        return false;
    }

    private static StructureObjectCustomization createCustomization(IStructureChild structureChild, BaseAttribute attribute) {
        ArrayList<String> ids = new ArrayList<String>(5);
        ids.add(structureChild.getId());
        IStructureObject ancestor = structureChild.getParent();
        while (!(ancestor instanceof IStructure)) {
            ids.add(ancestor.getId());
            ancestor = ancestor.getParent();
        }
        StringBuilder sb = new StringBuilder(DTRTObjectUtil.getStructure((IStructureObject)structureChild).getQualifiedName());
        int i = 0;
        while (i < ids.size()) {
            sb.append('.').append((String)ids.get(i));
            ++i;
        }
        return new StructureObjectCustomization(StructureUtil.getStructureProvider((IStructureObject)structureChild).getManager(), attribute, structureChild.getKind(), StructureObjectType.getStructureObjectType((IStructureObject)structureChild), sb.toString());
    }

    static boolean canHaveCustomization(IStructureObject structureObject) {
        IStructure structure;
        IDescriptor sourceTypeDescriptor;
        StructureObjectType structureObjectType;
        if (!(structureObject == null || structureObject.isDisposed() || (structureObjectType = StructureObjectType.getStructureObjectType(structureObject)) != StructureObjectType.ATTRIBUTE || (sourceTypeDescriptor = (structure = DTRTObjectUtil.getStructure((IStructureObject)structureObject)).getSourceTypeDescriptor()) == null || DTRTUtil.equals((Object)DTRTUtil.getLabel((IDescriptor)sourceTypeDescriptor), (Object)DTRTUtil.getLabel((IDescriptor)StructureUtil.ADF_STRUCTURE_DESCRIPTOR)) || StructureUtil.isCollection((IStructureChild)structureObject))) {
            if (((IStructureChild)structureObject).getKind() == IStructureChild.StructureChildKind.EXTRINSIC) {
                return true;
            }
            BeanStructure beanStructure = StructureUtil.getBeanStructure(structure);
            if (beanStructure == null) {
                return true;
            }
        }
        return false;
    }

    private static PDefViewObject getViewObject(IStructure structure, boolean create) {
        IDTRTManager manager;
        String viewObjectFullName;
        if (structure instanceof StructureDefinitionStructure && (viewObjectFullName = (manager = ((StructureDefinitionStructure)structure).getStructureProvider().getManager()).computeViewObjectFullName(structure.getQualifiedName())) != null) {
            return manager.getViewObject(viewObjectFullName, create);
        }
        return null;
    }

    private static boolean hasSupportedCustomizations(BaseAttribute baseAttribute) {
        if (baseAttribute != null) {
            if (baseAttribute.getLOVName() != null) {
                return true;
            }
            if (baseAttribute.hasSchemaBasedProperties(SchemaBasedProperty.SchemaBasedPropertyType.LABEL, SchemaBasedProperty.SchemaBasedPropertyType.TOOL_TIP_TEXT)) {
                return true;
            }
        }
        return false;
    }

    private static Pattern getADFBundleELPattern() {
        return adfbundleELPattern == null ? (adfbundleELPattern = Pattern.compile(ADFBUNDLE_EL_REGEX)) : adfbundleELPattern;
    }

    private StructureObjectCustomization(IDTRTManager manager, BaseAttribute baseAttribute, IStructureChild.StructureChildKind structureChildKind, StructureObjectType structureObjectType, String fullName) {
        this.manager = manager;
        this.baseAttribute = baseAttribute;
        this.structureChildKind = structureChildKind;
        this.structureObjectType = structureObjectType;
        this.fullName = fullName;
    }

    public void dispose() {
        this.manager = null;
        this.baseAttribute = null;
        this.structureChildKind = null;
        this.fullName = null;
        this.labelProperty = null;
        this.toolTipTextProperty = null;
        this.lov = null;
    }

    public boolean isDisposed() {
        if (this.baseAttribute != null && (this.baseAttribute.getElement() == null || this.baseAttribute.getViewObject() == null || this.baseAttribute.getViewObject().getElement() == null || this.baseAttribute.getElement().getParentNode() != this.baseAttribute.getViewObject().getElement())) {
            this.dispose();
        }
        return this.baseAttribute == null;
    }

    public IStructureChild.StructureChildKind getStructureChildKind() {
        return this.structureChildKind;
    }

    public StructureObjectType getStructureObjectType() {
        return this.structureObjectType;
    }

    public BaseAttribute getBaseAttribute() {
        return this.baseAttribute;
    }

    public boolean isEmpty() {
        return this.isDisposed() || this.getLOV() == null && this.getLabel() == null && this.getToolTipText() == null;
    }

    private IDTRTManager getManager() {
        return this.manager;
    }

    public Set<IFile> getCustomizationFiles() {
        IDTRTManager manager = this.getManager();
        if (manager != null) {
            IFile file;
            LinkedHashSet<IFile> files = new LinkedHashSet<IFile>(3);
            if (this.structureChildKind == IStructureChild.StructureChildKind.EXTRINSIC || this.getLOV() != null) {
                files.add(manager.getElementFile(this.baseAttribute));
            }
            if (this.getLabel() != null) {
                files.add(manager.getElementFile(this.baseAttribute));
                file = manager.getElementFile(this.labelProperty.getFirst());
                if (file != null) {
                    files.add(file);
                }
            }
            if (this.getToolTipText() != null) {
                files.add(manager.getElementFile(this.baseAttribute));
                file = manager.getElementFile(this.toolTipTextProperty.getFirst());
                if (file != null) {
                    files.add(file);
                }
            }
            if (!files.isEmpty()) {
                return files;
            }
        }
        return new HashSet<IFile>(0);
    }

    public Object getValue(SetableFeature feature) {
        if (feature != null) {
            switch (feature) {
                case LABEL: {
                    return this.getLabel();
                }
                case TOOL_TIP_TEXT: {
                    return this.getToolTipText();
                }
            }
        }
        return null;
    }

    public void setValue(SetableFeature feature, Object value) throws Exception {
        if (feature != null) {
            switch (feature) {
                case LABEL: {
                    this.setLabel((String)value);
                    break;
                }
                case TOOL_TIP_TEXT: {
                    this.setToolTipText((String)value);
                    break;
                }
                case LOVFeature: {
                    this.setLOV((LOV)value);
                }
            }
        }
    }

    public String getLabel() {
        if (this.labelProperty == null) {
            this.labelProperty = this.getProperty(SetableFeature.LABEL, false);
        }
        return this.getPropertyValue(this.labelProperty);
    }

    public void setLabel(String label) throws Exception {
        this.labelProperty = this.setProperty(SetableFeature.LABEL, this.labelProperty, label);
    }

    public String getToolTipText() {
        if (this.toolTipTextProperty == null) {
            this.toolTipTextProperty = this.getProperty(SetableFeature.TOOL_TIP_TEXT, false);
        }
        return this.getPropertyValue(this.toolTipTextProperty);
    }

    public void setToolTipText(String toolTipText) throws Exception {
        this.toolTipTextProperty = this.setProperty(SetableFeature.TOOL_TIP_TEXT, this.toolTipTextProperty, toolTipText);
    }

    public LOV getLOV() {
        if (this.lov == null && !this.isDisposed()) {
            LOV lov = new LOV();
            lov.setName(this.baseAttribute.getLOVName());
            if (lov.getName() != null) {
                PDefViewObject viewObject = this.baseAttribute.getViewObject();
                ListBinding listBinding = viewObject.getListBinding(lov.getName());
                if (listBinding != null) {
                    ViewAccessor viewAccessor;
                    AttrArray listDisplayAtttNameListAttrArray;
                    SchemaBasedProperty controlTypeProperty;
                    AttrArray nameListAttrArray = listBinding.getAttrArray("ListAttrNames");
                    if (nameListAttrArray != null) {
                        List<? extends String> itemValues = nameListAttrArray.getItemValues();
                        lov.setListAttributeName(itemValues.size() == 1 ? itemValues.get(0) : null);
                    }
                    if ((controlTypeProperty = this.baseAttribute.getSchemaBasedProperty(SchemaBasedProperty.SchemaBasedPropertyType.CONTROL_TYPE)) != null) {
                        String value = controlTypeProperty.getValue();
                        lov.setControlType(LOVControlType.getLOVListType(value));
                    }
                    if ((listDisplayAtttNameListAttrArray = listBinding.getAttrArray("ListDisplayAttrNames")) != null) {
                        lov.getModifiableDisplayAttributeNames().addAll(listDisplayAtttNameListAttrArray.getItemValues());
                    }
                    if ((viewAccessor = viewObject.getViewAccessor(listBinding.getListVOName())) != null) {
                        lov.setViewAccessorName(viewAccessor.getName());
                        lov.setRowLevelBinds(viewAccessor.isRowLevelBinds());
                        lov.setRawViewInstanceName(viewAccessor.getViewInstanceName());
                    }
                }
                this.lov = lov;
            }
        }
        return this.lov;
    }

    public void setLOV(LOV lov) throws Exception {
        if (!LOV.areIdentical(this.getLOV(), lov)) {
            IStatus status;
            if (lov != null && !(status = StructureObjectValidator.INSTANCE.validate(this, lov)).isOK()) {
                throw new CoreException(status);
            }
            this.clearCurrentLOV();
            if (lov != null) {
                ViewAccessor viewAccessor;
                this.baseAttribute.setLOVName(lov.getName());
                if (lov.getControlType() != null) {
                    SchemaBasedProperty schemaBasedProperty = this.baseAttribute.createSchemaBasedProperty(SchemaBasedProperty.SchemaBasedPropertyType.CONTROL_TYPE);
                    schemaBasedProperty.setValue(lov.getControlType().getId());
                }
                PDefViewObject viewObject = this.baseAttribute.getViewObject();
                ListBinding listBinding = viewObject.createListBinding(lov.getName());
                listBinding.setListVOName(lov.getViewAccessorName());
                AttrArray attrNames = listBinding.createAttrArray("AttrNames");
                attrNames.addItemValue(this.baseAttribute.getName());
                AttrArray listAttrNames = listBinding.createAttrArray("ListAttrNames");
                listAttrNames.addItemValue(lov.getSerializationListAttributeName());
                if (!lov.getDisplayAttributeNames().isEmpty()) {
                    AttrArray listDisplayAttrNames = listBinding.createAttrArray("ListDisplayAttrNames");
                    for (String string : lov.getDisplayAttributeNames()) {
                        listDisplayAttrNames.addItemValue(string);
                    }
                }
                if ((viewAccessor = viewObject.getViewAccessor(lov.getViewAccessorName())) == null) {
                    viewAccessor = viewObject.createViewAccessor(lov.getViewAccessorName());
                }
                viewAccessor.setViewInstanceName(lov.getViewInstanceName());
                viewAccessor.setRowLevelBinds(lov.isRowLevelBinds());
            }
            this.baseAttribute.getViewObject().handleChange(this.baseAttribute);
        }
    }

    public String computeLOVName(String baseName) {
        return baseName != null ? this.computeLOVUniqueName(this.getLOVBindingNames(), baseName) : null;
    }

    public String computeViewAccessorName(String baseName) {
        return baseName != null ? this.computeLOVUniqueName(this.getViewAccessorNames(), baseName) : null;
    }

    private String computeLOVUniqueName(Collection<? extends String> names, String baseName) {
        if (!baseName.startsWith("LOV_")) {
            baseName = "LOV_" + baseName;
        }
        String nameToUse = baseName;
        int i = 1;
        while (names.contains(nameToUse)) {
            nameToUse = String.valueOf(baseName) + i;
            ++i;
        }
        return nameToUse;
    }

    public IStatus isValidLOVName(String name) {
        String message = null;
        if (DTRTUtil.isEmpty((String)name)) {
            message = Messages.lovValidNameEmpty;
        } else if (!JavaUtil.isIdentifier((String)name)) {
            message = NLS.bind((String)Messages.lovValidNameNotValid, (Object)name);
        } else if (this.getLOVBindingNames().contains(name) && (this.getLOV() == null || !name.equals(this.getLOV().getName()))) {
            message = NLS.bind((String)Messages.lovValidNameNotUnique, (Object)name);
        }
        return message != null ? new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message) : Status.OK_STATUS;
    }

    private List<String> getLOVBindingNames() {
        PDefViewObject pdefViewObject = this.getBaseAttribute().getViewObject();
        return pdefViewObject != null ? Collections.unmodifiableList(pdefViewObject.getListBindingNames()) : Collections.emptyList();
    }

    private List<String> getViewAccessorNames() {
        PDefViewObject pdefViewObject = this.getBaseAttribute().getViewObject();
        return pdefViewObject != null ? Collections.unmodifiableList(pdefViewObject.getViewAccessorNames()) : Collections.emptyList();
    }

    private void clearCurrentLOV() {
        String lovName = this.baseAttribute.getLOVName();
        if (lovName != null) {
            this.baseAttribute.setLOVName(null);
            this.baseAttribute.removeSchemaBaseProperty(SchemaBasedProperty.SchemaBasedPropertyType.CONTROL_TYPE);
            PDefViewObject viewObject = this.baseAttribute.getViewObject();
            ListBinding listBinding = viewObject.getListBinding(lovName);
            if (listBinding != null) {
                viewObject.remove(listBinding);
            }
        }
        this.lov = null;
    }

    private String getPropertyValue(Pair<PropertiesElement, String> property) {
        return property != null && property.getFirst() != null ? ((PropertiesElement)property.getFirst()).getProperty((String)property.getSecond()) : null;
    }

    private Pair<PropertiesElement, String> setProperty(SetableFeature feature, Pair<PropertiesElement, String> property, String value) throws Exception {
        if (DTRTUtil.isEmpty((String)value)) {
            if (property != null) {
                PropertiesElement propertiesElement = (PropertiesElement)property.getFirst();
                propertiesElement.setProperty((String)property.getSecond(), null);
                if (!propertiesElement.hasProperties()) {
                    this.getManager().delete(propertiesElement);
                }
                this.baseAttribute.removeSchemaBaseProperty(feature.getSchemaBasedPropertyType());
                PDefViewObject viewObject = this.baseAttribute.getViewObject();
                viewObject.handleChange(this.baseAttribute);
                if (viewObject.isEmpty()) {
                    viewObject.delete();
                }
                property = null;
            }
        } else {
            if (property == null || property.getFirst() == null) {
                property = this.getProperty(feature, true);
            }
            ((PropertiesElement)property.getFirst()).setProperty((String)property.getSecond(), value);
        }
        return property;
    }

    private Pair<PropertiesElement, String> getProperty(SetableFeature feature, boolean create) {
        IDTRTManager manager;
        if (this.isDisposed()) {
            return null;
        }
        SchemaBasedProperty property = this.baseAttribute.getSchemaBasedProperty(feature.getSchemaBasedPropertyType());
        if (property == null && create) {
            property = this.baseAttribute.createSchemaBasedProperty(feature.getSchemaBasedPropertyType());
        }
        if (property != null && (manager = this.getManager()) != null) {
            String[] parsed;
            String resId = property.getResId();
            if (resId != null) {
                parsed = StructureObjectCustomization.parseADFBundleEL(resId);
            } else if (create) {
                parsed = new String[]{DEFAULT_PROPERTIES_ELEMENT, String.valueOf(this.fullName) + '_' + feature.getSchemaBasedPropertyType().getElementTag()};
                property.setResId(StructureObjectCustomization.createADFBundleEL(parsed[0], parsed[1]));
            } else {
                parsed = null;
            }
            if (parsed != null) {
                assert (parsed.length == 2) : resId;
                PropertiesElement propertiesElement = manager.getPropertiesElement(parsed[0], create);
                if (propertiesElement != null) {
                    return new Pair((Object)propertiesElement, (Object)parsed[1]);
                }
                return null;
            }
        }
        return new Pair(null, null);
    }

    private static String createADFBundleEL(String propertiesElementName, String key) {
        return "${adfBundle['" + propertiesElementName + "']['" + key + "']}";
    }

    private static String[] parseADFBundleEL(String el) {
        Matcher matcher;
        if (!DTRTUtil.isEmpty((String)el) && (matcher = StructureObjectCustomization.getADFBundleELPattern().matcher(el)).matches() && matcher.groupCount() == 4) {
            return new String[]{matcher.group(2), matcher.group(4)};
        }
        return null;
    }

    public static final class EditableLOV
    extends LOV {
        public static EditableLOV createCopy(LOV lov) {
            EditableLOV copy = new EditableLOV();
            if (lov != null) {
                copy.setName(lov.getName());
                copy.setViewAccessorName(lov.getViewAccessorName());
                copy.setRawViewInstanceName(lov.getViewInstanceName());
                copy.setListAttributeName(lov.getListAttributeName());
                copy.setControlType(lov.getControlType());
                if (!lov.getDisplayAttributeNames().isEmpty()) {
                    copy.getModifiableDisplayAttributeNames().addAll(lov.getDisplayAttributeNames());
                }
                copy.setRowLevelBinds(lov.isRowLevelBinds());
            }
            return copy;
        }

        @Override
        public void setName(String name) {
            super.setName(name);
        }

        @Override
        public void setViewAccessorName(String viewAccessorName) {
            super.setViewAccessorName(viewAccessorName);
        }

        @Override
        public void setViewInstanceName(String viewInstanceName) {
            super.setViewInstanceName(viewInstanceName);
        }

        @Override
        public void setListAttributeName(String listAttributeName) {
            super.setListAttributeName(listAttributeName);
        }

        @Override
        public void setControlType(LOVControlType controlType) {
            super.setControlType(controlType);
        }

        @Override
        public void setRowLevelBinds(boolean rowLevelBinds) {
            super.setRowLevelBinds(rowLevelBinds);
        }

        @Override
        public List<String> getModifiableDisplayAttributeNames() {
            return super.getModifiableDisplayAttributeNames();
        }
    }

    public static class LOV {
        private String name;
        private LOVControlType controlType;
        private String listAttributeName;
        private String viewAccessorName;
        private String viewInstanceName;
        private boolean rowLevelBinds = true;
        private List<String> displayAttributes;

        public static boolean isValidViewInstanceName(String name) {
            return !DTRTUtil.isEmpty((String)name) && !name.equals("datacontrol.");
        }

        public static String isValidViewInstanceNameScheme(String name) {
            return name == null || name.startsWith("datacontrol.") ? null : "datacontrol.";
        }

        public static boolean areIdentical(LOV lov1, LOV lov2) {
            if (lov1 == lov2) {
                return true;
            }
            return lov1 != null && lov2 != null && DTRTUtil.equals((Object)lov1.name, (Object)lov2.name) && lov1.controlType == lov2.controlType && DTRTUtil.equals((Object)lov1.listAttributeName, (Object)lov2.listAttributeName) && DTRTUtil.equals((Object)lov1.viewAccessorName, (Object)lov2.viewAccessorName) && DTRTUtil.equals((Object)lov1.viewInstanceName, (Object)lov2.viewInstanceName) && lov1.rowLevelBinds == lov2.rowLevelBinds && DTRTUtil.equals(lov1.displayAttributes, lov2.displayAttributes);
        }

        LOV() {
        }

        public final String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = DTRTUtil.isEmpty((String)name) ? null : name;
        }

        public final String getViewAccessorName() {
            return this.viewAccessorName;
        }

        void setViewAccessorName(String viewAccessorName) {
            this.viewAccessorName = viewAccessorName;
        }

        public final String getViewInstanceName() {
            return this.viewInstanceName;
        }

        void setRawViewInstanceName(String viewInstanceName) {
            this.viewInstanceName = viewInstanceName;
        }

        void setViewInstanceName(String viewInstanceName) {
            if (viewInstanceName != null) {
                assert (LOV.isValidViewInstanceName(viewInstanceName)) : viewInstanceName;
                if (!viewInstanceName.startsWith("datacontrol.")) {
                    viewInstanceName = "datacontrol." + viewInstanceName;
                }
            }
            this.viewInstanceName = viewInstanceName;
        }

        public final boolean isRowLevelBinds() {
            return this.rowLevelBinds;
        }

        void setRowLevelBinds(boolean rowLevelBinds) {
            this.rowLevelBinds = rowLevelBinds;
        }

        final String getSerializationListAttributeName() {
            return this.listAttributeName == null ? "dataProvider" : this.listAttributeName;
        }

        public final String getListAttributeName() {
            return this.listAttributeName;
        }

        void setListAttributeName(String listAttributeName) {
            this.listAttributeName = DTRTUtil.isEmpty((String)listAttributeName) ? null : ("dataProvider".equals(listAttributeName) ? null : listAttributeName);
        }

        public final LOVControlType getControlType() {
            return this.controlType == null ? LOVControlType.getLOVListType(null) : this.controlType;
        }

        void setControlType(LOVControlType controlType) {
            this.controlType = controlType;
        }

        public final List<? extends String> getDisplayAttributeNames() {
            return DTRTUtil.toUnmodifiablePrunedList(this.displayAttributes);
        }

        List<String> getModifiableDisplayAttributeNames() {
            return this.displayAttributes == null ? (this.displayAttributes = new LinkedList<String>()) : this.displayAttributes;
        }

        public final int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof LOV)) {
                return false;
            }
            LOV other = (LOV)obj;
            return DTRTUtil.equals((Object)this.name, (Object)other.name);
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(" [name=");
            builder.append(this.name);
            builder.append(", viewInstanceName=");
            builder.append(this.viewInstanceName);
            builder.append(", listAttributeName=");
            builder.append(this.listAttributeName);
            builder.append("]");
            return builder.toString();
        }
    }

    public static enum LOVControlType implements IDescribable
    {
        CHOICE("choice", Messages.lovControlTypechoice, Messages.lovControlTypechoiceToolTipText, null),
        COMBO("combo", Messages.lovControlTypecombo, Messages.lovControlTypecomboToolTipText, null),
        COMBO_LOV("combo_lov", Messages.lovControlTypecombo_lov, Messages.lovControlTypecombo_lovToolTipText, null),
        INPUT_TEXT_LOV("input_text_lov", Messages.lovControlTypeinput_text_lov, Messages.lovControlTypeinput_text_lovToolTipText, null),
        LIST("list", Messages.lovControlTypelist, Messages.lovControlTypelistToolTipText, null),
        RADIO("radio", Messages.lovControlTyperadio, Messages.lovControlTyperadioToolTipText, null);

        private String id;
        private BaseDescriptor descriptor;

        public static LOVControlType getLOVListType(String controlType) {
            LOVControlType[] values = LOVControlType.values();
            if (controlType != null) {
                int i = 0;
                while (i < values.length) {
                    if (values[i].getId().equals(controlType)) {
                        return values[i];
                    }
                    ++i;
                }
                return null;
            }
            return values[0];
        }

        private LOVControlType(String id, String label, String toolTipText, ImageManager.IImageData imageData) {
            this.descriptor = new BasicDescriptor(label, toolTipText, imageData);
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public IDescriptor getDescriptor() {
            return this.descriptor;
        }
    }

    public static enum SetableFeature implements IDescribable
    {
        LABEL(Messages.featureLabel, null, null, SchemaBasedProperty.SchemaBasedPropertyType.LABEL),
        TOOL_TIP_TEXT(Messages.featureToolTipText, null, null, SchemaBasedProperty.SchemaBasedPropertyType.TOOL_TIP_TEXT),
        LOVFeature(Messages.featureLOV, null, null, null);

        private BaseDescriptor descriptor;
        private SchemaBasedProperty.SchemaBasedPropertyType schemaBasedPropertyType;

        private SetableFeature(String label, String toolTipText, ImageManager.IImageData imageData, SchemaBasedProperty.SchemaBasedPropertyType schemaBasedPropertyType) {
            this.descriptor = new BasicDescriptor(label, toolTipText, imageData);
            this.schemaBasedPropertyType = schemaBasedPropertyType;
        }

        public IDescriptor getDescriptor() {
            return this.descriptor;
        }

        public Class<?> getType() {
            return this == LOVFeature ? LOV.class : String.class;
        }

        SchemaBasedProperty.SchemaBasedPropertyType getSchemaBasedPropertyType() {
            return this.schemaBasedPropertyType;
        }
    }
}

